/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.repopaths.FilenameEscape;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipPacker {
    private ZipOutputStream mZipOutStream;
    private byte[] mBytes = new byte[65536];
    private static final String UNICODE_MARKER = "_u_NiC__odE";

    public ZipPacker(ZipOutputStream inZipOutputStream) throws ResourceException {
        this.mZipOutStream = inZipOutputStream;
        this.mZipOutStream.setMethod(8);
        this.mZipOutStream.setLevel(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(ZipEntry inZipEntry, InputStream inInputStream) throws IOException {
        this.mZipOutStream.putNextEntry(inZipEntry);
        if (inInputStream != null) {
            try {
                int len;
                while ((len = inInputStream.read(this.mBytes)) != -1) {
                    this.mZipOutStream.write(this.mBytes, 0, len);
                }
                this.mZipOutStream.closeEntry();
            }
            finally {
                inInputStream.close();
            }
        }
    }

    private static String entryName_RsrcToZip(String inRelPath) {
        String theRelPath = inRelPath.replace('\\', '/');
        String theEntryName = FilenameEscape.escapeUnicode(theRelPath);
        if (!theEntryName.equals(theRelPath)) {
            theEntryName = UNICODE_MARKER + theEntryName;
        }
        return theEntryName;
    }

    public static String entryName_ZipToRsrc(ZipEntry inZipEntry) throws ResourceException {
        String theResult = inZipEntry.getName();
        if (theResult.startsWith(UNICODE_MARKER)) {
            theResult = FilenameEscape.unescapeUnicode(theResult.substring(UNICODE_MARKER.length(), theResult.length()));
        }
        return theResult;
    }

    public void packEntry(String inRelPath, long inUncompressedSize, long inTime, SubnodeType inSubnodeType, InputStream inInputStream) throws ResourceException {
        block5: {
            ZipEntry theZipEntry = new ZipEntry(ZipPacker.entryName_RsrcToZip(inRelPath));
            try {
                if (inSubnodeType.equals(SubnodeType.DIRECTORY)) {
                    theZipEntry.setSize(0L);
                    this.pack(theZipEntry, null);
                    break block5;
                }
                if (inSubnodeType.equals(SubnodeType.SYMLINK)) {
                    theZipEntry.setSize(0L);
                    theZipEntry.setExtra(ResourceEntry.encodeZipExtra(inUncompressedSize, inTime, null, null));
                    this.pack(theZipEntry, null);
                    break block5;
                }
                if (inSubnodeType.equals(SubnodeType.FILE)) {
                    theZipEntry.setSize(inUncompressedSize);
                    theZipEntry.setTime(inTime);
                    this.pack(theZipEntry, inInputStream);
                    break block5;
                }
                throw new UnsupportedOperationException();
            }
            catch (IOException e) {
                throw new ResourceIOException("rsrc.msg0277", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws ResourceException {
        block5: {
            try {
                if (this.mZipOutStream == null) break block5;
                try {
                    this.mZipOutStream.flush();
                    this.mZipOutStream.close();
                }
                finally {
                    this.mZipOutStream = null;
                }
            }
            catch (IOException e) {
                throw new ResourceIOException("rsrc.msg0278", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        block5: {
            try {
                if (this.mZipOutStream == null) break block5;
                try {
                    this.mZipOutStream.flush();
                    this.mZipOutStream.close();
                }
                finally {
                    this.mZipOutStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

