/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceProcessException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.packageformat.ZipArchive;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFileExpander {
    private File mSrcFile;
    private File mDstRoot;
    private boolean mCanOverwrite;

    public ZipFileExpander(File inSrcFile, File inDstRoot, boolean inCanOverwrite) throws ResourceException {
        this.mSrcFile = inSrcFile;
        this.mDstRoot = inDstRoot;
        this.mCanOverwrite = inCanOverwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws ResourceException {
        this.beginParse();
        try {
            ZipFile theZipFile = new ZipFile(this.getSrcFile());
            boolean isHigherException = true;
            try {
                ZipEntry theZipEntry;
                Enumeration<? extends ZipEntry> theEntries = theZipFile.entries();
                int theEntryIdx = 0;
                while (theEntries.hasMoreElements() && (theZipEntry = theEntries.nextElement()) != null) {
                    if (!ZipArchive.isManifestEntry(theZipEntry) && theZipEntry.getName().length() != 0) {
                        InputStream theInputStream;
                        try {
                            theInputStream = theZipFile.getInputStream(theZipEntry);
                        }
                        catch (IOException e) {
                            theInputStream = null;
                        }
                        try {
                            ResourceEntry theResourceEntry = new ResourceEntry(theZipEntry);
                            if (this.processEntry(theResourceEntry, theEntryIdx, theInputStream)) {
                                break;
                            }
                        }
                        finally {
                            if (theInputStream != null) {
                                theInputStream.close();
                            }
                        }
                    }
                    ++theEntryIdx;
                }
                isHigherException = false;
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                block20: {
                    Object var10_13 = null;
                    try {
                        theZipFile.close();
                    }
                    catch (IOException e) {
                        if (isHigherException) break block20;
                        throw new ResourceException("rsrc.msg0261", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                theZipFile.close();
            }
            catch (IOException e) {
                if (!isHigherException) {
                    throw new ResourceException("rsrc.msg0261", (Throwable)e);
                }
            }
        }
        catch (ZipException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void beginParse() throws ResourceException {
        if (this.mDstRoot.exists()) {
            if (!this.mCanOverwrite) {
                throw new ResourceException("rsrc.msg0258", new Object[]{this.mDstRoot});
            }
            ResourceFileUtils.deleteDirectory(this.mDstRoot);
        }
    }

    public File getSrcFile() {
        return this.mSrcFile;
    }

    public boolean processEntry(ResourceEntry inResEntry, int inEntryIdx, InputStream inInputStream) throws ResourceProcessException, ResourceException {
        String theDstFileString = this.mDstRoot.getAbsolutePath() + File.separatorChar + ResourceStringUtils.toNativePath(ResourceParser.stripRoot(inResEntry.getRelPathWFwdSlashes()));
        theDstFileString = ResourceStringUtils.toNativePath(theDstFileString);
        File theSubFile = new File(theDstFileString);
        if (inResEntry.getType().equals(SubnodeType.DIRECTORY)) {
            theSubFile.mkdirs();
        } else if (inResEntry.getType().equals(SubnodeType.FILE)) {
            theSubFile.getParentFile().mkdirs();
            ResourceFileUtils.writeStreamToFile(theSubFile, inResEntry.getTime(), inInputStream);
        } else if (inResEntry.getType().equals(SubnodeType.SYMLINK)) {
            theSubFile.getParentFile().mkdirs();
            ResourceFileUtils.createLink(theSubFile, inResEntry.getLinkTarget());
        } else {
            throw new UnsupportedOperationException();
        }
        return false;
    }
}

