/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.HierarchyTraverser;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.packageformat.ZipPacker;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipArchive
extends HierarchyTraverser {
    public static final String sManifestLabel = "<RESOURCE_MANIFEST>";
    private ZipPacker mZipPacker;
    private PermOptions mPermOpts = null;

    public ZipArchive(File inFileOrDirToZip, File inDstPkgFile, PermOptions inPermOpts) throws FileNotFoundException, IOException, ResourceException {
        super(inFileOrDirToZip);
        if (inPermOpts == null) {
            throw new NullPointerException();
        }
        this.mPermOpts = inPermOpts;
        this.mZipPacker = new ZipPacker(new ZipOutputStream(new FileOutputStream(inDstPkgFile)));
    }

    public void finish() throws IOException, ResourceException {
        this.mZipPacker.finish();
        this.mZipPacker = null;
    }

    public static boolean isManifestEntry(ZipEntry inEntry) {
        if (inEntry == null) {
            return false;
        }
        String theName = inEntry.getName();
        if (theName == null) {
            return false;
        }
        return theName.indexOf(sManifestLabel) != -1;
    }

    private ResourceEntry createEntry(File inFileOrDir, String inRelPath, PermOptions inPermOpts) throws ResourceException {
        if (inPermOpts == null) {
            throw new NullPointerException();
        }
        SubnodeType theSubnodeType = ResourceFileUtils.getSubnodeType(inFileOrDir);
        String theLinkTarget = ResourceFileUtils.getLinkTarget(inFileOrDir);
        long theSize = 0L;
        long theTime = 0L;
        if (theSubnodeType.equals(SubnodeType.FILE)) {
            theSize = inFileOrDir.length();
            theTime = inFileOrDir.lastModified();
        }
        NodePerms theNodePerms = null;
        if (!inPermOpts.suppress()) {
            theNodePerms = PlatformPermissionFactory.getInstance().createNodePerms(inFileOrDir, inPermOpts);
        }
        return ZipArchive.createEntry(inRelPath, theSubnodeType, theSize, theTime, theNodePerms, theLinkTarget);
    }

    public static ResourceEntry createEntry(String inRelPath, SubnodeType inSubnodeType, long inSize, long inTime, NodePerms inNodePerms, String inLinkTarget) throws ResourceException {
        boolean isDir = inSubnodeType.equals(SubnodeType.DIRECTORY);
        if (!inSubnodeType.equals(SubnodeType.SYMLINK) && isDir != ResourceStringUtils.endsInSeparator(inRelPath)) {
            throw new ResourceException("rsrc.msg0276");
        }
        String theRelPath = inRelPath.replace('\\', '/');
        theRelPath = "root" + ResourceParser.stripRoot(theRelPath);
        if (isDir) {
            inSize = 0L;
        }
        return new ResourceEntry(theRelPath, inSize, inTime, inSubnodeType, null, inNodePerms, null, inLinkTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileOrDir(File inFileOrDir, String inRelPath) throws ResourceException {
        ResourceEntry theResourceEntry = this.createEntry(inFileOrDir, inRelPath, this.mPermOpts);
        try {
            FileInputStream theInputStream = null;
            if (theResourceEntry.getType().equals(SubnodeType.FILE)) {
                theInputStream = new FileInputStream(inFileOrDir);
            }
            try {
                this.mZipPacker.packEntry(theResourceEntry.getRelPathWFwdSlashes(), theResourceEntry.getSize(), theResourceEntry.getTime(), theResourceEntry.getType(), theInputStream);
            }
            finally {
                if (theInputStream != null) {
                    theInputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }
}

