/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

public abstract class StringSearcher {
    public static final int NOT_FOUND = -1;

    public abstract int getNumStrings();

    public abstract String get(int var1);

    public abstract int compare(String var1, String var2);

    public final boolean isLTE(String inStr1, String inStr2) {
        return this.compare(inStr1, inStr2) <= 0;
    }

    public int getFirstMaxIdxLTE(String inSoughtString) {
        int theHighIdx = this.getNumStrings();
        if (theHighIdx == 0) {
            return -1;
        }
        if (!this.isLTE(this.get(0), inSoughtString)) {
            return -1;
        }
        int theLowIdx = 0;
        int theMidIdx = theLowIdx + theHighIdx >> 1;
        int thePrevMidIdx = -1;
        while (thePrevMidIdx != theMidIdx) {
            thePrevMidIdx = theMidIdx;
            int theComp = this.compare(this.get(theMidIdx), inSoughtString);
            if (theComp < 0) {
                theLowIdx = theMidIdx;
            } else if (theComp > 0) {
                theHighIdx = theMidIdx;
            } else {
                theMidIdx = this.backstepToFirst(theMidIdx);
                return theMidIdx;
            }
            theMidIdx = theLowIdx + theHighIdx >> 1;
        }
        return theMidIdx;
    }

    private int backstepToFirst(int inIdx) {
        int theResult = inIdx;
        String theString = this.get(theResult);
        for (int theStep = 8; theStep > 0; theStep >>= 1) {
            int theCandidate;
            while ((theCandidate = theResult - theStep) >= 0 && this.compare(this.get(theCandidate), theString) == 0) {
                theResult = theCandidate;
            }
        }
        return theResult;
    }

    public int getFirstExactMatch(String inRelPath) {
        int theResult = this.getFirstMaxIdxLTE(inRelPath);
        if (this.get(theResult).equals(inRelPath)) {
            return theResult;
        }
        return -1;
    }
}

