/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegmentMetaData;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;

public class SegIter {
    private RsrcManifest mRsrcManifest;
    private int mSegmentIdx;
    private MetaMetaData mMetaMetaData;
    private SegmentMetaData mCurSegMetaData;
    private int mCurEntryIdx;
    private boolean mBackwards = false;
    private SegEntry mCachedNextSubfile = null;
    private SegEntry mCachedNextSegEntry = null;
    private SegEntry mCachedNextSubfileWBackRef = null;

    public static SegIter makeIter(Object inKey, RsrcManifest inRsrcManifest) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        return new SegIter(inRsrcManifest, false);
    }

    public static SegIter makeBackwardsIter(Object inKey, RsrcManifest inRsrcManifest) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        return new SegIter(inRsrcManifest, true);
    }

    private SegIter(RsrcManifest inRsrcManifest, boolean inBackwards) throws ResourceException {
        this.mRsrcManifest = inRsrcManifest;
        this.mMetaMetaData = inRsrcManifest.getMetaMetaData(Key.sKey);
        this.mBackwards = inBackwards;
        if (!inBackwards) {
            this.mSegmentIdx = 0;
            this.mCurSegMetaData = this.mRsrcManifest.getSegmentMetaData(0);
            this.mCurEntryIdx = 0;
        } else {
            this.mSegmentIdx = this.mRsrcManifest.getNumSegments() - 1;
            this.mCurSegMetaData = this.mRsrcManifest.getSegmentMetaData(this.mSegmentIdx);
            this.mCurEntryIdx = this.mCurSegMetaData.mEntries.length - 1;
        }
    }

    public void setRelPathAsNext(String inRelPath) throws ResourceException {
        int[] theFirstClusterSegDesc;
        this.clearCachedNexts();
        if (this.mBackwards) {
            MiscUtils.throwUPE(1340501L);
        }
        if ((theFirstClusterSegDesc = this.mRsrcManifest.getFirstClusterSegDesc(Key.sKey, inRelPath)) != null) {
            this.mSegmentIdx = theFirstClusterSegDesc[0];
            this.mCurEntryIdx = theFirstClusterSegDesc[1];
            this.mCurSegMetaData = this.mRsrcManifest.getSegmentMetaData(this.mSegmentIdx);
        } else {
            this.mCurSegMetaData = null;
        }
    }

    private void clearCachedNexts() {
        this.mCachedNextSubfile = null;
        this.mCachedNextSegEntry = null;
        this.mCachedNextSubfileWBackRef = null;
    }

    private void step() {
        this.mCurEntryIdx += this.mBackwards ? -1 : 1;
    }

    private void stepAndClearCaches() {
        this.step();
        this.clearCachedNexts();
    }

    public boolean hasMoreSubfiles() throws ResourceException {
        return this.mCachedNextSubfile != null ? true : (this.mCachedNextSubfile = this.getNext(true, false)) != null;
    }

    public boolean hasMoreSegEntries() throws ResourceException {
        return this.mCachedNextSegEntry != null ? true : (this.mCachedNextSegEntry = this.getNext(false, false)) != null;
    }

    public boolean hasMoreSubfilesWBackRefs() throws ResourceException {
        return this.mCachedNextSubfileWBackRef != null ? true : (this.mCachedNextSubfileWBackRef = this.getNext(true, true)) != null;
    }

    private SegEntry getNext(boolean inWantSubfilesOnly, boolean inWantNonNullBackRefsOnly) throws ResourceException {
        SegEntry theNextEntry;
        if (inWantNonNullBackRefsOnly && !inWantSubfilesOnly) {
            MiscUtils.throwUPE(1340502L);
        }
        this.clearCachedNexts();
        while (true) {
            if (this.mCurSegMetaData == null) {
                return null;
            }
            if (this.mCurEntryIdx >= this.mCurSegMetaData.mEntries.length || this.mCurEntryIdx < 0) {
                if (this.mBackwards) {
                    do {
                        --this.mSegmentIdx;
                        if (this.mSegmentIdx >= 0) continue;
                        this.mCurSegMetaData = null;
                        return null;
                    } while (inWantNonNullBackRefsOnly && !this.mMetaMetaData.mPerSegMetaMetaDatas[this.mSegmentIdx].mHasBackRefs);
                    this.mCurSegMetaData = this.mRsrcManifest.getSegmentMetaData(this.mSegmentIdx);
                    this.mCurEntryIdx = this.mCurSegMetaData.mEntries.length - 1;
                    continue;
                }
                do {
                    ++this.mSegmentIdx;
                    if (this.mSegmentIdx < this.mMetaMetaData.mPerSegMetaMetaDatas.length) continue;
                    this.mCurSegMetaData = null;
                    return null;
                } while (inWantNonNullBackRefsOnly && !this.mMetaMetaData.mPerSegMetaMetaDatas[this.mSegmentIdx].mHasBackRefs);
                this.mCurSegMetaData = this.mRsrcManifest.getSegmentMetaData(this.mSegmentIdx);
                this.mCurEntryIdx = 0;
                continue;
            }
            theNextEntry = this.mCurSegMetaData.mEntries[this.mCurEntryIdx];
            if (!inWantSubfilesOnly) break;
            if (!(theNextEntry.getClusterIdx() != 0 || inWantNonNullBackRefsOnly && theNextEntry.getBackRef() == null)) {
                return theNextEntry;
            }
            this.step();
        }
        if (this.mBackwards) {
            MiscUtils.throwUPE(1340503L);
        }
        return theNextEntry;
    }

    public SegEntry getNextSegEntry() throws ResourceException {
        this.validate();
        if (!this.hasMoreSegEntries()) {
            return null;
        }
        SegEntry theResult = this.mCachedNextSegEntry;
        this.stepAndClearCaches();
        return theResult;
    }

    public SegEntry getNextSubfile() throws ResourceException {
        this.validate();
        if (!this.hasMoreSubfiles()) {
            return null;
        }
        SegEntry theResult = this.mCachedNextSubfile;
        this.stepAndClearCaches();
        return theResult;
    }

    public SegEntry getNextSubfileWBackRef() throws ResourceException {
        this.validate();
        if (!this.hasMoreSubfilesWBackRefs()) {
            return null;
        }
        SegEntry theResult = this.mCachedNextSubfileWBackRef;
        this.stepAndClearCaches();
        return theResult;
    }

    public String peekNextSubfileRelPath() throws ResourceException {
        return this.hasMoreSubfiles() ? this.mCachedNextSubfile.getRelPathWFwdSlashes() : null;
    }

    private void validate() throws ResourceException {
        if (!this.mRsrcManifest.isValid()) {
            MiscUtils.throwUPE(5072128L);
        }
    }
}

