/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.Serializable;

public class SegEntry
implements RPCSerializable,
Serializable {
    private static final int sNoBackRef = 0;
    private String mRelPath = null;
    private long mUncompressedSize = 0L;
    private long mSizePerCompressionSetting = 0L;
    private long mFileTime = 0L;
    private int mBackRefVersion = 0;
    private String mSubnodeTypeString = null;
    private NodePerms mNodePerms = null;
    private String mLinkTarget = null;
    private boolean mCompression;
    private byte[] mFileMd5PerCompressionSetting;
    private int mClusterSize;
    private int mClusterIdx;
    private int mDataSegNum;
    private long mFirstSegByteIdx;
    private long mLastSegByteIdx;

    private SegEntry() {
    }

    private static VersionNumber intToVersion(int inInteger) {
        if (inInteger == 0) {
            return null;
        }
        return new VersionNumber(inInteger);
    }

    public SegEntry(String inRelPath, long inUncompressedSize, long inSizePerCompressionSetting, long inTime, SubnodeType inSubnodeType, NodePerms inNodePerms, String inLinkTarget, byte[] inFileMd5PerCompressionSetting, VersionNumber inBackVersionNumber, int inDataSegNum, long inFirstSegByteIdx, long inLastSegByteIdx, int inServerSegClusterIdx, int inNumSegsInCluster, boolean inCompression) {
        this.mRelPath = ResourceStringUtils.coerceSeparators(inRelPath, '/');
        this.mUncompressedSize = inUncompressedSize;
        this.mSizePerCompressionSetting = inSizePerCompressionSetting;
        this.mFileTime = inTime;
        this.mSubnodeTypeString = inSubnodeType.toString();
        this.mNodePerms = inNodePerms;
        this.mLinkTarget = inLinkTarget;
        this.mBackRefVersion = inBackVersionNumber == null ? 0 : inBackVersionNumber.getSingleVersionNumber();
        this.mFileMd5PerCompressionSetting = inFileMd5PerCompressionSetting;
        this.mDataSegNum = inDataSegNum;
        this.mFirstSegByteIdx = inFirstSegByteIdx;
        this.mLastSegByteIdx = inLastSegByteIdx;
        this.mClusterIdx = inServerSegClusterIdx;
        this.mClusterSize = inNumSegsInCluster;
        this.mCompression = inCompression;
        if (inLinkTarget != null != inSubnodeType.equals(SubnodeType.SYMLINK)) {
            throw new IllegalStateException();
        }
    }

    public String getRelPathWFwdSlashes() {
        return this.mRelPath;
    }

    public long getUncompressedFileSize() {
        return this.mUncompressedSize;
    }

    public long getSizePerCompressionSetting() {
        return this.mSizePerCompressionSetting;
    }

    public long getTime() {
        return this.mFileTime;
    }

    public SubnodeType getType() {
        return SubnodeType.FACTORY.get(this.mSubnodeTypeString);
    }

    public String getLinkTarget() {
        return this.mLinkTarget;
    }

    public NodePerms getPerms() {
        return this.mNodePerms;
    }

    public VersionNumber getBackRef() {
        return SegEntry.intToVersion(this.mBackRefVersion);
    }

    public byte[] getFileMd5PerCompressionSetting() {
        return this.mFileMd5PerCompressionSetting;
    }

    int getDataSegNum() {
        return this.mDataSegNum;
    }

    long getFirstSegByteIdx() {
        return this.mFirstSegByteIdx;
    }

    long getLastSegByteIdx() {
        return this.mLastSegByteIdx;
    }

    int getClusterIdx() {
        return this.mClusterIdx;
    }

    int getClusterSize() {
        return this.mClusterSize;
    }

    public boolean getCompression() {
        return this.mCompression;
    }
}

