/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.OneSegMetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegmentMetaData;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.Checksummer;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.resource.util.StreamClosure;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;

public class RsrcPacker {
    private static final long DEFAULT_MAX_SEG_SIZE = 2040109000L;
    private static final int DEFAULT_MAX_ENTRIES_PER_SEG = 128;
    private long mMaxSegSize = 2040109000L;
    private int mMaxEntriesPerSeg = 128;
    private File mWorkspaceDir;
    private String mTmpRsrcDirStrWTrailingSeparator;
    private Vector mCurSegEntryVec = new Vector();
    private int mNextSegIdx = 0;
    private Vector mAllOneSegMetaMetaDatas = new Vector();
    private MetaMetaData mMetaMetaData = new MetaMetaData();
    private Segmenter mEntrySegmenter;
    private Segmenter mDataSegmenter;
    private String mMostRecentEntryRelPath = null;
    private boolean mDeletedDir = false;
    private CheckInMode mCheckInMode;
    private RedundancyCheckMode mRedundancyMode;
    private VersionNumber mPrevVersion;
    private RsrcManifest mPrevManifest;

    public RsrcPacker(File inEmptyDirToUse, String inTopLevelResourceName, CheckInMode inCheckInMode, RedundancyCheckMode inRedundancyMode, RsrcManifest inPreviousManifest, VersionNumber inPreviousVersion) throws ResourceException {
        if (inTopLevelResourceName != null && ResourceStringUtils.getSeparatorIdx(inTopLevelResourceName, 0) != -1) {
            throw new IllegalArgumentException();
        }
        this.mMaxSegSize = ResourceSubsysImpl.getMaxSegSize();
        this.mMaxEntriesPerSeg = ResourceSubsysImpl.getMaxSegEntries();
        this.mMetaMetaData.mResourceTopLevelName = inTopLevelResourceName;
        this.mWorkspaceDir = inEmptyDirToUse != null ? inEmptyDirToUse : ResourceFileUtils.createTempFolder("RsrcDir_");
        this.mTmpRsrcDirStrWTrailingSeparator = this.mWorkspaceDir.getAbsolutePath();
        if (!ResourceStringUtils.endsInSeparator(this.mTmpRsrcDirStrWTrailingSeparator)) {
            this.mTmpRsrcDirStrWTrailingSeparator = this.mTmpRsrcDirStrWTrailingSeparator + File.separator;
        }
        this.mCheckInMode = inCheckInMode;
        this.mRedundancyMode = inRedundancyMode;
        this.mPrevManifest = inPreviousManifest;
        this.mPrevVersion = inPreviousVersion;
        RsrcManifest theAddFromManifest = inPreviousManifest;
        if (!CheckInMode.ADD_TO.equals(this.mCheckInMode)) {
            theAddFromManifest = null;
        }
        this.mEntrySegmenter = new Segmenter(theAddFromManifest, this.mMaxSegSize);
        this.mDataSegmenter = new Segmenter(theAddFromManifest, this.mMaxSegSize);
    }

    public RsrcPacker(File inEmptyDirToUse, String inTopLevelResourceName) throws ResourceException {
        this(inEmptyDirToUse, inTopLevelResourceName, null, null, null, null);
    }

    public File getWorkspaceDir() {
        return this.mWorkspaceDir;
    }

    public void deleteDir() throws ResourceException {
        this.deleteDir(false);
    }

    public void deleteDirSnuff() {
        block2: {
            try {
                this.deleteDir(true);
            }
            catch (Throwable t) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error from delete dir", t, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDir(boolean inSnuffErrors) throws ResourceException {
        block7: {
            File file = this.mWorkspaceDir;
            synchronized (file) {
                if (this.mDeletedDir) {
                    return;
                }
                this.mDeletedDir = true;
            }
            try {
                ResourceFileUtils.deleteDirectory(this.mWorkspaceDir);
            }
            catch (ResourceException e) {
                if (!inSnuffErrors) {
                    throw e;
                }
                if (!Logger.isErrorEnabled(this)) break block7;
                Logger.error("Unable to delete directory: " + this.mWorkspaceDir, this);
            }
        }
    }

    public void syncDataToAddMode(String inRelPath) throws ResourceException {
        this.syncAddToMode(inRelPath, this.mDataSegmenter);
    }

    public void syncEntriesToAddMode(String inRelPath) throws ResourceException {
        this.syncAddToMode(inRelPath, this.mEntrySegmenter);
    }

    private void syncAddToMode(String inRelPath, Segmenter ioSegmenter) throws ResourceException {
        if (inRelPath != null) {
            inRelPath = inRelPath.replace('\\', '/');
        }
        if (!ioSegmenter.getNeedAddTo()) {
            return;
        }
        String inRelPathWithoutSep = RsrcPacker.getStrWithoutSep(inRelPath);
        while (true) {
            String theNextRelPath;
            if ((theNextRelPath = ioSegmenter.peekNextRelPath()) == null) {
                return;
            }
            if (inRelPath != null) {
                String theNextRelPathWithoutSep = RsrcPacker.getStrWithoutSep(theNextRelPath);
                int theCompare = RsrcManifest.compare(theNextRelPathWithoutSep, inRelPathWithoutSep);
                if (theCompare > 0) {
                    return;
                }
                if (theCompare == 0) {
                    boolean isFileReplacingPreviousDir = !inRelPath.endsWith("/") && theNextRelPath.endsWith("/");
                    ioSegmenter.stepIter();
                    if (isFileReplacingPreviousDir) {
                        String theDirReplacedByFile = theNextRelPath;
                        while ((theNextRelPath = ioSegmenter.peekNextRelPath()) != null && theNextRelPath.startsWith(theDirReplacedByFile)) {
                            ioSegmenter.stepIter();
                        }
                    }
                    return;
                }
            }
            ResourceEntry theResourceEntry = ioSegmenter.stepIter();
            SegEntry theSegEntryToAdd = ioSegmenter.getPrevRsrcSegEntry(theResourceEntry.getRelPathWFwdSlashes());
            if (ioSegmenter == this.mEntrySegmenter) {
                SegEntry theMatchingPrevRsrcSegEntry = null;
                if (theSegEntryToAdd.getType().equals(SubnodeType.FILE) && RedundancyCheckMode.DELTA_ONLY.equals(this.mRedundancyMode)) {
                    theMatchingPrevRsrcSegEntry = theSegEntryToAdd;
                }
                this.packEntryCluster(theSegEntryToAdd.getRelPathWFwdSlashes(), theSegEntryToAdd.getUncompressedFileSize(), theSegEntryToAdd.getSizePerCompressionSetting(), theSegEntryToAdd.getTime(), theSegEntryToAdd.getType(), theSegEntryToAdd.getPerms(), theSegEntryToAdd.getLinkTarget(), theSegEntryToAdd.getFileMd5PerCompressionSetting(), theSegEntryToAdd.getCompression(), theMatchingPrevRsrcSegEntry);
                continue;
            }
            if (ioSegmenter != this.mDataSegmenter) break;
            if (!theSegEntryToAdd.getType().equals(SubnodeType.FILE) || RedundancyCheckMode.DELTA_ONLY.equals(this.mRedundancyMode)) continue;
            this.packThenCloseDataStream(this.mPrevManifest.getRawClusterStream(Key.sKey, theResourceEntry.getRelPathWFwdSlashes()), theSegEntryToAdd.getSizePerCompressionSetting());
        }
        throw new IllegalStateException();
    }

    public void packEntryCluster(String inRelPath, long inUncompressedSize, long inSizePerCompressionSetting, long inTime, SubnodeType inSubnodeType, NodePerms inPerms, String inLinkTarget, byte[] inFileMd5PerCompressionSetting, boolean inCompressed, VersionNumber inBackRef) throws ResourceException {
        if (this.mMostRecentEntryRelPath != null && RsrcManifest.compare(this.mMostRecentEntryRelPath, inRelPath) > 0) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected data order: <" + this.mMostRecentEntryRelPath + "> <" + inRelPath + ">", this);
            }
            MiscUtils.throwUPE(1340498L);
        }
        this.mMostRecentEntryRelPath = inRelPath;
        if (!inSubnodeType.equals(SubnodeType.FILE) || inBackRef != null) {
            this.packSegEntryIntoMeta(new SegEntry(inRelPath, inUncompressedSize, inSizePerCompressionSetting, inTime, inSubnodeType, inPerms, inLinkTarget, inFileMd5PerCompressionSetting, inBackRef, -1, -1L, -1L, 0, 1, inCompressed));
        } else {
            Vector theSegInfoVec = this.mEntrySegmenter.layoutClusterEntries(inSizePerCompressionSetting);
            int theClusterIdx = 0;
            Iterator theIter = theSegInfoVec.iterator();
            while (theIter.hasNext()) {
                SegInfo theSegInfo = (SegInfo)theIter.next();
                this.packSegEntryIntoMeta(new SegEntry(inRelPath, inUncompressedSize, inSizePerCompressionSetting, inTime, inSubnodeType, inPerms, inLinkTarget, inFileMd5PerCompressionSetting, null, theSegInfo.mDataSegNum, theSegInfo.mFirstSegByteIdx, theSegInfo.mLastSegByteIdx, theClusterIdx, theSegInfoVec.size(), inCompressed));
                ++theClusterIdx;
            }
        }
    }

    public void packEntryCluster(String inRelPath, long inUncompressedSize, long inSizePerCompressionSetting, long inTime, SubnodeType inSubnodeType, NodePerms inPerms, String inLinkTarget, byte[] inFileMd5PerCompressionSetting, boolean inCompressed, SegEntry inMatchingPrevRsrcSegEntry) throws ResourceException {
        VersionNumber theBackRef = null;
        if (inMatchingPrevRsrcSegEntry != null && (theBackRef = inMatchingPrevRsrcSegEntry.getBackRef()) == null) {
            theBackRef = this.mPrevVersion;
        }
        this.packEntryCluster(inRelPath, inUncompressedSize, inSizePerCompressionSetting, inTime, inSubnodeType, inPerms, inLinkTarget, inFileMd5PerCompressionSetting, inCompressed, theBackRef);
    }

    public void packThenCloseDataStream(final InputStream inStream, final long inNumBytes) throws ResourceException {
        if (inStream == null) {
            return;
        }
        new StreamClosure(){

            public Object innerExec() throws ResourceException {
                this.add(inStream);
                Vector theSegInfoVec = RsrcPacker.this.mDataSegmenter.layoutClusterEntries(inNumBytes);
                long theRemainingStreamBytes = inNumBytes;
                Iterator theIter = theSegInfoVec.iterator();
                while (theIter.hasNext()) {
                    SegInfo theSegInfo = (SegInfo)theIter.next();
                    long theNumBytesToWrite = theSegInfo.mLastSegByteIdx - theSegInfo.mFirstSegByteIdx;
                    if (theRemainingStreamBytes < theNumBytesToWrite) {
                        throw new IllegalStateException();
                    }
                    RsrcManifest.addBytesToDataSeg(inStream, theSegInfo.mDataSegNum, RsrcPacker.this.mTmpRsrcDirStrWTrailingSeparator, theSegInfo.mFirstSegByteIdx, theNumBytesToWrite);
                    theRemainingStreamBytes -= theNumBytesToWrite;
                }
                if (theRemainingStreamBytes != 0L) {
                    MiscUtils.throwUPE(1340499L);
                }
                ((RsrcPacker)RsrcPacker.this).mMetaMetaData.mDataSizeSansAnyMeta += inNumBytes;
                return null;
            }
        }.exec();
    }

    private void packSegEntryIntoMeta(SegEntry inSegEntry) throws ResourceException {
        ++this.mMetaMetaData.mNumSubFiles;
        if (inSegEntry.getUncompressedFileSize() > this.mMetaMetaData.mLargestUncompressedSubfileSize) {
            this.mMetaMetaData.mLargestUncompressedSubfileSize = inSegEntry.getUncompressedFileSize();
        }
        this.mCurSegEntryVec.add(inSegEntry);
        if (this.mCurSegEntryVec.size() >= this.mMaxEntriesPerSeg) {
            this.serializeCurSegMetaData();
        }
    }

    private void serializeCurSegMetaData() throws ResourceException {
        if (this.mCurSegEntryVec.size() == 0) {
            MiscUtils.throwUPE(1340497L);
        }
        SegmentMetaData theSegMetaData = new SegmentMetaData();
        theSegMetaData.mEntries = this.mCurSegEntryVec.toArray(new SegEntry[0]);
        boolean hasBackRefs = false;
        for (int i = 0; i < theSegMetaData.mEntries.length; ++i) {
            if (theSegMetaData.mEntries[i].getBackRef() == null) continue;
            hasBackRefs = true;
            break;
        }
        String theFirstEntryString = theSegMetaData.mEntries[0].getRelPathWFwdSlashes();
        this.mAllOneSegMetaMetaDatas.add(new OneSegMetaMetaData(theFirstEntryString, hasBackRefs));
        this.mMetaMetaData.mMetaSizeSansMetaMeta += RsrcManifest.writeSegMetaData(theSegMetaData, this.mNextSegIdx++, this.mTmpRsrcDirStrWTrailingSeparator);
        this.mCurSegEntryVec.clear();
    }

    static String getStrWithoutSep(String inRelPathWFwdSlashes) {
        String s = inRelPathWFwdSlashes;
        if (s == null) {
            return null;
        }
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public long finish() throws ResourceException {
        this.syncEntriesToAddMode(null);
        this.syncDataToAddMode(null);
        if (!this.mEntrySegmenter.getChecksum().equals(this.mDataSegmenter.getChecksum())) {
            MiscUtils.throwUPE(1340500L);
        }
        if (this.mCurSegEntryVec.size() != 0) {
            this.serializeCurSegMetaData();
        }
        this.mMetaMetaData.mPerSegMetaMetaDatas = this.mAllOneSegMetaMetaDatas.toArray(new OneSegMetaMetaData[0]);
        this.mMetaMetaData.mPackingTime = System.currentTimeMillis();
        long theMetaMetaDataSize = RsrcManifest.writeMetaMetaData(this.mMetaMetaData, this.mTmpRsrcDirStrWTrailingSeparator);
        return this.mMetaMetaData.mDataSizeSansAnyMeta + this.mMetaMetaData.mMetaSizeSansMetaMeta + theMetaMetaDataSize;
    }

    public void setOSInfo(boolean inIsPosix, String inSourceOSName) {
        this.mMetaMetaData.mSourceOSIsPosix = inIsPosix;
        this.mMetaMetaData.mSourceOSName = inSourceOSName;
    }

    static class Segmenter {
        private long mMaxSegSize;
        private int mCurDataSegNum = 0;
        private long mNextSegByteIdx = 0L;
        private ResourceEntryIterator mPrevRsrcEntryIter;
        private RsrcManifest mManifest = null;
        private Checksummer mChecksummer = new Checksummer();

        Segmenter(RsrcManifest inManifest, long inMaxSegSize) throws ResourceException {
            if (inManifest != null) {
                this.mManifest = inManifest;
                this.mPrevRsrcEntryIter = inManifest.getEntryIterator();
            }
            this.mMaxSegSize = inMaxSegSize;
        }

        boolean getNeedAddTo() {
            return this.mPrevRsrcEntryIter != null;
        }

        String peekNextRelPath() throws ResourceException {
            return this.mPrevRsrcEntryIter.peekNextSubfileRelPath();
        }

        ResourceEntry stepIter() throws ResourceException {
            return this.mPrevRsrcEntryIter.next();
        }

        public Vector layoutClusterEntries(long inStreamSize) throws ResourceException {
            long theFirstSegByteIdx;
            long theLastSegByteIdx;
            this.mChecksummer.update(inStreamSize);
            Vector<SegInfo> theSegInfoVec = new Vector<SegInfo>();
            for (long theBytesToAlloc = inStreamSize; theBytesToAlloc > 0L; theBytesToAlloc -= theLastSegByteIdx - theFirstSegByteIdx) {
                if (this.mNextSegByteIdx >= this.mMaxSegSize) {
                    this.mNextSegByteIdx = 0L;
                }
                int theDataSegNum = ++this.mCurDataSegNum;
                theFirstSegByteIdx = this.mNextSegByteIdx;
                this.mNextSegByteIdx += theBytesToAlloc;
                if (this.mNextSegByteIdx > this.mMaxSegSize) {
                    this.mNextSegByteIdx = this.mMaxSegSize;
                }
                theLastSegByteIdx = this.mNextSegByteIdx;
                theSegInfoVec.add(new SegInfo(theDataSegNum, theFirstSegByteIdx, theLastSegByteIdx));
            }
            return theSegInfoVec;
        }

        public SegEntry getPrevRsrcSegEntry(String inRelPathWFwdSlashes) throws ResourceException {
            return this.mManifest.getFirstClusterSegEntry(Key.sKey, inRelPathWFwdSlashes);
        }

        public Checksummer getChecksum() {
            return this.mChecksummer;
        }
    }

    static class SegInfo {
        public int mDataSegNum;
        public long mFirstSegByteIdx;
        public long mLastSegByteIdx;

        SegInfo(int inDataSegNum, long inFirstSegByteIdx, long inLastSegByteIdx) {
            this.mDataSegNum = inDataSegNum;
            this.mFirstSegByteIdx = inFirstSegByteIdx;
            this.mLastSegByteIdx = inLastSegByteIdx;
        }
    }
}

