/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.checkInJob.RelPathInfo;
import com.raplix.rolloutexpress.resource.compression.DecompressionInputStream;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.multipipe.StreamInSegment;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.MetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.OneSegMetaMetaData;
import com.raplix.rolloutexpress.resource.packageformat.RawClusterStream;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.packageformat.SegmentMetaData;
import com.raplix.rolloutexpress.resource.packageformat.StringSearcher;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.StreamClosure;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class RsrcManifest
implements Messages {
    private ResourceAccessor mAccessor;
    private HashMap mBackrefManifests = new HashMap();
    private MetaMetaData mMetaMetaData;
    private MetaDataCache mMetaDataCache;
    private ResourceID mResourceID;
    private String mRsrcDirWTrailingSeparator;
    private boolean mIsVirtual;
    private boolean mIsOnServer;
    private boolean mIsValid = true;
    private static final String SUVA_RESOURCES_DIR_NAME = "SuvaResources";
    private static final String DATA_DIR_NAME = "Data";
    private static final String METADATA_DIR_NAME = "MetaData";
    private static final String METAMETADATA_FILE_NAME = "MetaMetaData";
    private static final String LEADING_ZEROS = "000000000";
    private static final String SYS_TAG = "isSys";

    RsrcManifest(ResourceAccessor inAccessor, Resource inResource) throws ResourceException {
        this(inAccessor, inResource.getResourceID());
    }

    RsrcManifest(ResourceAccessor inAccessor, ResourceID inResourceID) throws ResourceException {
        this.mIsVirtual = false;
        ResourceSubsysImpl theResourceSubsysImpl = inAccessor.getResourceSubsysImpl();
        this.mIsOnServer = theResourceSubsysImpl.isServer();
        this.mAccessor = inAccessor;
        this.mResourceID = inResourceID;
        this.mRsrcDirWTrailingSeparator = RsrcManifest.getResourceIDDirWTrailingSeparator(Key.sKey, theResourceSubsysImpl.getAbsRepoRootString(), inResourceID);
        this.mMetaMetaData = RsrcManifest.readMetaMetaData(this.mRsrcDirWTrailingSeparator);
        this.mMetaDataCache = new MetaDataCache(this.mMetaMetaData.mPerSegMetaMetaDatas, this.mRsrcDirWTrailingSeparator);
    }

    public RsrcManifest(Object inKey, ResourceAccessor inAccessor, ResourceID inResourceID) throws ResourceException {
        this(inAccessor, inResourceID);
        TransPackageKeys.verifyResourceKey(inKey);
    }

    public static RsrcManifest makeVirtualManifest(Object inKey, ResourceID inResourceID, String inRsrcDirWTrailingSeparator) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        return new RsrcManifest(inResourceID, inRsrcDirWTrailingSeparator);
    }

    private RsrcManifest(ResourceID inResourceID, String inRsrcDirWTrailingSeparator) throws ResourceException {
        this.mIsVirtual = true;
        this.mIsOnServer = false;
        this.mAccessor = null;
        this.mResourceID = inResourceID;
        this.mRsrcDirWTrailingSeparator = inRsrcDirWTrailingSeparator;
        this.mMetaMetaData = RsrcManifest.readMetaMetaData(this.mRsrcDirWTrailingSeparator);
        this.mMetaDataCache = new MetaDataCache(this.mMetaMetaData.mPerSegMetaMetaDatas, this.mRsrcDirWTrailingSeparator);
    }

    public void setInvalid() {
        this.mIsValid = false;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    void verifyValid() throws ResourceException {
        if (!this.isValid()) {
            throw new ResourceException("rsrc.msg0313");
        }
    }

    public ResourceID getResourceID() throws ResourceException {
        this.verifyValid();
        return this.mResourceID;
    }

    public ResourceEntryIterator getEntryIterator() throws ResourceException {
        this.verifyValid();
        return new ResourceEntryIterator(SegIter.makeIter(Key.sKey, this));
    }

    public static int compare(String inStr1, String inStr2) {
        String theStr1 = inStr1.replace('\\', '/');
        String theStr2 = inStr2.replace('\\', '/');
        int theIdx1 = 0;
        int theIdx2 = 0;
        while (true) {
            theIdx1 = theStr1.indexOf(47);
            theIdx2 = theStr2.indexOf(47);
            if (theIdx2 < 0 && theIdx1 < 0) {
                return RsrcManifest.dictCompare(theStr1, theStr2);
            }
            if (theIdx2 < 0 || theIdx1 < 0) break;
            int cmp = RsrcManifest.dictCompare(theStr1.substring(0, theIdx1), theStr2.substring(0, theIdx2));
            if (cmp != 0) {
                return cmp;
            }
            theStr1 = theStr1.substring(theIdx1 + 1);
            theStr2 = theStr2.substring(theIdx2 + 1);
        }
        if (theIdx2 >= 0) {
            theStr2 = theStr2.substring(0, theIdx2 + 1);
            return RsrcManifest.dictCompare(theStr1, theStr2);
        }
        theStr1 = theStr1.substring(0, theIdx1 + 1);
        return RsrcManifest.dictCompare(theStr1, theStr2);
    }

    public static int dictCompare(String inStr1, String inStr2) {
        int theResult = inStr1.compareToIgnoreCase(inStr2);
        if (theResult == 0) {
            theResult = inStr1.compareTo(inStr2);
        }
        return theResult;
    }

    public long getNumEntries() throws ResourceException {
        this.verifyValid();
        return this.mMetaMetaData.mNumSubFiles;
    }

    public InputStream getInputStream(ResourceEntry inResourceEntry) throws ResourceException {
        if (!inResourceEntry.getType().equals(SubnodeType.FILE)) {
            throw new ResourceException("rsrc.msg0316");
        }
        return this.getInputStream(inResourceEntry.getRelPathWFwdSlashes());
    }

    public InputStream getInputStream(String inRelPath) throws ResourceException {
        RawClusterStream theRawClusterStream = this.getRawClusterStream(Key.sKey, inRelPath);
        if (theRawClusterStream == null) {
            return null;
        }
        if (theRawClusterStream.getCompression()) {
            return new DecompressionInputStream(theRawClusterStream);
        }
        return theRawClusterStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RawClusterStream getRawClusterStream(Object inKey, String inRelPath) throws ResourceException {
        RawClusterStream theStream;
        if (this.mIsVirtual) {
            MiscUtils.throwUPE(0x147441L);
        }
        this.verifyValid();
        RsrcManifest theRsrcManifest = this;
        SegEntry theSegEntry = this.getFirstClusterSegEntry(Key.sKey, inRelPath);
        if (theSegEntry == null) {
            throw new ResourceException("rsrc.NO_SUCH_ENTRY", new Object[]{inRelPath});
        }
        VersionNumber theBackRef = theSegEntry.getBackRef();
        if (theBackRef != null && (theRsrcManifest = this.getBackManifest(theBackRef)) == null) {
            if (!this.mIsOnServer) return null;
            throw new ResourceException("rsrc.msg0317", new Object[]{inRelPath});
        }
        try {
            theStream = new RawClusterStream(theRsrcManifest, inRelPath){

                public void close() throws IOException {
                    RsrcManifest.this.mAccessor.streamClosed(this);
                    super.close();
                }
            };
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        boolean success = false;
        try {
            this.mAccessor.streamOpened(theStream);
            return theStream;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (success) throw throwable;
            try {
                theStream.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!Logger.isErrorEnabled(this)) throw throwable;
                Logger.error("Unable to clean up accessor stream", this);
            }
            throw throwable;
        }
    }

    RsrcManifest getBackManifest(VersionNumber inVersionNumber) throws ResourceException {
        RsrcManifest theBackManifest;
        if (this.mIsVirtual) {
            MiscUtils.throwUPE(1340482L);
        }
        if ((theBackManifest = (RsrcManifest)this.mBackrefManifests.get(inVersionNumber)) == null) {
            if (this.mAccessor == null) {
                throw new ResourceException("rsrc.msg0423");
            }
            theBackManifest = this.mAccessor.getBackRsrcManifest(this, inVersionNumber);
            if (theBackManifest == null) {
                return null;
            }
            this.mBackrefManifests.put(inVersionNumber, theBackManifest);
        }
        return theBackManifest;
    }

    InputStream getRawSegStream(SegEntry inSegEntry) throws ResourceException {
        this.verifyValid();
        File theDataFile = RsrcManifest.getDataSegLoc(inSegEntry.getDataSegNum(), this.mRsrcDirWTrailingSeparator);
        try {
            FileInputStream theInStream = new FileInputStream(theDataFile);
            for (long theBytesToSkip = inSegEntry.getFirstSegByteIdx(); theBytesToSkip > 0L; theBytesToSkip -= theInStream.skip(theBytesToSkip)) {
            }
            long theNumBytesToRead = inSegEntry.getLastSegByteIdx() - inSegEntry.getFirstSegByteIdx();
            return new StreamInSegment(theInStream, theNumBytesToRead, 0);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public MetaMetaData getMetaMetaData(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        return this.mMetaMetaData;
    }

    SegmentMetaData getSegmentMetaData(int inSegmentIdx) throws ResourceException {
        return this.mMetaDataCache.getSegment(inSegmentIdx);
    }

    public SegEntry findBackrefableData(Object inKey, SegEntry inSegEntry) throws ResourceException {
        return this.findBackrefableClusterStart(inKey, inSegEntry.getRelPathWFwdSlashes(), inSegEntry.getCompression(), inSegEntry.getUncompressedFileSize(), inSegEntry.getFileMd5PerCompressionSetting());
    }

    public SegEntry findBackrefableData(Object inKey, RelPathInfo inInfo) throws ResourceException {
        return this.findBackrefableClusterStart(inKey, inInfo.mRelPath, inInfo.mCompressed, inInfo.mUncompressedSize, inInfo.mFileMd5PerCompressionSetting);
    }

    private SegEntry findBackrefableClusterStart(Object inKey, String inRelPath, boolean inIsCompressed, long inUncompressedFileSize, byte[] inFileMd5) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        SegIter theIter = SegIter.makeIter(Key.sKey, this);
        theIter.setRelPathAsNext(inRelPath);
        SegEntry theEntry = theIter.getNextSegEntry();
        if (theEntry != null && theEntry.getCompression() == inIsCompressed && theEntry.getUncompressedFileSize() == inUncompressedFileSize && Arrays.equals(theEntry.getFileMd5PerCompressionSetting(), inFileMd5)) {
            return theEntry;
        }
        return null;
    }

    public static ResourceEntry makeResourceEntry(SegEntry inSegEntry) {
        NodePerms thePerms = inSegEntry.getPerms();
        if (thePerms != null) {
            thePerms = thePerms.duplicate();
        }
        return new ResourceEntry(inSegEntry.getRelPathWFwdSlashes(), inSegEntry.getUncompressedFileSize(), inSegEntry.getTime(), inSegEntry.getType(), null, thePerms, null, inSegEntry.getLinkTarget());
    }

    public ResourceEntry getEntry(String inRelPath) throws ResourceException {
        SegEntry theSegEntry = this.getFirstClusterSegEntry(Key.sKey, inRelPath);
        if (theSegEntry == null) {
            return null;
        }
        return RsrcManifest.makeResourceEntry(theSegEntry);
    }

    public int[] getFirstClusterSegDesc(Object inKey, String inRelPath) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        return this.mMetaDataCache.getFirstClusterSegDesc(inRelPath);
    }

    public SegEntry getFirstClusterSegEntry(Object inKey, String inRelPath) throws ResourceException {
        int[] theFirstClusterSegDesc = this.getFirstClusterSegDesc(inKey, inRelPath);
        if (theFirstClusterSegDesc == null) {
            return null;
        }
        SegmentMetaData theSegMetaData = this.getSegmentMetaData(theFirstClusterSegDesc[0]);
        SegEntry theSegEntry = theSegMetaData.mEntries[theFirstClusterSegDesc[1]];
        if (!theSegEntry.getRelPathWFwdSlashes().equals(inRelPath)) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("wrong relpath returned: wanted " + inRelPath + " but got " + theSegEntry.getRelPathWFwdSlashes(), this);
            }
            MiscUtils.throwUPE(1340491L);
        }
        return theSegEntry;
    }

    public String getCheckinOSName() {
        return this.mMetaMetaData.mSourceOSName;
    }

    public String getTopLevelRsrcName() {
        return this.mMetaMetaData.mResourceTopLevelName;
    }

    public static final String getOSName() {
        if (PlatformUtil.isCygwin()) {
            return "Cygwin";
        }
        return System.getProperty("os.name");
    }

    int getNumSegments() {
        return this.mMetaMetaData.mPerSegMetaMetaDatas.length;
    }

    public boolean hasAnyBackRefs() {
        int theNumSegs = this.mMetaMetaData.mPerSegMetaMetaDatas.length;
        for (int i = 0; i < theNumSegs; ++i) {
            if (!this.mMetaMetaData.mPerSegMetaMetaDatas[i].mHasBackRefs) continue;
            return true;
        }
        return false;
    }

    public static StringBuffer getSuvaResourcesDirWTrailingSeparator(String inAbsRepoRootStringWTrailingSeparator) {
        StringBuffer theSB = new StringBuffer();
        theSB.append(inAbsRepoRootStringWTrailingSeparator);
        theSB.append(SUVA_RESOURCES_DIR_NAME);
        theSB.append(File.separator);
        return theSB;
    }

    public static String getResourceIDDirWTrailingSeparator(Object inKey, String inAbsRepoRootStringWTrailingSeparator, ResourceID inResourceID) {
        TransPackageKeys.verifyResourceKey(inKey);
        StringBuffer theSB = RsrcManifest.getSuvaResourcesDirWTrailingSeparator(inAbsRepoRootStringWTrailingSeparator);
        String theIDString = inResourceID.toString();
        int theIDLength = theIDString.length();
        theSB.append(theIDString.substring(theIDLength - 6, theIDLength - 4));
        theSB.append(File.separator);
        theSB.append(theIDString.substring(theIDLength - 4, theIDLength - 2));
        theSB.append(File.separator);
        theSB.append(theIDString.substring(theIDLength - 2));
        theSB.append(File.separator);
        theSB.append(inResourceID);
        theSB.append(File.separator);
        return theSB.toString();
    }

    public static String getSuvaRsrcDirName(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        return SUVA_RESOURCES_DIR_NAME;
    }

    public static File getMetaMetaDataLoc(Object inKey, String inRsrcDirStrWTrailingSeparator) {
        TransPackageKeys.verifyResourceKey(inKey);
        return new File(inRsrcDirStrWTrailingSeparator + METAMETADATA_FILE_NAME);
    }

    public static String getSegMetaDataDirString(Object inKey, String inRsrcDirStrWTrailingSeparator) {
        TransPackageKeys.verifyResourceKey(inKey);
        return inRsrcDirStrWTrailingSeparator + METADATA_DIR_NAME;
    }

    private static File getSegMetaDataLoc(int inSegIdx, String inRsrcDirWTrailingSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append(RsrcManifest.getSegMetaDataDirString(Key.sKey, inRsrcDirWTrailingSeparator));
        sb.append(File.separator);
        String theSegName = "" + inSegIdx;
        sb.append(LEADING_ZEROS.substring(theSegName.length()));
        sb.append(theSegName);
        return new File(sb.toString());
    }

    public static String getSegDataDirString(Object inKey, String inRsrcDirStrWTrailingSeparator) {
        TransPackageKeys.verifyResourceKey(inKey);
        return inRsrcDirStrWTrailingSeparator + DATA_DIR_NAME;
    }

    private static File getDataSegLoc(int inDataSegIdx, String inRsrcDirStrWTrailingSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append(RsrcManifest.getSegDataDirString(Key.sKey, inRsrcDirStrWTrailingSeparator));
        sb.append(File.separator);
        String theSegName = "" + inDataSegIdx;
        sb.append(LEADING_ZEROS.substring(theSegName.length()));
        sb.append(theSegName);
        return new File(sb.toString());
    }

    private static MetaMetaData readMetaMetaData(String inRsrcDirWTrailingSeparator) throws ResourceException {
        final File theMetaMetaDataFile = RsrcManifest.getMetaMetaDataLoc(Key.sKey, inRsrcDirWTrailingSeparator);
        MetaMetaData theMetaMetaData = (MetaMetaData)new StreamClosure(){

            public Object innerExec() throws ClassNotFoundException, IOException {
                return new ObjectInputStream(this.addInput(theMetaMetaDataFile)).readObject();
            }
        }.exec();
        theMetaMetaData.mMetaMetaSize = theMetaMetaDataFile.length();
        return theMetaMetaData;
    }

    private static SegmentMetaData readSegMetaData(int inSegIdx, String inRsrcDirWTrailingSeparator) throws ResourceException {
        final File theSegMetaDataFile = RsrcManifest.getSegMetaDataLoc(inSegIdx, inRsrcDirWTrailingSeparator);
        return (SegmentMetaData)new StreamClosure(){

            public Object innerExec() throws ClassNotFoundException, IOException {
                return new ObjectInputStream(this.addInput(theSegMetaDataFile)).readObject();
            }
        }.exec();
    }

    public static long writeMetaMetaData(final MetaMetaData inMetaMetaData, String inRscDirWTrailingSeparator) throws ResourceException {
        final File theMetaMetaDataFile = RsrcManifest.getMetaMetaDataLoc(Key.sKey, inRscDirWTrailingSeparator);
        theMetaMetaDataFile.getParentFile().mkdirs();
        new StreamClosure(){

            public Object innerExec() throws IOException {
                ObjectOutputStream theObjOutStream = new ObjectOutputStream(this.addOutput(theMetaMetaDataFile));
                theObjOutStream.writeObject(inMetaMetaData);
                return null;
            }
        }.exec();
        return theMetaMetaDataFile.length();
    }

    public static long writeSegMetaData(final SegmentMetaData inSegmentMetaData, int inSegIdx, String inRsrcDirWTrailingSeparator) throws ResourceException {
        final File theSegMetaDataFile = RsrcManifest.getSegMetaDataLoc(inSegIdx, inRsrcDirWTrailingSeparator);
        theSegMetaDataFile.getParentFile().mkdirs();
        new StreamClosure(){

            public Object innerExec() throws IOException {
                ObjectOutputStream theObjOutStream = new ObjectOutputStream(this.addOutput(theSegMetaDataFile));
                theObjOutStream.writeObject(inSegmentMetaData);
                return null;
            }
        }.exec();
        return theSegMetaDataFile.length();
    }

    public static void addBytesToDataSeg(final InputStream inStream, int inDataSegNum, String inRsrcDirWTrailingSeparator, long inExpectedSizeBeforeWrite, final long inNumBytesToWrite) throws ResourceException {
        final File theDataSegFile = RsrcManifest.getDataSegLoc(inDataSegNum, inRsrcDirWTrailingSeparator);
        theDataSegFile.getParentFile().mkdirs();
        if (inExpectedSizeBeforeWrite == 0L) {
            boolean didCreate;
            if (theDataSegFile.exists()) {
                MiscUtils.throwUPE(1340495L);
            }
            try {
                didCreate = theDataSegFile.createNewFile();
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            if (!didCreate) {
                throw new ResourceException("rsrc.CANT_MAKE_DATA_SEG", new Object[]{theDataSegFile.getAbsolutePath()});
            }
        } else if (theDataSegFile.length() != inExpectedSizeBeforeWrite) {
            MiscUtils.throwUPE(5072119L);
        }
        new StreamClosure(){

            public Object innerExec() throws ResourceException, IOException {
                Util.copyStream(new StreamInSegment(inStream, inNumBytesToWrite), this.addOutputAppended(theDataSegFile));
                return null;
            }
        }.exec();
        if (theDataSegFile.length() != inExpectedSizeBeforeWrite + inNumBytesToWrite) {
            if (Logger.isErrorEnabled(RsrcManifest.class)) {
                Logger.error("Unexpected data " + theDataSegFile.length() + " " + inExpectedSizeBeforeWrite + " " + inNumBytesToWrite, RsrcManifest.class);
            }
            MiscUtils.throwUPE(1340496L);
        }
    }

    public static void tagRsrcFolderAsSys(File theFinalTargetDir, String inResourceToString) {
        block2: {
            File theSysMarker = new File(theFinalTargetDir, SYS_TAG);
            try {
                ResourceFileUtils.writeStreamToFile(theSysMarker, System.currentTimeMillis(), new ByteArrayInputStream(inResourceToString.getBytes()));
            }
            catch (ResourceException e) {
                if (!Logger.isWarnEnabled(RsrcManifest.class.getName())) break block2;
                Logger.warn("Unable to write system marker for test suit: " + theFinalTargetDir, RsrcManifest.class.getName());
            }
        }
    }

    public static File[] forTestOnly_ListSysRsrcDirs(File inDir) {
        Vector theSysRsrcDirs = new Vector();
        RsrcManifest.forTestOnly_CollectSysRsrcDirs(inDir, theSysRsrcDirs);
        return theSysRsrcDirs.toArray(new File[0]);
    }

    private static void forTestOnly_CollectSysRsrcDirs(File inDir, Vector ioDirVec) {
        File theSysMarker = new File(inDir, SYS_TAG);
        if (theSysMarker.isFile()) {
            ioDirVec.add(inDir);
            return;
        }
        File theMetaMetaDataFile = new File(inDir, METAMETADATA_FILE_NAME);
        if (theMetaMetaDataFile.isFile()) {
            return;
        }
        File[] theSubFiles = inDir.listFiles();
        if (theSubFiles == null) {
            return;
        }
        for (int i = 0; i < theSubFiles.length; ++i) {
            File theSubFile = theSubFiles[i];
            if (!theSubFile.isDirectory()) continue;
            RsrcManifest.forTestOnly_CollectSysRsrcDirs(theSubFile, ioDirVec);
        }
    }

    public static String forTestOnly_getResourceToString(Object inKey, File inRsrcDir) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        final File theSysMarkerFile = new File(inRsrcDir, SYS_TAG);
        return (String)new StreamClosure(){

            public Object innerExec() throws Exception {
                byte[] theBytes = new byte[(int)theSysMarkerFile.length()];
                ResourceFileUtils.readStreamToBytes(this.addInput(theSysMarkerFile), theBytes);
                return new String(theBytes);
            }
        }.exec();
    }

    private static class MetaDataCache {
        private LinkedList mCacheMRU = new LinkedList();
        private HashMap mCachedByInts = new HashMap();
        private int mMaxCacheElems = 3;
        private StringSearcher mMultiSegSearcher;
        private OneSegMetaMetaData[] mPerSegMetaMetaDatas;
        private String mRsrcDirWTrailingSeparator;

        MetaDataCache(OneSegMetaMetaData[] inPerSegMetaMetaDatas, String inRsrcDirWTrailingSeparator) {
            this.mPerSegMetaMetaDatas = inPerSegMetaMetaDatas;
            this.mRsrcDirWTrailingSeparator = inRsrcDirWTrailingSeparator;
            this.mMultiSegSearcher = new StringSearcher(this, inPerSegMetaMetaDatas){
                private final /* synthetic */ OneSegMetaMetaData[] val$inPerSegMetaMetaDatas;
                private final /* synthetic */ MetaDataCache this$0;
                {
                    this.this$0 = this$0;
                    this.val$inPerSegMetaMetaDatas = val$inPerSegMetaMetaDatas;
                }

                public int getNumStrings() {
                    return this.val$inPerSegMetaMetaDatas.length;
                }

                public String get(int inIdx) {
                    return this.val$inPerSegMetaMetaDatas[inIdx].mFirstEntryString;
                }

                public int compare(String inStr1, String inStr2) {
                    return RsrcManifest.compare(inStr1, inStr2);
                }
            };
        }

        synchronized int[] getFirstClusterSegDesc(String inRelPath) throws ResourceException {
            int theClosestIdx = this.mMultiSegSearcher.getFirstMaxIdxLTE(inRelPath);
            if (theClosestIdx == -1) {
                return null;
            }
            CacheObject theCacheObj = this.cacheSegment(theClosestIdx);
            if (theCacheObj == null) {
                MiscUtils.throwUPE(1340492L);
            }
            if (!(theCacheObj.mSegMetaData.mEntries.length <= 0 || theCacheObj.mSegMetaData.mEntries[0].getRelPathWFwdSlashes().equals(inRelPath) && theCacheObj.mSegMetaData.mEntries[0].getClusterIdx() != 0)) {
                int theEntryIdx = theCacheObj.mSingleSegSearcher.getFirstExactMatch(inRelPath);
                if (theEntryIdx == -1) {
                    return null;
                }
                return new int[]{theClosestIdx, theEntryIdx};
            }
            if (theClosestIdx > 0) {
                theCacheObj = this.cacheSegment(theClosestIdx - 1);
                if (theCacheObj == null) {
                    MiscUtils.throwUPE(5072118L);
                }
                int theLastEntryIdx = theCacheObj.mSegMetaData.mEntries.length - 1;
                if (theCacheObj.mSegMetaData.mEntries.length > 0 && theCacheObj.mSegMetaData.mEntries[theLastEntryIdx].getRelPathWFwdSlashes().equals(inRelPath)) {
                    int theEntryIdx = theCacheObj.mSingleSegSearcher.getFirstExactMatch(inRelPath);
                    if (theEntryIdx == -1) {
                        MiscUtils.throwUPE(1340493L);
                    }
                    return new int[]{theClosestIdx - 1, theEntryIdx};
                }
            }
            return null;
        }

        SegmentMetaData getSegment(int inSegmentIdx) throws ResourceException {
            CacheObject theCacheObject = this.cacheSegment(inSegmentIdx);
            return theCacheObject != null ? theCacheObject.mSegMetaData : null;
        }

        private synchronized CacheObject cacheSegment(int inSegmentIdx) throws ResourceException {
            CacheObject theAlreadyCachedObj;
            if (inSegmentIdx >= this.mPerSegMetaMetaDatas.length) {
                return null;
            }
            if (inSegmentIdx < 0) {
                MiscUtils.throwUPE(1340494L);
            }
            if ((theAlreadyCachedObj = (CacheObject)this.mCachedByInts.get(new Integer(inSegmentIdx))) != null) {
                this.mCacheMRU.remove(theAlreadyCachedObj);
                this.mCacheMRU.addFirst(theAlreadyCachedObj);
                return theAlreadyCachedObj;
            }
            SegmentMetaData theSegmentMetaData = RsrcManifest.readSegMetaData(inSegmentIdx, this.mRsrcDirWTrailingSeparator);
            while (this.mCacheMRU.size() >= this.mMaxCacheElems) {
                CacheObject theCacheObjToRmv = (CacheObject)this.mCacheMRU.removeLast();
                this.mCachedByInts.remove(new Integer(theCacheObjToRmv.mMetaSegIdx));
            }
            CacheObject theNewCacheObject = new CacheObject(inSegmentIdx, theSegmentMetaData);
            this.mCacheMRU.addFirst(theNewCacheObject);
            this.mCachedByInts.put(new Integer(theNewCacheObject.mMetaSegIdx), theNewCacheObject);
            return theNewCacheObject;
        }

        private static class CacheObject {
            SegmentMetaData mSegMetaData;
            StringSearcher mSingleSegSearcher;
            int mMetaSegIdx;

            CacheObject(int inSegIdx, SegmentMetaData inSegMetaData) {
                this.mMetaSegIdx = inSegIdx;
                this.mSegMetaData = inSegMetaData;
                this.mSingleSegSearcher = new StringSearcher(this, inSegMetaData){
                    private final /* synthetic */ SegmentMetaData val$inSegMetaData;
                    private final /* synthetic */ CacheObject this$0;
                    {
                        this.this$0 = this$0;
                        this.val$inSegMetaData = val$inSegMetaData;
                    }

                    public int getNumStrings() {
                        return this.val$inSegMetaData.mEntries.length;
                    }

                    public String get(int inIdx) {
                        return this.val$inSegMetaData.mEntries[inIdx].getRelPathWFwdSlashes();
                    }

                    public int compare(String inStr1, String inStr2) {
                        return RsrcManifest.compare(inStr1, inStr2);
                    }
                };
            }
        }
    }
}

