/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.VersionMap;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.exception.ResourceProcessException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.File;
import java.io.InputStream;

public abstract class ResourceParser {
    private ResourceID mResourceID;
    private ResourceSubsysImpl mRsrcCtx;
    private File mSrcFileCached;
    private Resource mResource;
    private PushID mPushID;
    private VersionMap mFwdDeletionMap;

    public ResourceParser(ResourceID inResourceID, PushID inPushID, ResourceSubsysImpl inRsrcSysCtx) throws ResourceNotLocalException, ResourcePersistenceException {
        this.mResourceID = inResourceID;
        this.mRsrcCtx = inRsrcSysCtx;
        this.mPushID = inPushID;
        if (inPushID != null) {
            this.mFwdDeletionMap = inRsrcSysCtx.getPush(inPushID).getFwdDeletionMap();
        }
        this.mResource = inRsrcSysCtx.getResource(inResourceID, inPushID);
        this.mSrcFileCached = this.mResource.getInternalRepoFile(inRsrcSysCtx);
    }

    public void parse() throws ResourceException {
        this.beginParse();
        new ResourceAccessor(this.getResourceSubsysImpl(), this.mFwdDeletionMap){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(ResourceParser.this.getResourceID(), ResourceParser.this.getPushID());
                ResourceEntryIterator theIter = theManifest.getEntryIterator();
                int theEntryIdx = 0;
                while (theIter.hasNext()) {
                    Throwable t2;
                    Object var7_6;
                    InputStream theInputStream;
                    block9: {
                        ResourceEntry theEntry = theIter.next();
                        theInputStream = null;
                        if (ResourceParser.this.doesRealContent() && theEntry.getType().equals(SubnodeType.FILE)) {
                            theInputStream = theManifest.getInputStream(theEntry);
                        }
                        try {
                            if (!ResourceParser.this.processEntry(theEntry, theEntryIdx++, theInputStream)) break block9;
                            var7_6 = null;
                            if (theInputStream == null) break;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            if (theInputStream != null) {
                                try {
                                    theInputStream.close();
                                }
                                catch (Throwable t2) {
                                    MiscUtils.resourceThrow(t2);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            theInputStream.close();
                        }
                        catch (Throwable t2) {
                            MiscUtils.resourceThrow(t2);
                        }
                        break;
                    }
                    var7_6 = null;
                    if (theInputStream == null) continue;
                    try {
                        theInputStream.close();
                    }
                    catch (Throwable t2) {
                        MiscUtils.resourceThrow(t2);
                    }
                }
                return null;
            }
        }.access();
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public ResourceSubsysImpl getResourceSubsysImpl() {
        return this.mRsrcCtx;
    }

    public File getSrcFile() {
        return this.mSrcFileCached;
    }

    public Resource getResource() {
        return this.mResource;
    }

    public PushID getPushID() {
        return this.mPushID;
    }

    public VersionMap getFwdDeletionMap() {
        return this.mFwdDeletionMap;
    }

    public static String stripRoot(String inString) {
        int theIdx = ResourceStringUtils.getSeparatorIdx(inString, 0);
        if (theIdx == -1) {
            return "";
        }
        return inString.substring(theIdx, inString.length());
    }

    public boolean processEntry(ResourceEntry inEntry, int inEntryIdx, InputStream inInputStream) throws ResourceProcessException, ResourceException {
        return true;
    }

    public void beginParse() throws ResourceException {
    }

    public abstract boolean doesRealContent();
}

