/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.packageformat.ZipArchive;
import com.raplix.rolloutexpress.resource.packageformat.ZipPacker;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceManifest
implements Serializable,
Messages {
    static final long serialVersionUID = 7331060584773442753L;
    public static final int sREVID = 1;
    public static final String sManifestIdentifier = "Manifest/Manifest_REV1";
    private int mCurrentVersion = 1;
    private String mCheckinOSName;
    private HashMap mPathToResourceEntryHash;
    private transient ZipFile mZipFile;
    private transient HashMap mPathToZipEntryHash;
    private transient ResourceAccessor mAccessor;
    private transient HashMap mBackAccessors = new HashMap();
    private transient ResourceID mResourceID = null;
    private transient RsrcPushImpl mPushImpl = null;

    ResourceManifest() {
        this.mPathToResourceEntryHash = new HashMap();
        this.mPathToZipEntryHash = new HashMap();
    }

    public ResourceManifest(String inOSCheckinName) {
        this();
        this.mCheckinOSName = inOSCheckinName;
    }

    void setContext(ResourceAccessor inAccessor) {
        this.mAccessor = inAccessor;
    }

    public void setInvalid() {
        if (this.mZipFile != null) {
            block3: {
                try {
                    this.mZipFile.close();
                }
                catch (IOException e) {
                    if (!Logger.isErrorEnabled(this)) break block3;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.ZIP_CLOSE_FAILED"), this);
                }
            }
            this.mZipFile = null;
        }
        this.mPathToZipEntryHash = null;
        this.mPathToResourceEntryHash = null;
    }

    public boolean isValid() {
        return this.mPathToResourceEntryHash != null;
    }

    void verifyValid() throws ResourceException {
        if (!this.isValid()) {
            throw new ResourceException("rsrc.msg0313");
        }
    }

    public ResourceID getResourceID() throws ResourceException {
        this.verifyValid();
        if (this.mResourceID == null) {
            throw new ResourceException("rsrc.msg0314");
        }
        return this.mResourceID;
    }

    void setResourceID(ResourceID inResourceID) {
        this.mResourceID = inResourceID;
    }

    void setPushID(PushID inPushID, ResourceSubsysImpl inRsrcCtx) {
        this.mPushImpl = null;
        if (inPushID != null) {
            this.mPushImpl = inRsrcCtx.getPush(inPushID);
        }
    }

    public String getCheckinOSName() {
        return this.mCheckinOSName;
    }

    private boolean wasCheckinOSPosix() {
        return this.mCheckinOSName == null || this.mCheckinOSName.toLowerCase().indexOf("window") == -1;
    }

    public ResourceEntryIterator getEntryIterator() throws ResourceException {
        this.verifyValid();
        return new ResourceEntryIterator(this.mPathToResourceEntryHash);
    }

    public void setAllEntryPerms(NodePerms inNodePerms, ResourceSubsystem inResourceSubsystem) throws ResourceException {
        this.verifyValid();
        this.verifyPermsType(inNodePerms);
        ResourceEntryIterator theIter = this.getEntryIterator();
        while (theIter.hasNext()) {
            ResourceEntry theResourceEntry = theIter.next();
            this.integratePermsToEntry(theResourceEntry, inNodePerms, inResourceSubsystem);
        }
    }

    public void setSingleEntryPerms(ResourceEntry inResourceEntry, NodePerms inNodePerms, ResourceSubsystem inResourceSubsystem) throws ResourceException {
        ResourceEntry theResourceEntry = this.getEntry(inResourceEntry.getRelPathWFwdSlashes());
        if (inResourceEntry != theResourceEntry) {
            throw new ResourceException("rsrc.msg0349");
        }
        this.verifyPermsType(inNodePerms);
        this.integratePermsToEntry(theResourceEntry, inNodePerms, inResourceSubsystem);
    }

    private void integratePermsToEntry(ResourceEntry inResourceEntry, NodePerms inNodePerms, ResourceSubsystem inResourceSubsystem) throws ResourceException {
        NodePerms theNodePerms = inResourceEntry.getPerms();
        if (theNodePerms == null) {
            theNodePerms = inResourceSubsystem.createDefaultNodePerms();
        }
        if (theNodePerms == null) {
            theNodePerms = PlatformPermissionFactory.getInstance().createDefaultNodePerms();
        }
        theNodePerms.integrateValidFields(inNodePerms);
        inResourceEntry.setPerms(theNodePerms);
    }

    private void verifyPermsType(NodePerms inNodePerms) throws ResourceException {
    }

    public ResourceEntry getEntry(String inRelativePath) throws ResourceException {
        this.verifyValid();
        if (ResourceStringUtils.getSeparatorIdx(inRelativePath, 0) == 0) {
            throw new ResourceException("rsrc.msg0315");
        }
        return (ResourceEntry)this.mPathToResourceEntryHash.get(this.makeHashIdx(inRelativePath));
    }

    public int getNumEntries() throws ResourceException {
        this.verifyValid();
        return this.mPathToResourceEntryHash.size();
    }

    public void addResourceEntry(ResourceEntry inEntry) {
        this.mPathToResourceEntryHash.put(this.makeHashIdx(inEntry.getRelPathWFwdSlashes()), inEntry);
    }

    private void associateZipWithRelPath(ZipEntry inZipEntry, ResourceEntry inResourceEntry) {
        this.mPathToZipEntryHash.put(inResourceEntry.getRelPathWFwdSlashes(), inZipEntry);
    }

    public InputStream getInputStream(ResourceEntry inResourceEntry) throws ResourceException {
        this.verifyValid();
        if (this.mPathToZipEntryHash == null) {
            throw new ResourceException("rsrc.msg0352");
        }
        if (!inResourceEntry.getType().equals(SubnodeType.FILE)) {
            throw new ResourceException("rsrc.msg0316");
        }
        VersionNumber theBackRef = this.getEntry(inResourceEntry.getRelPathWFwdSlashes()).getBackRef();
        if (theBackRef != null) {
            throw new ResourceException(new Exception("Unexpected error"));
        }
        ZipEntry theZipEntry = (ZipEntry)this.mPathToZipEntryHash.get(inResourceEntry.getRelPathWFwdSlashes());
        if (theZipEntry == null) {
            throw new ResourceException("rsrc.msg0317", new Object[]{inResourceEntry.getRelPathWFwdSlashes()});
        }
        try {
            return this.mZipFile.getInputStream(theZipEntry);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    private String makeHashIdx(String inRelPath) {
        inRelPath = ResourceParser.stripRoot(inRelPath);
        return ResourceStringUtils.coerceSeparators(inRelPath, '/');
    }

    void toObjectStream(ObjectOutputStream inObjectOutStream) throws IOException {
        inObjectOutStream.writeObject(new String(sManifestIdentifier));
        inObjectOutStream.writeObject(this);
    }

    static ResourceManifest fromObjectStream(ObjectInputStream inObjectInStream) throws ResourceException {
        ResourceManifest theResult = null;
        try {
            String theManifestTag = (String)inObjectInStream.readObject();
            if (!theManifestTag.equals(sManifestIdentifier)) {
                throw new ResourceException("rsrc.msg0302");
            }
            theResult = (ResourceManifest)inObjectInStream.readObject();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceException(e);
        }
        return theResult;
    }

    public static final String getOSName() {
        if (PlatformUtil.isCygwin()) {
            return "Cygwin";
        }
        return System.getProperty("os.name");
    }

    private void set(ResourceManifest inInflatedManifest) throws ResourceException {
        this.mCheckinOSName = inInflatedManifest.mCheckinOSName;
        this.mPathToResourceEntryHash = new HashMap();
        ResourceEntryIterator theIter = inInflatedManifest.getEntryIterator();
        while (theIter.hasNext()) {
            ResourceEntry theInflatedResourceEntry = theIter.next();
            this.addResourceEntry(theInflatedResourceEntry);
        }
    }

    private void adopt(ZipFile inZipFile) throws ResourceException {
        if (this.mZipFile != null) {
            throw new ResourceException("rsrc.msg0318");
        }
        this.mZipFile = inZipFile;
    }

    public static ResourceManifest createVirtualManifest(ResourceID inResourceID, ResourceEntry[] inResourceEntries) {
        ResourceManifest theManifest = new ResourceManifest();
        for (int i = 0; i < inResourceEntries.length; ++i) {
            theManifest.addResourceEntry(inResourceEntries[i]);
        }
        theManifest.setResourceID(inResourceID);
        return theManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceManifest getFileManifest(Resource inResource, ResourceSubsysImpl inRsrcCtx, PushID inPushID, boolean inHonorDeleteLockMutex) throws ResourceException {
        inRsrcCtx.lockResource(inResource, inPushID, inHonorDeleteLockMutex);
        File theFile = inResource.getInternalRepoFile(inRsrcCtx);
        ResourceManifest theManifest = null;
        try {
            theManifest = ResourceManifest.getFileManifest(theFile);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var7_7 = null;
                try {
                    inRsrcCtx.unlockResource(inResource);
                }
                catch (ResourceException e) {
                    if (!Logger.isErrorEnabled(ResourceManifest.class.getName())) break block7;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.UNLOCK_FAILED", new Object[]{inResource}), ResourceManifest.class.getName());
                }
            }
            throw throwable;
        }
        try {
            inRsrcCtx.unlockResource(inResource);
        }
        catch (ResourceException e) {
            if (Logger.isErrorEnabled(ResourceManifest.class.getName())) {
                Logger.error(ROXMessageManager.messageAsString("rsrc.UNLOCK_FAILED", new Object[]{inResource}), ResourceManifest.class.getName());
            }
        }
        theManifest.setResourceID(inResource.getResourceID());
        theManifest.setPushID(inPushID, inRsrcCtx);
        return theManifest;
    }

    /*
     * Loose catch block
     */
    public static ResourceManifest getFileManifest(File inResourceFile) throws ResourceException {
        ResourceManifest theManifest;
        block14: {
            ZipEntry theZipEntry;
            theManifest = null;
            ZipFile theZipFile = null;
            theZipFile = new ZipFile(inResourceFile);
            theManifest = new ResourceManifest();
            Enumeration<? extends ZipEntry> theEntries = theZipFile.entries();
            boolean foundEncodedManifest = false;
            while (theEntries.hasMoreElements()) {
                theZipEntry = theEntries.nextElement();
                if (!ZipArchive.isManifestEntry(theZipEntry)) continue;
                ObjectInputStream theObjectInStream = ResourceFileUtils.getObjectInputStreamFromZipEntry(theZipFile, theZipEntry);
                ResourceManifest theInflatedManifest = ResourceManifest.fromObjectStream(theObjectInStream);
                theManifest.set(theInflatedManifest);
                foundEncodedManifest = true;
                break;
            }
            theEntries = theZipFile.entries();
            while (theEntries.hasMoreElements()) {
                theZipEntry = theEntries.nextElement();
                if (ZipArchive.isManifestEntry(theZipEntry)) continue;
                ResourceEntry theResourceEntry = null;
                if (foundEncodedManifest) {
                    String theEntryName = ZipPacker.entryName_ZipToRsrc(theZipEntry);
                    theResourceEntry = theManifest.getEntry(theEntryName);
                } else {
                    theResourceEntry = new ResourceEntry(theZipEntry);
                    theManifest.addResourceEntry(theResourceEntry);
                }
                theManifest.associateZipWithRelPath(theZipEntry, theResourceEntry);
            }
            theManifest.adopt(theZipFile);
            theZipFile = null;
            Object var9_9 = null;
            try {
                if (theZipFile != null) {
                    theZipFile.close();
                }
                break block14;
            }
            catch (IOException e) {
                if (Logger.isErrorEnabled(ResourceManifest.class.getName())) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.FILE_CLOSE_FAILED", new Object[]{inResourceFile}), ResourceManifest.class.getName());
                }
                break block14;
            }
            {
                catch (IOException e) {
                    throw new ResourceException("rsrc.msg0439", (Throwable)e, new Object[]{inResourceFile});
                }
            }
            catch (Throwable throwable) {
                block15: {
                    Object var9_10 = null;
                    try {
                        if (theZipFile != null) {
                            theZipFile.close();
                        }
                    }
                    catch (IOException e) {
                        if (!Logger.isErrorEnabled(ResourceManifest.class.getName())) break block15;
                        Logger.error(ROXMessageManager.messageAsString("rsrc.FILE_CLOSE_FAILED", new Object[]{inResourceFile}), ResourceManifest.class.getName());
                    }
                }
                throw throwable;
            }
        }
        return theManifest;
    }
}

