/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import java.util.HashMap;
import java.util.Iterator;

public class ResourceEntryIterator {
    private Iterator mIter;
    private SegIter mSegIter;
    private boolean mForTestOnly_showAllFields = false;

    public ResourceEntryIterator(SegIter inSegIter) {
        this.mSegIter = inSegIter;
    }

    public ResourceEntryIterator(HashMap inPathToEntryHash) {
        this.mIter = inPathToEntryHash.values().iterator();
    }

    public boolean hasNext() throws ResourceException {
        if (this.mSegIter != null) {
            return this.mSegIter.hasMoreSubfiles();
        }
        return this.mIter.hasNext();
    }

    public ResourceEntry next() throws ResourceException {
        if (this.mSegIter != null) {
            SegEntry theSegEntry = this.mSegIter.getNextSubfile();
            if (theSegEntry == null) {
                return null;
            }
            if (!this.mForTestOnly_showAllFields) {
                return RsrcManifest.makeResourceEntry(theSegEntry);
            }
            NodePerms thePerms = theSegEntry.getPerms();
            if (thePerms != null) {
                thePerms = thePerms.duplicate();
            }
            return new ResourceEntry(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getBackRef(), thePerms, theSegEntry.getFileMd5PerCompressionSetting(), theSegEntry.getLinkTarget());
        }
        return (ResourceEntry)this.mIter.next();
    }

    public String peekNextSubfileRelPath() throws ResourceException {
        return this.mSegIter.peekNextSubfileRelPath();
    }

    public void forTestOnly_showAllFields(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        this.mForTestOnly_showAllFields = true;
    }
}

