/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.packageformat.ZipPacker;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.util.unicode.Encoding;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;

public class ResourceEntry
implements RPCSerializable,
Serializable {
    static final long serialVersionUID = -4418354698021985947L;
    private static final int sCurrentVersion = 0;
    private static final int sNoBackRef = -1;
    private String mRelPath = null;
    private long mSize = 0L;
    private long mTime = 0L;
    private int mBackRefVersion = -1;
    private String mSubnodeTypeString = null;
    private NodePerms mNodePerms = null;
    private byte[] mDigest = null;
    private String mLinkTarget = null;
    private static final String sEncodedPrefix = "_ENCODED_ ";
    private static final String sSizeLabel = " SIZE: ";
    private static final String sTimeLabel = " TIME: ";
    private static final String sBackRefLabel = " BACKREF: ";
    private static final String sLinkTargetLabel = " LINKTGT: ";
    private static final String sFieldEnd = "|";

    public ResourceEntry() {
    }

    private static VersionNumber intToVersion(int inInteger) {
        if (inInteger == -1) {
            return null;
        }
        VersionNumber theVersion = new VersionNumber((short)(0xFFFF & inInteger >> 16), (short)(0xFFFF & inInteger));
        return theVersion;
    }

    private void init(String inRelPath, long inSize, long inTime, SubnodeType inSubnodeType, VersionNumber inBackVersionNumber, NodePerms inNodePerms, byte[] inDigest, String inLinkTarget) {
        this.mRelPath = ResourceStringUtils.coerceSeparators(inRelPath, '/');
        if (!inSubnodeType.equals(SubnodeType.SYMLINK) && ResourceStringUtils.endsInSeparator(inRelPath) != inSubnodeType.equals(SubnodeType.DIRECTORY)) {
            inSubnodeType = ResourceStringUtils.endsInSeparator(inRelPath) ? SubnodeType.DIRECTORY : SubnodeType.FILE;
        }
        this.mSize = inSize;
        this.mTime = inTime;
        this.mBackRefVersion = inBackVersionNumber == null ? -1 : inBackVersionNumber.getSingleVersionNumber();
        this.mSubnodeTypeString = inSubnodeType.toString();
        this.mNodePerms = inNodePerms;
        this.mDigest = inDigest;
        this.mLinkTarget = inLinkTarget;
        if (inLinkTarget != null != inSubnodeType.equals(SubnodeType.SYMLINK)) {
            throw new IllegalStateException();
        }
    }

    public ResourceEntry(String inRelPath, long inSize, long inTime, SubnodeType inSubnodeType, VersionNumber inBackVersionNumber, NodePerms inNodePerms, byte[] inDigest, String inLinkTarget) {
        this.init(inRelPath, inSize, inTime, inSubnodeType, inBackVersionNumber, inNodePerms, inDigest, inLinkTarget);
    }

    public ResourceEntry(ZipEntry inZipEntry) throws ResourceException {
        String theRsrcEntryName = ZipPacker.entryName_ZipToRsrc(inZipEntry);
        if (this.decodeZipExtra(inZipEntry)) {
            SubnodeType theSubnodeType;
            SubnodeType subnodeType = theSubnodeType = inZipEntry.isDirectory() ? SubnodeType.DIRECTORY : SubnodeType.FILE;
            if (this.mLinkTarget != null) {
                theSubnodeType = SubnodeType.SYMLINK;
            }
            this.init(theRsrcEntryName, this.mSize, this.mTime, theSubnodeType, ResourceEntry.intToVersion(this.mBackRefVersion), null, null, this.mLinkTarget);
        } else {
            this.init(theRsrcEntryName, inZipEntry.getSize(), inZipEntry.getTime(), inZipEntry.isDirectory() ? SubnodeType.DIRECTORY : SubnodeType.FILE, null, null, null, null);
        }
    }

    public ResourceEntry(ResourceEntry inOther) {
        this.init(inOther.mRelPath, inOther.mSize, inOther.mTime, inOther.getType(), inOther.getBackRef(), inOther.mNodePerms, inOther.mDigest, inOther.mLinkTarget);
    }

    public String getRelPathWFwdSlashes() {
        return this.mRelPath;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getTime() {
        return this.mTime;
    }

    public VersionNumber getBackRef() {
        return ResourceEntry.intToVersion(this.mBackRefVersion);
    }

    public SubnodeType getType() {
        return SubnodeType.FACTORY.get(this.mSubnodeTypeString);
    }

    public byte[] getDigest() {
        return this.mDigest;
    }

    public String getLinkTarget() {
        return this.mLinkTarget;
    }

    public NodePerms getPerms() {
        return this.mNodePerms;
    }

    void setPerms(NodePerms inNodePerms) throws ResourceException {
        this.mNodePerms = inNodePerms;
    }

    public void clearPerms(NodePerms inNodePerms) {
        this.mNodePerms = null;
    }

    public byte[] getMD5Digest() {
        return this.mDigest;
    }

    private static void packData(long inData, String inLabel, StringBuffer inBuffer) {
        ResourceEntry.packData("" + inData, inLabel, inBuffer);
    }

    private static void packData(String inData, String inLabel, StringBuffer inBuffer) {
        inBuffer.append(inLabel);
        inBuffer.append(inData);
        inBuffer.append(sFieldEnd);
    }

    public static byte[] encodeZipExtra(long inSize, long inTime, VersionNumber inVersionNumber, String inLinkTarget) throws ResourceException {
        StringBuffer theStringBuffer = new StringBuffer(sEncodedPrefix);
        ResourceEntry.packData(inSize, sSizeLabel, theStringBuffer);
        ResourceEntry.packData(inTime, sTimeLabel, theStringBuffer);
        if (inVersionNumber != null) {
            ResourceEntry.packData(inVersionNumber.getAsString(), sBackRefLabel, theStringBuffer);
        }
        if (inLinkTarget != null) {
            ResourceEntry.packData(inLinkTarget, sLinkTargetLabel, theStringBuffer);
        }
        try {
            return theStringBuffer.toString().getBytes(Encoding.UTF8.getName());
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
    }

    private String unpackData(String inLabel, String inBuffer) {
        int theStartIdx = inBuffer.indexOf(inLabel);
        if (theStartIdx == -1) {
            return null;
        }
        int theEndIdx = inBuffer.indexOf(sFieldEnd, theStartIdx += sSizeLabel.length());
        return inBuffer.substring(theStartIdx, theEndIdx);
    }

    private boolean decodeZipExtra(ZipEntry inZipEntry) throws ResourceException {
        byte[] theExtra = inZipEntry.getExtra();
        if (theExtra == null) {
            return false;
        }
        String theExtraString = null;
        try {
            theExtraString = new String(theExtra, Encoding.UTF8.getName());
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        if (!theExtraString.startsWith(sEncodedPrefix)) {
            return false;
        }
        String theSizeString = this.unpackData(sSizeLabel, theExtraString);
        if (theSizeString == null) {
            throw new ResourceException("rsrc.msg0287", new Object[]{theExtraString});
        }
        this.mSize = Long.decode(theSizeString);
        String theTimeString = this.unpackData(sTimeLabel, theExtraString);
        if (theTimeString == null) {
            throw new ResourceException("rsrc.msg0288", new Object[]{theExtraString});
        }
        this.mTime = Long.decode(theTimeString);
        this.mBackRefVersion = -1;
        String theBackRefString = this.unpackData(sBackRefLabel, theExtraString);
        if (theBackRefString != null) {
            VersionNumber theVersionNumber;
            try {
                theVersionNumber = new VersionNumber(theBackRefString);
            }
            catch (PersistenceManagerException e) {
                throw new ResourceException("rsrc.msg0289", new Object[]{theExtraString});
            }
            this.mBackRefVersion = theVersionNumber.getSingleVersionNumber();
        }
        this.mLinkTarget = this.unpackData(sLinkTargetLabel, theExtraString);
        return true;
    }
}

