/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.RawClusterStream;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcPacker;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public abstract class ResourceContentTransformer {
    private ResourceSubsystem mCtx;
    private ResourceSubsysImpl mSubsysImpl;

    protected abstract boolean transformEntryStream(ResourceEntry var1, InputStream var2, OutputStream var3) throws ResourceException, IOException;

    public ResourceContentTransformer(ResourceSubsystem inCtx) {
        this.mCtx = inCtx;
        this.mSubsysImpl = this.mCtx.getImpl(Key.sKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(final ResourceID inResourceID, final boolean inOnlyNonBackRefs, boolean inDoDifferentialMatches) throws ResourceException {
        RsrcInfo theRsrcInfo;
        try {
            theRsrcInfo = this.mCtx.getRsrcInfo(inResourceID, null);
        }
        catch (RPCException e) {
            throw new ResourceException(e);
        }
        final Resource thePrevResource = inDoDifferentialMatches ? this.mSubsysImpl.getNextLowestVersion(theRsrcInfo.getResourceSpec(), theRsrcInfo.getVersionNumber()) : null;
        Version_TmpFile_Pair[] theFilesToSwap = (Version_TmpFile_Pair[])new ResourceAccessor(this.mCtx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object innerAccess() throws ResourceException {
                HashMap theOriginalTransformedPathToDigestChanges = new HashMap();
                RsrcManifest theOrigManifest = this.getManifest(inResourceID, null);
                File theTmpNewResource = ResourceContentTransformer.this.packTransformedTmpFile(theOrigManifest, theOriginalTransformedPathToDigestChanges, thePrevResource, inOnlyNonBackRefs, this);
                if (theOriginalTransformedPathToDigestChanges.size() == 0) {
                    ResourceFileUtils.deleteDirectory(theTmpNewResource);
                    return null;
                }
                Vector<Version_TmpFile_Pair> theSwapsVec = new Vector<Version_TmpFile_Pair>();
                theSwapsVec.add(new Version_TmpFile_Pair(theRsrcInfo.getVersionNumber(), theTmpNewResource));
                HashMap theRelPathToVersionChanges = new HashMap();
                boolean gotAllSwapInfo = false;
                try {
                    Resource theNextVersion;
                    VersionNumber thePrevVersion = theRsrcInfo.getVersionNumber();
                    while ((theOriginalTransformedPathToDigestChanges.size() > 0 || theRelPathToVersionChanges.size() > 0) && (theNextVersion = ResourceContentTransformer.this.mSubsysImpl.getNextHighestVersion(theRsrcInfo.getResourceSpec(), thePrevVersion)) != null) {
                        File theFile = ResourceContentTransformer.this.packTransformedReferringFile(theNextVersion, theOriginalTransformedPathToDigestChanges, theRelPathToVersionChanges, this);
                        if (theFile != null) {
                            theSwapsVec.add(new Version_TmpFile_Pair(theNextVersion.getVersionNumber(), theFile));
                        }
                        thePrevVersion = theNextVersion.getVersionNumber();
                    }
                    gotAllSwapInfo = true;
                    Object var11_10 = null;
                    if (gotAllSwapInfo) return theSwapsVec.toArray(new Version_TmpFile_Pair[0]);
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (gotAllSwapInfo) throw throwable;
                    while (theSwapsVec.size() > 0) {
                        Version_TmpFile_Pair thePair = (Version_TmpFile_Pair)theSwapsVec.remove(0);
                        ResourceFileUtils.deleteDirectorySnuff(thePair.mTmpFile);
                    }
                    throw throwable;
                }
                while (theSwapsVec.size() > 0) {
                    Version_TmpFile_Pair thePair = (Version_TmpFile_Pair)theSwapsVec.remove(0);
                    ResourceFileUtils.deleteDirectorySnuff(thePair.mTmpFile);
                }
                return theSwapsVec.toArray(new Version_TmpFile_Pair[0]);
            }
        }.access();
        if (theFilesToSwap != null) {
            Vector<FileSrcDst> theUnwinds = new Vector<FileSrcDst>();
            boolean success = false;
            try {
                for (int i = 0; i < theFilesToSwap.length; ++i) {
                    Version_TmpFile_Pair thePair = theFilesToSwap[i];
                    Resource theResource = this.mSubsysImpl.getResource(theRsrcInfo.getResourceSpec(), thePair.mVersion, null);
                    File theRepoFile = theResource.getInternalRepoFile(this.mSubsysImpl);
                    File theTmpFile = null;
                    try {
                        theTmpFile = File.createTempFile("SwappedOut_", null);
                    }
                    catch (IOException e) {
                        throw new ResourceException(e);
                    }
                    ResourceFileUtils.deleteDirectorySnuff(theTmpFile);
                    ResourceFileUtils.moveData(theRepoFile, theTmpFile);
                    theUnwinds.add(new FileSrcDst(theTmpFile, theRepoFile));
                    ResourceFileUtils.moveData(thePair.mTmpFile, theRepoFile);
                }
                success = true;
                Object var16_16 = null;
                this.finalize(success, theUnwinds.toArray(new FileSrcDst[0]));
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                this.finalize(success, theUnwinds.toArray(new FileSrcDst[0]));
                throw throwable;
            }
        }
    }

    private void finalize(boolean inSuccess, FileSrcDst[] inUnwinds) {
        String kEOL = System.getProperty("line.separator");
        if (inSuccess) {
            for (int i = 0; i < inUnwinds.length; ++i) {
                try {
                    ResourceFileUtils.deleteDirectory(inUnwinds[i].mSrc);
                    continue;
                }
                catch (Throwable t) {
                    if (!Logger.isWarnEnabled(this)) continue;
                    Logger.warn("Error while trying to delete scratch file: " + inUnwinds[i].mSrc, this);
                }
            }
        } else {
            StringBuffer theErrMsgs = null;
            for (int i = inUnwinds.length - 1; i >= 0; --i) {
                boolean didMove = false;
                try {
                    ResourceFileUtils.deleteDirectory(inUnwinds[i].mDst);
                    ResourceFileUtils.moveData(inUnwinds[i].mSrc, inUnwinds[i].mDst);
                    didMove = true;
                }
                catch (ResourceException e) {
                    // empty catch block
                }
                if (didMove || !Logger.isErrorEnabled(this)) continue;
                if (theErrMsgs == null) {
                    theErrMsgs = new StringBuffer();
                    theErrMsgs.append("---------------------------------------------------------------------- " + kEOL);
                    theErrMsgs.append("To reconstruct the state of the repo prior to this failed transaction, " + kEOL);
                    theErrMsgs.append("move each of the src files below to its corresponding listed destination: " + kEOL);
                }
                theErrMsgs.append(kEOL);
                theErrMsgs.append("\tSrc: " + inUnwinds[i].mSrc + kEOL);
                theErrMsgs.append("\tDst: " + inUnwinds[i].mDst + kEOL);
            }
            if (theErrMsgs != null) {
                theErrMsgs.append("---------------------------------------------------------------------- " + kEOL);
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(theErrMsgs.toString(), this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File packTransformedTmpFile(RsrcManifest inOrigManifest, HashMap ioRelPathToDigestChanges, Resource inPrevResource, boolean inOnlyNonBackRefs, ResourceAccessor inAccessor) throws ResourceException {
        ioRelPathToDigestChanges.clear();
        RsrcManifest thePrevManifest = null;
        if (inPrevResource != null) {
            thePrevManifest = inAccessor.getManifest(inPrevResource.getResourceID(), null);
        }
        SegIter theOrigIter = SegIter.makeIter(Key.sKey, inOrigManifest);
        RsrcPacker theRsrcPacker = new RsrcPacker(null, inOrigManifest.getTopLevelRsrcName());
        boolean didSucceed = true;
        try {
            while (theOrigIter.hasMoreSubfiles()) {
                File theTmpCompressedData;
                block19: {
                    Object var18_18;
                    SegEntry theSegEntry = theOrigIter.getNextSubfile();
                    if (!theSegEntry.getType().equals(SubnodeType.FILE) || inOnlyNonBackRefs && theSegEntry.getBackRef() != null) {
                        theRsrcPacker.packEntryCluster(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getSizePerCompressionSetting(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getPerms(), theSegEntry.getLinkTarget(), theSegEntry.getFileMd5PerCompressionSetting(), theSegEntry.getCompression(), theSegEntry.getBackRef());
                        continue;
                    }
                    theTmpCompressedData = ResourceFileUtils.createTempFile("CompressedTransformed_");
                    File theTmpStoredEntryData = this.writeTransformedStreamToFile(theSegEntry, inOrigManifest.getInputStream(theSegEntry.getRelPathWFwdSlashes()));
                    try {
                        boolean didChange = false;
                        if (theTmpStoredEntryData != null) {
                            byte[] theNewDigest = MiscUtils.compressAndGetMD5(theTmpStoredEntryData, theTmpCompressedData);
                            if (!Arrays.equals(theSegEntry.getFileMd5PerCompressionSetting(), theNewDigest) || theSegEntry.getUncompressedFileSize() != theTmpStoredEntryData.length()) {
                                SegEntry thePrevEntry;
                                didChange = true;
                                ioRelPathToDigestChanges.put(theSegEntry.getRelPathWFwdSlashes(), theNewDigest);
                                VersionNumber theNewBackRef = null;
                                if (inPrevResource != null && (thePrevEntry = thePrevManifest.getFirstClusterSegEntry(Key.sKey, theSegEntry.getRelPathWFwdSlashes())) != null && Arrays.equals(thePrevEntry.getFileMd5PerCompressionSetting(), theNewDigest) && thePrevEntry.getUncompressedFileSize() == theTmpStoredEntryData.length()) {
                                    theNewBackRef = thePrevEntry.getBackRef() == null ? inPrevResource.getVersionNumber() : thePrevEntry.getBackRef();
                                }
                                theRsrcPacker.packEntryCluster(theSegEntry.getRelPathWFwdSlashes(), theTmpStoredEntryData.length(), theTmpCompressedData.length(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getPerms(), theSegEntry.getLinkTarget(), theNewDigest, true, theNewBackRef);
                                if (theNewBackRef == null) {
                                    try {
                                        theRsrcPacker.packThenCloseDataStream(new FileInputStream(theTmpCompressedData), theTmpCompressedData.length());
                                    }
                                    catch (FileNotFoundException e) {
                                        throw new ResourceException(e);
                                    }
                                }
                            }
                        }
                        if (!didChange) {
                            theRsrcPacker.packEntryCluster(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getSizePerCompressionSetting(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getPerms(), theSegEntry.getLinkTarget(), theSegEntry.getFileMd5PerCompressionSetting(), theSegEntry.getCompression(), theSegEntry.getBackRef());
                            if (theSegEntry.getBackRef() == null) {
                                theRsrcPacker.packThenCloseDataStream(inOrigManifest.getRawClusterStream(Key.sKey, theSegEntry.getRelPathWFwdSlashes()), theSegEntry.getSizePerCompressionSetting());
                            }
                        }
                        var18_18 = null;
                        if (theTmpStoredEntryData == null) break block19;
                    }
                    catch (Throwable throwable) {
                        var18_18 = null;
                        if (theTmpStoredEntryData != null) {
                            ResourceFileUtils.deleteDirectorySnuff(theTmpStoredEntryData);
                        }
                        if (theTmpCompressedData == null) throw throwable;
                        ResourceFileUtils.deleteDirectorySnuff(theTmpCompressedData);
                        throw throwable;
                    }
                    ResourceFileUtils.deleteDirectorySnuff(theTmpStoredEntryData);
                }
                if (theTmpCompressedData == null) continue;
                ResourceFileUtils.deleteDirectorySnuff(theTmpCompressedData);
            }
            didSucceed = true;
            return theRsrcPacker.getWorkspaceDir();
        }
        finally {
            if (didSucceed) {
                theRsrcPacker.finish();
            } else {
                theRsrcPacker.deleteDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File packTransformedReferringFile(Resource inResource, HashMap ioOriginalTransformedPathToDigestChanges, HashMap ioRelPathToVersionChanges, ResourceAccessor inAccessor) throws ResourceException {
        RsrcManifest theOrigManifest = inAccessor.getManifest(inResource.getResourceID(), null);
        boolean needReformulation = false;
        SegIter theIter = SegIter.makeIter(Key.sKey, theOrigManifest);
        while (theIter.hasMoreSubfiles()) {
            SegEntry theEntry = theIter.getNextSubfile();
            if (theEntry.getBackRef() == null) {
                ioOriginalTransformedPathToDigestChanges.remove(theEntry.getRelPathWFwdSlashes());
                ioRelPathToVersionChanges.remove(theEntry.getRelPathWFwdSlashes());
                continue;
            }
            if (needReformulation) continue;
            String theRelPath = theEntry.getRelPathWFwdSlashes();
            needReformulation = ioOriginalTransformedPathToDigestChanges.get(theRelPath) != null || ioRelPathToVersionChanges.get(theRelPath) != null;
        }
        if (!needReformulation) {
            return null;
        }
        RsrcPacker theRsrcPacker = new RsrcPacker(null, theOrigManifest.getTopLevelRsrcName());
        theIter = SegIter.makeIter(Key.sKey, theOrigManifest);
        boolean didSucceed = true;
        try {
            while (theIter.hasMoreSubfiles()) {
                SegEntry theSegEntry = theIter.getNextSubfile();
                String theRelPath = theSegEntry.getRelPathWFwdSlashes();
                VersionNumber theBackRef = null;
                RawClusterStream theInputStream = null;
                if (!theSegEntry.getType().equals(SubnodeType.FILE)) {
                    theBackRef = theSegEntry.getBackRef();
                } else if (theSegEntry.getBackRef() == null) {
                    theBackRef = theSegEntry.getBackRef();
                    theInputStream = theOrigManifest.getRawClusterStream(Key.sKey, theRelPath);
                } else if (ioOriginalTransformedPathToDigestChanges.get(theRelPath) != null) {
                    theBackRef = null;
                    theInputStream = theOrigManifest.getRawClusterStream(Key.sKey, theRelPath);
                    ioOriginalTransformedPathToDigestChanges.remove(theRelPath);
                    ioRelPathToVersionChanges.put(theRelPath, inResource.getVersionNumber());
                } else {
                    theBackRef = ioRelPathToVersionChanges.get(theRelPath) != null ? (VersionNumber)ioRelPathToVersionChanges.get(theRelPath) : theSegEntry.getBackRef();
                }
                theRsrcPacker.packEntryCluster(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getSizePerCompressionSetting(), theSegEntry.getTime(), theSegEntry.getType(), theSegEntry.getPerms(), theSegEntry.getLinkTarget(), theSegEntry.getFileMd5PerCompressionSetting(), theSegEntry.getCompression(), theBackRef);
                theRsrcPacker.packThenCloseDataStream(theInputStream, theSegEntry.getSizePerCompressionSetting());
            }
            didSucceed = true;
        }
        finally {
            if (didSucceed) {
                theRsrcPacker.finish();
            } else {
                theRsrcPacker.deleteDirSnuff();
            }
        }
        return theRsrcPacker.getWorkspaceDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private File writeTransformedStreamToFile(SegEntry theEntry, InputStream theEntryInputStream) throws ResourceException {
        theTmpStoredEntryData = null;
        try {
            theTmpStoredEntryData = File.createTempFile("tmpEntryData_", null);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        succeeded = false;
        didTransform = false;
        try {
            theOutputStream = null;
            try {
                theOutputStream = new FileOutputStream(theTmpStoredEntryData);
            }
            catch (FileNotFoundException e) {
                throw new ResourceException(e);
            }
            didSucceed = false;
            try {
                try {
                    didTransform = this.transformEntryStream(RsrcManifest.makeResourceEntry(theEntry), theEntryInputStream, theOutputStream);
                }
                catch (IOException e) {
                    throw new ResourceException(e);
                }
                didSucceed = true;
                var10_11 = null;
            }
            catch (Throwable var9_15) {
                block15: {
                    var10_12 = null;
                    try {
                        theOutputStream.close();
                    }
                    catch (IOException e) {
                        if (!didSucceed) break block15;
                        throw new ResourceException(e);
                    }
                }
                throw var9_15;
            }
            try {
                theOutputStream.close();
            }
            catch (IOException e) {
                if (!didSucceed) ** GOTO lbl43
                throw new ResourceException(e);
            }
lbl43:
            // 2 sources

            succeeded = true;
        }
        finally {
            if (!succeeded || !didTransform) {
                ResourceFileUtils.deleteDirectorySnuff(theTmpStoredEntryData);
            }
        }
        return didTransform != false ? theTmpStoredEntryData : null;
    }

    static class FileSrcDst {
        File mSrc;
        File mDst;

        FileSrcDst(File inSrc, File inDst) {
            this.mSrc = inSrc;
            this.mDst = inDst;
        }
    }

    static class Version_TmpFile_Pair {
        public VersionNumber mVersion;
        public File mTmpFile;

        public Version_TmpFile_Pair(VersionNumber inVersion, File inTmpFile) {
            if (inVersion == null || inTmpFile == null) {
                throw new NullPointerException();
            }
            this.mVersion = inVersion;
            this.mTmpFile = inTmpFile;
        }
    }
}

