/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.VersionMap;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.RawClusterStream;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessBlock;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.packageformat.SizedStream;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.packageformat.ZipPacker;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipOutputStream;

public abstract class ResourceAccessor
implements Messages {
    private boolean mIsMS;
    private ResourceSubsysImpl mRsrcCtx = null;
    private HashMap mRsrcAccessBlocks = null;
    private boolean mValid = false;
    private ArrayList mTmpFileBlocks = null;
    private VersionMap mFwdDeletionMap;
    private HashSet mRawClusterStreams = null;

    public abstract Object innerAccess() throws ResourceException;

    public ResourceAccessor(ResourceSubsystem inResourceSubsystem) {
        this(inResourceSubsystem.getImpl(Key.sKey), null);
    }

    public ResourceAccessor(ResourceSubsysImpl inRsrcCtx, VersionMap inFwdDeletionMap) {
        this.mRsrcCtx = inRsrcCtx;
        this.mIsMS = inRsrcCtx.isServer();
        this.mFwdDeletionMap = inFwdDeletionMap;
        if (this.mFwdDeletionMap == null) {
            this.mFwdDeletionMap = new VersionMap();
        }
    }

    public ResourceSubsysImpl getResourceSubsysImpl() {
        return this.mRsrcCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateAccess() throws ResourceException {
        ResourceAccessor resourceAccessor = this;
        synchronized (resourceAccessor) {
            if (this.mRsrcAccessBlocks == null || !this.mValid) {
                throw new ResourceException("rsrc.msg0308");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened(RawClusterStream inStream) throws ResourceException {
        ResourceAccessor resourceAccessor = this;
        synchronized (resourceAccessor) {
            if (this.mRawClusterStreams == null) {
                MiscUtils.throwUPE(1340488L);
            }
            this.mRawClusterStreams.add(inStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(RawClusterStream inStream) {
        ResourceAccessor resourceAccessor = this;
        synchronized (resourceAccessor) {
            if (this.mRawClusterStreams != null) {
                this.mRawClusterStreams.remove(inStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object access() throws ResourceException {
        this.beginUse(Key.sKey);
        Object theResult = null;
        try {
            theResult = this.innerAccess();
        }
        finally {
            this.endUse(Key.sKey);
        }
        return theResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginUse(Object inKey) throws ResourceException {
        TransPackageKeys.verifyResourceKey(inKey);
        ResourceAccessor resourceAccessor = this;
        synchronized (resourceAccessor) {
            if (this.mRsrcAccessBlocks != null) {
                throw new ResourceException("rsrc.msg0309");
            }
            this.mRsrcAccessBlocks = new HashMap();
            this.mTmpFileBlocks = new ArrayList();
            this.mRawClusterStreams = new HashSet();
            this.mValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUse(Object inKey) throws ResourceException {
        InputStream[] theInputStreamsToClose;
        TransPackageKeys.verifyResourceKey(inKey);
        ResourceAccessor resourceAccessor = this;
        synchronized (resourceAccessor) {
            this.mValid = false;
        }
        Iterator theResourceAccessBlockIter = this.mRsrcAccessBlocks.values().iterator();
        while (theResourceAccessBlockIter.hasNext()) {
            try {
                ((ResourceAccessBlock)theResourceAccessBlockIter.next()).dispose();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) continue;
                Logger.error(ROXMessageManager.messageAsString("rsrc.BLOCK_CLEANUP_FAILED"), e, this);
            }
        }
        Iterator theTmpFileBlockIter = this.mTmpFileBlocks.iterator();
        while (theTmpFileBlockIter.hasNext()) {
            try {
                ((TmpFileBlock)theTmpFileBlockIter.next()).dispose();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) continue;
                Logger.error(ROXMessageManager.messageAsString("rsrc.TMP_BLOCK_CLEANUP_FAILED"), e, this);
            }
        }
        ResourceAccessor resourceAccessor2 = this;
        synchronized (resourceAccessor2) {
            theInputStreamsToClose = this.mRawClusterStreams.toArray(new InputStream[0]);
            this.mRawClusterStreams = null;
        }
        for (int i = 0; i < theInputStreamsToClose.length; ++i) {
            try {
                theInputStreamsToClose[i].close();
                continue;
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) continue;
                Logger.error(ROXMessageManager.messageAsString("rsrc.TMP_BLOCK_CLEANUP_FAILED"), e, this);
            }
        }
        ResourceAccessor resourceAccessor3 = this;
        synchronized (resourceAccessor3) {
            this.mRsrcAccessBlocks = null;
        }
    }

    public RsrcManifest getManifest(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        RsrcManifest theVirtualResult;
        this.validateAccess();
        if (inPushID != null && (theVirtualResult = this.checkForVirtualRsrcManifest(inResourceID, inPushID)) != null) {
            return theVirtualResult;
        }
        Resource theResource = this.mRsrcCtx.getResource(inResourceID, inPushID);
        RsrcManifest theManifest = this.getResourceAccessBlock(theResource, inPushID, false).getRsrcManifest();
        return theManifest;
    }

    private RsrcManifest checkForVirtualRsrcManifest(ResourceID inResourceID, PushID inPushID) throws ResourceException {
        RsrcPush thePush;
        if (inPushID != null && (thePush = this.mRsrcCtx.getRsrcPush(inPushID)) != null) {
            return thePush.getVirtualManifest(inResourceID);
        }
        return null;
    }

    RsrcManifest getBackRsrcManifest(RsrcManifest inManifest, VersionNumber inVersion) throws ResourceException {
        PushID thePushID;
        this.validateAccess();
        ResourceAccessBlock theBlock = this.findResourceAccessBlock(inManifest);
        ResourceSpec theResourceSpec = theBlock.getResource().getResourceSpec();
        RsrcPushImpl thePush = theBlock.getPushImpl();
        PushID pushID = thePushID = thePush == null ? null : thePush.getPushID();
        if (!this.mRsrcCtx.isServer()) {
            VersionNumber theFwdVersion = this.mFwdDeletionMap.get(theResourceSpec, inVersion);
            if (theFwdVersion != null) {
                inVersion = theFwdVersion;
            }
            if (!thePush.includesNonVirtualResource(theResourceSpec, inVersion)) {
                return null;
            }
            ResourceID theBackResourceID = this.mRsrcCtx.getResourceID(theResourceSpec, inVersion, thePushID);
            return this.getManifest(theBackResourceID, thePushID);
        }
        try {
            ResourceID theBackResourceID = this.mRsrcCtx.getResourceID(theResourceSpec, inVersion, thePushID);
            return this.getManifest(theBackResourceID, thePushID);
        }
        catch (ResourceNotLocalException e) {
            Resource theNextHighest = this.mRsrcCtx.getNextHighestVersion(theResourceSpec, inVersion);
            return this.getManifest(theNextHighest.getResourceID(), thePushID);
        }
    }

    public SizedStream getZippedStream(ResourceID inResourceID) throws ResourceException {
        this.validateAccess();
        if (!this.mIsMS) {
            throw new ResourceException("rsrc.msg0310");
        }
        RsrcManifest theManifest = this.getManifest(inResourceID, null);
        OutputStream theTmpOutputStream = this.createTmpOutputStream();
        ZipPacker theZipPacker = new ZipPacker(new ZipOutputStream(theTmpOutputStream));
        SegIter theIter = SegIter.makeIter(Key.sKey, theManifest);
        while (theIter.hasMoreSubfiles()) {
            SegEntry theSegEntry = theIter.getNextSubfile();
            InputStream theInputStream = null;
            if (theSegEntry.getType().equals(SubnodeType.FILE)) {
                theInputStream = theManifest.getInputStream(theSegEntry.getRelPathWFwdSlashes());
            }
            theZipPacker.packEntry(theSegEntry.getRelPathWFwdSlashes(), theSegEntry.getUncompressedFileSize(), theSegEntry.getTime(), theSegEntry.getType(), theInputStream);
        }
        theZipPacker.finish();
        return this.getTmpInputSizedStream(theTmpOutputStream);
    }

    private OutputStream createTmpOutputStream() throws ResourceException {
        TmpFileBlock theTmpFileBlock = new TmpFileBlock();
        this.mTmpFileBlocks.add(theTmpFileBlock);
        return theTmpFileBlock.mOutputStream;
    }

    private SizedStream getTmpInputSizedStream(OutputStream inOutputStream) throws ResourceException {
        Iterator theTmpFileBlockIter = this.mTmpFileBlocks.iterator();
        while (theTmpFileBlockIter.hasNext()) {
            TmpFileBlock theTmpFileBlock = (TmpFileBlock)theTmpFileBlockIter.next();
            SizedStream theSizedStream = theTmpFileBlock.redeem(inOutputStream);
            if (theSizedStream == null) continue;
            return theSizedStream;
        }
        throw new ResourceException("rsrc.msg0311");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceAccessBlock getResourceAccessBlock(Resource inResource, PushID inPushID, boolean inHonorDeleteLockMutex) throws ResourceException {
        ResourceAccessBlock theBlock = new ResourceAccessBlock(this, inResource, inPushID, inHonorDeleteLockMutex, this.mRsrcCtx);
        HashMap hashMap = this.mRsrcAccessBlocks;
        synchronized (hashMap) {
            this.mRsrcAccessBlocks.put(theBlock.getRsrcManifest(), theBlock);
        }
        return theBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceAccessBlock findResourceAccessBlock(RsrcManifest inManifest) throws ResourceException {
        ResourceAccessBlock theResult = null;
        HashMap hashMap = this.mRsrcAccessBlocks;
        synchronized (hashMap) {
            theResult = (ResourceAccessBlock)this.mRsrcAccessBlocks.get(inManifest);
        }
        if (theResult == null) {
            throw new ResourceException("rsrc.msg0422");
        }
        return theResult;
    }

    private class TmpFileBlock {
        File mFile;
        InputStream mInputStream;
        OutputStream mOutputStream;

        TmpFileBlock() throws ResourceException {
            try {
                this.mFile = File.createTempFile("tmp_", null);
                this.mOutputStream = new FileOutputStream(this.mFile);
                this.mInputStream = null;
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }

        SizedStream redeem(OutputStream inOutputStream) throws ResourceException {
            if (inOutputStream == null || this.mOutputStream != inOutputStream) {
                return null;
            }
            try {
                this.mOutputStream.close();
                this.mOutputStream = null;
                this.mInputStream = new FileInputStream(this.mFile);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            return new SizedStream(this.mFile.length(), this.mInputStream);
        }

        void dispose() {
            block4: {
                try {
                    if (this.mInputStream != null) {
                        this.mInputStream.close();
                    }
                    if (this.mOutputStream != null) {
                        this.mOutputStream.close();
                    }
                    this.mFile.delete();
                }
                catch (IOException e) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.TMP_CLEANUP_FAILED"), this);
                }
            }
        }
    }
}

