/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.util.logger.Logger;

public class ResourceAccessBlock
implements Messages {
    private RsrcManifest mManifest;
    private Resource mResource;
    private RsrcPushImpl mPushImpl;
    private ResourceSubsysImpl mRsrcCtx;
    private boolean mDisposed = false;

    public ResourceAccessBlock(ResourceAccessor inAccessor, Resource inResource, PushID inPushID, boolean inHonorDeleteLockMutex, ResourceSubsysImpl inCtx) throws ResourceException {
        this.mRsrcCtx = inCtx;
        this.mPushImpl = inPushID != null ? this.mRsrcCtx.getPush(inPushID) : null;
        this.mResource = inResource;
        this.mRsrcCtx.lockResource(this.mResource, inPushID, inHonorDeleteLockMutex);
        try {
            this.mManifest = new RsrcManifest(inAccessor, this.mResource);
        }
        catch (Exception e) {
            block4: {
                try {
                    this.mRsrcCtx.unlockResource(this.mResource);
                }
                catch (ResourceException ex) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.UNLOCK_FAILED", new Object[]{inResource}), ex, this);
                }
            }
            throw new ResourceException(e);
        }
    }

    public Resource getResource() {
        return this.mResource;
    }

    public RsrcPushImpl getPushImpl() {
        return this.mPushImpl;
    }

    public RsrcManifest getRsrcManifest() {
        return this.mManifest;
    }

    public void dispose() {
        block3: {
            if (this.mDisposed) {
                return;
            }
            this.mDisposed = true;
            try {
                this.mRsrcCtx.unlockResource(this.mResource);
            }
            catch (ResourceException e) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error(ROXMessageManager.messageAsString("rsrc.UNLOCK_FAILED", new Object[]{this.mResource}), this);
            }
        }
        this.mManifest.setInvalid();
    }
}

