/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.AggregateStream;
import com.raplix.rolloutexpress.resource.packageformat.Key;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;

public class RawClusterStream
extends AggregateStream
implements Messages {
    private SegIter mSegIter;
    private int mRemainingSegs;
    private SegEntry mNextSegEntry;
    private boolean mCompression;
    private RsrcManifest mRsrcManifest;

    RawClusterStream(RsrcManifest inRsrcManifest, String inRelPath) throws ResourceException, IOException {
        this.mRsrcManifest = inRsrcManifest;
        this.mSegIter = SegIter.makeIter(Key.sKey, inRsrcManifest);
        this.mSegIter.setRelPathAsNext(inRelPath);
        this.mNextSegEntry = this.mSegIter.getNextSegEntry();
        this.mRemainingSegs = this.mNextSegEntry.getClusterSize();
        this.mCompression = this.mNextSegEntry.getCompression();
        if (this.mNextSegEntry == null || this.mNextSegEntry.getClusterIdx() != 0) {
            MiscUtils.throwUPE(5072108L);
        }
    }

    InputStream getNextSubstream() throws IOException {
        if (--this.mRemainingSegs < 0) {
            return null;
        }
        SegEntry theSegEntry = this.mNextSegEntry;
        if (theSegEntry.getCompression() != this.mCompression) {
            throw new IOException(ROXMessageManager.messageAsString("rsrc.UNEXPECTED_COMPRESSION_SETTING"));
        }
        try {
            this.mNextSegEntry = this.mSegIter.getNextSegEntry();
            return this.mRsrcManifest.getRawSegStream(theSegEntry);
        }
        catch (ResourceException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Exception accessing segment", e, this);
            }
            throw new IOException(ROXMessageManager.messageAsString("rsrc.ERROR_ACCESSING_DATA", new Object[]{e.getTopLevelStackTrace()}));
        }
    }

    public boolean getCompression() {
        return this.mCompression;
    }
}

