/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.checkInJob.ResourceDescriptor;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceDescriptorEntry;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixPermOptions;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceMemixUtils;
import com.raplix.util.Security;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.platform.posix.Chown;
import com.raplix.util.platform.posix.Group;
import com.raplix.util.platform.posix.Passwd;
import com.raplix.util.platform.posix.Stat;
import com.raplix.util.string.StringUtil;
import java.io.File;

public class PosixPermissionFactory
extends PlatformPermissionFactory {
    public NodePerms createDefaultNodePerms() throws ResourceException {
        return new PosixNodePerms();
    }

    public NodePerms createNodePerms(File inFile, PermOptions inOptions) throws ResourceException {
        return this.createNodePerms(inFile, inOptions, false);
    }

    public PosixNodePerms createDescriptorNodePerms(File inFile, PermOptions inOptions) throws ResourceException {
        return (PosixNodePerms)this.createNodePerms(inFile, inOptions, false);
    }

    public NodePerms createNodePerms(File inFile, PermOptions inOptions, boolean inResolveLinks) throws ResourceException {
        if (inOptions.suppress()) {
            return null;
        }
        PosixPermOptions options = null;
        if (inOptions instanceof PosixPermOptions) {
            options = (PosixPermOptions)inOptions;
        }
        if (options != null && options.getOverride() != null) {
            return options.getOverride().duplicate();
        }
        try {
            Stat theStat = null;
            theStat = !inResolveLinks ? new Stat(inFile.getAbsolutePath()) : new Stat(inFile.getAbsoluteFile().getCanonicalFile().getAbsolutePath());
            long statBits = theStat.getMode();
            String ownerName = null;
            long ownerID = -1L;
            String groupName = null;
            long groupID = -1L;
            if (options != null && options.getIncludeOwners()) {
                Passwd thePasswd;
                try {
                    thePasswd = new Passwd(theStat.getUID());
                }
                catch (RuntimeException e) {
                    throw new ResourceException("rsrc.msg0486", (Throwable)e, new Object[]{inFile});
                }
                ownerName = thePasswd.getName();
                ownerID = thePasswd.getUID();
            }
            if (options != null && options.getIncludeGroups()) {
                Group theGroup;
                try {
                    theGroup = new Group(theStat.getGID());
                }
                catch (RuntimeException e) {
                    throw new ResourceException("rsrc.msg0487", (Throwable)e, new Object[]{inFile});
                }
                groupName = theGroup.getName();
                groupID = theGroup.getGID();
            }
            return new PosixNodePerms(statBits, ownerName, ownerID, groupName, groupID);
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    public static void overrideNodePerms(PosixNodePerms inNodePerms, String inEntryName, ResourceDescriptor rd) throws ResourceException {
        ResourceDescriptorEntry rde = rd.getEntry(inEntryName);
        ResourceDescriptorEntry defaultEntry = rd.getDefaultEntry();
        String rdeOwner = null;
        String rdeGroup = null;
        String rdePerms = null;
        String defaultOwner = null;
        String defaultGroup = null;
        String defaultPerms = null;
        if (rde != null) {
            rdeOwner = rde.getOwner();
            rdeGroup = rde.getGroup();
            rdePerms = rde.getPermissions();
        }
        if (defaultEntry != null) {
            defaultOwner = defaultEntry.getOwner();
            defaultGroup = defaultEntry.getGroup();
            defaultPerms = defaultEntry.getPermissions();
        }
        if (rdeOwner != null) {
            if (rdeOwner.equals(":NONE:")) {
                inNodePerms.setOwnerName(null);
            } else {
                inNodePerms.setOwnerName(rdeOwner);
            }
            inNodePerms.setOwnerID(-1L);
        } else if (defaultOwner != null) {
            if (defaultOwner.equals(":NONE:")) {
                inNodePerms.setOwnerName(null);
            } else {
                inNodePerms.setOwnerName(defaultOwner);
            }
            inNodePerms.setOwnerID(-1L);
        }
        if (rdeGroup != null) {
            if (rdeGroup.equals(":NONE:")) {
                inNodePerms.setGroupName(null);
            } else {
                inNodePerms.setGroupName(rdeGroup);
            }
            inNodePerms.setGroupID(-1L);
        } else if (defaultGroup != null) {
            if (defaultGroup.equals(":NONE:")) {
                inNodePerms.setGroupName(null);
            } else {
                inNodePerms.setGroupName(defaultGroup);
            }
            inNodePerms.setGroupID(-1L);
        }
        if (rdePerms != null) {
            if (rdePerms.equals(":NONE:")) {
                inNodePerms.setPermBits(-1L);
            } else {
                try {
                    long perms = Long.parseLong(rdePerms, 8);
                    inNodePerms.setPermBits(perms);
                }
                catch (NumberFormatException e) {
                    throw new ResourceException("rsrc.descriptor.PERMISSIONS_FORMAT_ERROR", new Object[]{rdePerms, inEntryName});
                }
            }
        } else if (defaultPerms != null) {
            if (defaultPerms.equals(":NONE:")) {
                inNodePerms.setPermBits(-1L);
            } else {
                try {
                    long perms = Long.parseLong(defaultPerms, 8);
                    inNodePerms.setPermBits(perms);
                }
                catch (NumberFormatException e) {
                    throw new ResourceException("rsrc.descriptor.PERMISSIONS_FORMAT_ERROR_DEFAULT", new Object[]{defaultPerms});
                }
            }
        }
    }

    public NodePerms createPreflightNodePerms(File inFile, SessionCommand inCommand, PermOptions inOptions) throws ResourceException {
        PosixNodePerms perms;
        if (inOptions != null && inOptions instanceof PosixPermOptions && (perms = ((PosixPermOptions)inOptions).getOverride()) != null) {
            return perms.duplicate();
        }
        try {
            perms = new PosixNodePerms();
            ResourceMemixUtils.readPosixPerms(inCommand, inFile, perms);
            return perms;
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    public PermOptions createOverrideOptions(NodePerms inOverridePerms) {
        if (!(inOverridePerms instanceof PosixNodePerms)) {
            return super.createOverrideOptions(inOverridePerms);
        }
        return new PosixPermOptions((PosixNodePerms)inOverridePerms);
    }

    public void applyPerms(NodePerms inPerms, File inFile) throws ResourceException {
        this.applyPerms(inPerms, inFile, false);
    }

    public void applyPerms(NodePerms inPerms, File inFile, boolean inResolveLinks) throws ResourceException {
        if (!(inPerms instanceof PosixNodePerms)) {
            return;
        }
        PosixNodePerms perms = (PosixNodePerms)inPerms;
        long theNewOwnerID = -1L;
        if (perms.getOwnerName() != null) {
            theNewOwnerID = this.verifyOwner(perms.getOwnerName());
        }
        long theNewGroupID = -1L;
        if (perms.getGroupName() != null) {
            theNewGroupID = this.verifyGroup(perms.getGroupName());
        }
        PosixNodePerms theExistingPerms = (PosixNodePerms)this.createNodePerms(inFile, new PosixPermOptions(true, true), inResolveLinks);
        if (!perms.isNoPerms() && perms.getPermBits() != theExistingPerms.getPermBits()) {
            try {
                if (inResolveLinks || !ResourceFileUtils.getSubnodeType(inFile).equals(SubnodeType.SYMLINK)) {
                    RecursiveChmod.change(inFile.getAbsolutePath(), perms.getPermBits(), false);
                }
            }
            catch (RuntimeException e) {
                throw new ResourceException("rsrc.msg0365", new Object[]{inFile.getAbsolutePath(), e.getMessage()});
            }
        }
        if (theNewOwnerID != -1L || theNewGroupID != -1L) {
            try {
                if (inResolveLinks) {
                    Chown.changeFile(inFile.getAbsolutePath(), theNewOwnerID, theNewGroupID);
                } else {
                    Chown.changeLink(inFile.getAbsolutePath(), theNewOwnerID, theNewGroupID);
                }
            }
            catch (RuntimeException e) {
                throw new ResourceException("rsrc.msg0366", new Object[]{inFile.getAbsolutePath(), e.getMessage()});
            }
        }
    }

    public void applyPermsPreflight(NodePerms inPerms, File inFile, SessionCommand inCommand) throws ResourceException {
        if (!(inPerms instanceof PosixNodePerms)) {
            return;
        }
        PosixNodePerms perms = (PosixNodePerms)inPerms;
        long theNewOwnerID = -1L;
        if (perms.getOwnerName() != null) {
            theNewOwnerID = this.verifyOwner(perms.getOwnerName());
        }
        long theNewGroupID = -1L;
        if (perms.getGroupName() != null) {
            theNewGroupID = this.verifyGroup(perms.getGroupName());
        }
        PosixNodePerms theExistingPerms = (PosixNodePerms)this.createPreflightNodePerms(inFile, inCommand, new PosixPermOptions(false, false));
        if (!perms.isNoPerms() && perms.getPermBits() != theExistingPerms.getPermBits()) {
            ResourceMemixUtils.chmod(inCommand, inFile, perms.getPermBits());
        }
        if (theNewOwnerID != -1L) {
            ResourceMemixUtils.chown(inCommand, inFile, perms.getOwnerName());
        }
        if (theNewGroupID != -1L) {
            ResourceMemixUtils.chgrp(inCommand, inFile, perms.getGroupName());
        }
    }

    private long verifyOwner(String userName) throws ResourceException {
        if (!StringUtil.isEmpty(userName)) {
            if (!Security.isUserValid(userName)) {
                throw new ResourceException("rsrc.msg0343", new Object[]{userName});
            }
            if (Security.isProcessOwnerSameAsUser(userName)) {
                return -1L;
            }
            if (!Security.isRootOrHasSetuidPrivileges()) {
                throw new ResourceException("rsrc.msg0342");
            }
        }
        try {
            return new Passwd(userName).getUID();
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0363", new Object[]{userName});
        }
    }

    private long verifyGroup(String groupName) throws ResourceException {
        if (groupName != null) {
            try {
                return new Group(groupName).getGID();
            }
            catch (Exception e) {
                throw new ResourceException("rsrc.msg0364", new Object[]{groupName});
            }
        }
        return -1L;
    }

    static PermOptions staticGetDefaultOptions() {
        return new PosixPermOptions(true, true);
    }

    public PermOptions getDefaultOptions() {
        return PosixPermissionFactory.staticGetDefaultOptions();
    }

    static PermOptions staticGetDefaultSysCompOptions() {
        return new PosixPermOptions(false, false);
    }

    public PermOptions getDefaultSysCompOptions() {
        return PosixPermissionFactory.staticGetDefaultSysCompOptions();
    }
}

