/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;

public class PosixNodePerms
extends NodePerms {
    static final long serialVersionUID = 613624602785419939L;
    public static final long NO_USER_ID_SET = -1L;
    public static final long NO_GROUP_ID_SET = -1L;
    private long mStatBits;
    private String mOwnerName;
    private long mOwnerID;
    private String mGroupName;
    private long mGroupID;

    public static long getPermsMask() {
        return 4095L;
    }

    PosixNodePerms() {
    }

    public PosixNodePerms(long inStatBits, String inOwnerName, long inOwnerID, String inGroupName, long inGroupID) {
        this.mStatBits = inStatBits;
        this.mOwnerName = inOwnerName;
        this.mOwnerID = inOwnerID;
        this.mGroupName = inGroupName;
        this.mGroupID = inGroupID;
    }

    public boolean equals(Object inOther) {
        if (inOther == null || !(inOther instanceof PosixNodePerms)) {
            return false;
        }
        PosixNodePerms theOtherPerms = (PosixNodePerms)inOther;
        if (theOtherPerms.getPermBits() != this.getPermBits()) {
            return false;
        }
        if (theOtherPerms.mOwnerName == null != (this.mOwnerName == null)) {
            return false;
        }
        if (theOtherPerms.mGroupName == null != (this.mGroupName == null)) {
            return false;
        }
        if (this.mOwnerName != null && !this.mOwnerName.equals(theOtherPerms.mOwnerName)) {
            return false;
        }
        return this.mGroupName == null || this.mGroupName.equals(theOtherPerms.mGroupName);
    }

    public String toString() {
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("[PermBits=0x");
        theBuffer.append(Long.toHexString(this.getPermBits()));
        theBuffer.append(", Owner=");
        theBuffer.append(this.mOwnerName);
        theBuffer.append(", OwnerID=");
        theBuffer.append(this.mOwnerID);
        theBuffer.append(", Group=");
        theBuffer.append(this.mGroupName);
        theBuffer.append(", GroupID=");
        theBuffer.append(this.mGroupID);
        theBuffer.append("]");
        return theBuffer.toString();
    }

    public long getPermBits() {
        return this.mStatBits & PosixNodePerms.getPermsMask();
    }

    public void setPermBits(long inPerms) {
        this.mStatBits = inPerms;
    }

    public String getOwnerName() {
        return this.mOwnerName;
    }

    public void setOwnerName(String inOwner) {
        this.mOwnerName = inOwner;
    }

    public void setOwnerID(long inOwnerID) {
        this.mOwnerID = inOwnerID;
    }

    public long getOwnerID() {
        return this.mOwnerID;
    }

    public String getGroupName() {
        return this.mGroupName;
    }

    public void setGroupName(String inGroup) {
        this.mGroupName = inGroup;
    }

    public void setGroupID(long inGroupID) {
        this.mGroupID = inGroupID;
    }

    public long getGroupID() {
        return this.mGroupID;
    }

    public NodePerms duplicate() {
        PosixNodePerms theDuplicate = new PosixNodePerms();
        theDuplicate.mStatBits = this.mStatBits;
        theDuplicate.mOwnerName = this.mOwnerName;
        theDuplicate.mOwnerID = this.mOwnerID;
        theDuplicate.mGroupName = this.mGroupName;
        theDuplicate.mGroupID = this.mGroupID;
        return theDuplicate;
    }

    public void integrateValidFields(NodePerms inOther) throws ResourceException {
        if (!(inOther instanceof PosixNodePerms)) {
            return;
        }
        PosixNodePerms thePosixOther = (PosixNodePerms)inOther;
        if (thePosixOther.mStatBits != -1L) {
            this.mStatBits = thePosixOther.mStatBits;
        }
        if (thePosixOther.mGroupName != null) {
            this.mGroupName = thePosixOther.mGroupName;
        }
        if (thePosixOther.mOwnerName != null) {
            this.mOwnerName = thePosixOther.mOwnerName;
        }
    }

    public boolean isNoPerms() {
        return this.mStatBits == -1L;
    }
}

