/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.WindowsPermissionFactory;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.File;

public abstract class PlatformPermissionFactory {
    private static final PlatformPermissionFactory sInstance = PlatformUtil.isPOSIX() ? new PosixPermissionFactory() : new WindowsPermissionFactory();

    public abstract NodePerms createDefaultNodePerms() throws ResourceException;

    public abstract NodePerms createNodePerms(File var1, PermOptions var2) throws ResourceException;

    public abstract PosixNodePerms createDescriptorNodePerms(File var1, PermOptions var2) throws ResourceException;

    public abstract NodePerms createPreflightNodePerms(File var1, SessionCommand var2, PermOptions var3) throws ResourceException;

    public abstract void applyPerms(NodePerms var1, File var2) throws ResourceException;

    public abstract void applyPermsPreflight(NodePerms var1, File var2, SessionCommand var3) throws ResourceException;

    public PermOptions getDefaultOptions() {
        return PermOptions.makeSuppress();
    }

    public PermOptions getDefaultSysCompOptions() {
        return PermOptions.makeSuppress();
    }

    public static PermOptions getDefaultOptionsForHostID(HostID inHostID) throws ResourceException {
        boolean isWindows;
        try {
            isWindows = SystemPluginConstants.getInstance().ALL_WIN_ID.contains(inHostID);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
        catch (RPCException e) {
            throw new ResourceException(e);
        }
        if (isWindows) {
            return WindowsPermissionFactory.staticGetDefaultOptions();
        }
        return PosixPermissionFactory.staticGetDefaultOptions();
    }

    public PermOptions createOverrideOptions(NodePerms inOverridePerms) {
        return PermOptions.makeSuppress();
    }

    public static PlatformPermissionFactory getInstance() {
        return sInstance;
    }
}

