/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.diffdeploy.DeployLogger;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.packageformat.Externalizer;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceMemixUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.util.memix.commands.SessionCommand;
import java.io.File;
import java.io.InputStream;

public class MemixExternalizer
extends Externalizer {
    private SessionCommand mMemixSession;

    public MemixExternalizer(ResourceID inResourceID, PushID inPushID, ResourceSubsysImpl inRsrcSysCtx, DeployMode inDeployMode, File inDstLocation, SessionCommand inMemixSession, DeployLogger inDeployLogger) throws ResourceException {
        super(inResourceID, inPushID, inRsrcSysCtx, inDstLocation, inDeployMode, null, inDeployLogger);
        this.mMemixSession = inMemixSession;
    }

    public boolean doesRealContent() {
        return false;
    }

    public void createPath(File inPath) throws ResourceIOException {
        ResourceMemixUtils.ensureDirExists(this.mMemixSession, inPath);
    }

    public boolean pathExists(File inPath) throws ResourceException {
        boolean doesPathExist = ResourceMemixUtils.nodeExists(this.mMemixSession, inPath);
        if (doesPathExist && !ResourceMemixUtils.isAccessibleDirectory(this.mMemixSession, inPath)) {
            throw new ResourceException("rsrc.msg0244", new Object[]{inPath});
        }
        return doesPathExist;
    }

    public boolean nodeIsExistingFile(File inNode) throws ResourceException {
        return SubnodeType.FILE.equals(ResourceMemixUtils.getSubnodeType(this.mMemixSession, inNode));
    }

    public SubnodeType getNodeType(File inNode) throws ResourceException {
        return ResourceMemixUtils.getSubnodeType(this.mMemixSession, inNode);
    }

    public long getNodeSize(File inNode) throws ResourceException {
        return ResourceMemixUtils.getNodeSize(this.mMemixSession, inNode);
    }

    public boolean nodeIsExistingDir(File inNode) throws ResourceException {
        return SubnodeType.DIRECTORY.equals(ResourceMemixUtils.getSubnodeType(this.mMemixSession, inNode));
    }

    public String[] listFileNames(File inDir) throws ResourceException {
        if (!this.nodeIsExistingDir(inDir)) {
            return null;
        }
        return ResourceMemixUtils.listFiles(this.mMemixSession, inDir);
    }

    public void removeNode(File inNode) throws ResourceException {
        ResourceMemixUtils.removeNode(this.mMemixSession, inNode);
    }

    public void createLink(File inLinkFile, String inLinkTarget, long inTime) throws ResourceException {
        ResourceMemixUtils.createFile(this.mMemixSession, inLinkFile, SubnodeType.SYMLINK, 0L, inTime);
    }

    public void createFile(File inSubFile, long inSize, long inTime, InputStream inInputStream) throws ResourceException {
        ResourceMemixUtils.createFile(this.mMemixSession, inSubFile, SubnodeType.FILE, inSize, inTime);
    }
}

