/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class HierarchyTraverser {
    private File mHierarchyRoot;

    public abstract void processFileOrDir(File var1, String var2) throws ResourceException;

    public void begin() throws IOException, ResourceException {
    }

    public void finish() throws IOException, ResourceException {
    }

    public HierarchyTraverser(File inHierarchyRoot) {
        this.mHierarchyRoot = inHierarchyRoot.getAbsoluteFile();
    }

    public File getHierarchyRoot() {
        return this.mHierarchyRoot;
    }

    public static String getRootName(File inRoot) {
        return inRoot.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverse() throws FileNotFoundException, IOException, ResourceException {
        this.begin();
        try {
            this.traverse(this.mHierarchyRoot, HierarchyTraverser.getRootName(this.mHierarchyRoot) + (this.mHierarchyRoot.isDirectory() ? File.separator : ""));
        }
        finally {
            this.finish();
        }
    }

    private void traverse(File inDirOrFile, String inRelPath) throws FileNotFoundException, IOException, ResourceException {
        File[] theFiles;
        if (ResourceFileUtils.getSubnodeType(inDirOrFile).equals(SubnodeType.SYMLINK)) {
            throw new ResourceException("rsrc.msg0457", new Object[]{inDirOrFile});
        }
        this.processFileOrDir(inDirOrFile, inRelPath);
        if (inDirOrFile.isDirectory() && (theFiles = inDirOrFile.listFiles()) != null) {
            for (int i = 0; i < theFiles.length; ++i) {
                File theSubFile = theFiles[i];
                this.traverse(theSubFile, inRelPath + theSubFile.getName() + (theSubFile.isDirectory() ? File.separator : ""));
            }
        }
    }
}

