/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.diffdeploy.DeployLogger;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.packageformat.Externalizer;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import java.io.File;
import java.io.InputStream;

public class FileSystemExternalizer
extends Externalizer {
    public FileSystemExternalizer(ResourceID inResourceID, PushID inPushID, ResourceSubsysImpl inRsrcSysCtx, DeployMode inRsrcDeployMode, File inDstLocation, VersionNumber inPrevVersion, DeployLogger inDeployLogger) throws ResourceException {
        super(inResourceID, inPushID, inRsrcSysCtx, inDstLocation, inRsrcDeployMode, inPrevVersion, inDeployLogger);
    }

    public boolean nodeIsExistingFile(File inNode) throws ResourceException {
        return SubnodeType.FILE.equals(ResourceFileUtils.getSubnodeType(inNode));
    }

    public boolean nodeIsExistingDir(File inNode) throws ResourceException {
        return SubnodeType.DIRECTORY.equals(ResourceFileUtils.getSubnodeType(inNode));
    }

    public SubnodeType getNodeType(File inNode) throws ResourceException {
        return ResourceFileUtils.getSubnodeType(inNode);
    }

    public long getNodeSize(File inNode) throws ResourceException {
        SubnodeType theType = this.getNodeType(inNode);
        if (!SubnodeType.FILE.equals(theType)) {
            return 0L;
        }
        return inNode.length();
    }

    public String[] listFileNames(File inDir) throws ResourceException {
        if (!this.nodeIsExistingDir(inDir)) {
            return null;
        }
        return inDir.list();
    }

    public void removeNode(File inNode) throws ResourceException {
        ResourceFileUtils.deleteDirectory(inNode);
    }

    public void createLink(File inLinkFile, String inLinkTarget, long inTime) throws ResourceException {
        ResourceFileUtils.createLink(inLinkFile, inLinkTarget);
    }

    public boolean doesRealContent() {
        return true;
    }

    public boolean pathExists(File inPath) throws ResourceException {
        boolean doesPathExist = inPath.exists();
        if (doesPathExist && !inPath.isDirectory()) {
            throw new ResourceException("rsrc.msg0243", new Object[]{inPath});
        }
        return doesPathExist;
    }

    public void createPath(File inPath) throws ResourceIOException {
        inPath.mkdirs();
        if (!inPath.exists() || !inPath.isDirectory()) {
            throw new ResourceIOException("rsrc.msg0341", new Object[]{inPath.getAbsolutePath()});
        }
    }

    public void createFile(File inSubFile, long inSize, long inTime, InputStream inInputStream) throws ResourceException {
        ResourceFileUtils.writeStreamToFile(inSubFile, inTime, inInputStream);
    }
}

