/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.diffdeploy.DeployLogger;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.packageformat.DictionaryIter;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.InputStream;

abstract class Externalizer
extends ResourceParser {
    private final File mDstLocation;
    private final DeployMode mDeployMode;
    private final RsrcPushImpl mPush;
    private String mFirstRoot = null;
    private VersionNumber mPrevRsrcVersion;
    private DeployLogger mDeployLogger;

    public abstract void removeNode(File var1) throws ResourceException;

    public abstract void createLink(File var1, String var2, long var3) throws ResourceException;

    public abstract boolean nodeIsExistingFile(File var1) throws ResourceException;

    public abstract boolean nodeIsExistingDir(File var1) throws ResourceException;

    public abstract SubnodeType getNodeType(File var1) throws ResourceException;

    public abstract long getNodeSize(File var1) throws ResourceException;

    public abstract String[] listFileNames(File var1) throws ResourceException;

    public abstract void createFile(File var1, long var2, long var4, InputStream var6) throws ResourceException;

    public abstract boolean pathExists(File var1) throws ResourceException;

    public abstract void createPath(File var1) throws ResourceIOException;

    public Externalizer(ResourceID inResourceID, PushID inPushID, ResourceSubsysImpl inRsrcSysCtx, File inDstLocation, DeployMode inDeployMode, VersionNumber inPrevResourceVersion, DeployLogger inDeployLogger) throws ResourceException {
        super(inResourceID, inPushID, inRsrcSysCtx);
        this.mDstLocation = inDstLocation.getAbsoluteFile();
        if (inDeployMode == null) {
            throw new NullPointerException();
        }
        this.mDeployMode = inDeployMode;
        this.mPrevRsrcVersion = inPrevResourceVersion;
        this.mPush = inPushID != null ? inRsrcSysCtx.getRsrcPushImpl(inPushID) : null;
        this.mDeployLogger = inDeployLogger;
    }

    public File getDstLocation() {
        return this.mDstLocation;
    }

    public DeployMode getDeployMode() {
        return this.mDeployMode;
    }

    public RsrcPushImpl getPush() {
        return this.mPush;
    }

    public void beginParse() throws ResourceException {
        Resource theResource = this.getResourceSubsysImpl().getResource(this.getResourceID(), this.getPushID());
        if (this.mPrevRsrcVersion != null) {
            if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual")) {
                this.mDeployLogger.logDiffDeployment(theResource.getName(), theResource.getVersionNumber(), this.mDstLocation, this.mDeployMode, this.mPrevRsrcVersion);
            }
        } else if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual")) {
            this.mDeployLogger.logNonDiffDeployment(theResource.getName(), theResource.getVersionNumber(), this.mDstLocation, this.mDeployMode);
        }
        this.makeDirs(this.mDstLocation.getAbsoluteFile().getParentFile(), true);
        if (this.mDeployMode.equals(DeployMode.REPLACE)) {
            if (this.mPrevRsrcVersion == null) {
                SubnodeType theType = this.getNodeType(this.getDstLocation());
                if (theType != null) {
                    if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.deletes")) {
                        this.mDeployLogger.logTopLevelNonDiffReplaceDeletion(this.getDstLocation(), this.getNodeType(this.getDstLocation()));
                    }
                    this.removeNode(this.getDstLocation());
                }
            } else {
                new ResourceAccessor(this.getResourceSubsysImpl(), this.getFwdDeletionMap()){

                    public Object innerAccess() throws ResourceException {
                        RsrcManifest theManifest = this.getManifest(Externalizer.this.getResourceID(), Externalizer.this.getPushID());
                        ResourceEntryIterator theIter = theManifest.getEntryIterator();
                        new DictionaryIter(this, Externalizer.this.mDstLocation, "root", false, theIter){
                            String mNextRsrcListing;
                            private final /* synthetic */ ResourceEntryIterator val$theIter;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$theIter = val$theIter;
                                super(x0, x1, x2);
                                this.mNextRsrcListing = this.getNextRsrcListing();
                            }

                            private String getNextRsrcListing() throws ResourceException {
                                if (!this.val$theIter.hasNext()) {
                                    return null;
                                }
                                ResourceEntry theEntry = this.val$theIter.next();
                                return Externalizer.access$200(1.access$100(this.this$1), new File(Externalizer.access$000(1.access$100(this.this$1)), ResourceParser.stripRoot(theEntry.getRelPathWFwdSlashes())).getAbsolutePath());
                            }

                            public void process(String inRelPath, File inFile, SubnodeType inSubnodeType) throws ResourceException {
                                if (this.mNextRsrcListing == null) {
                                    Externalizer.access$300(1.access$100(this.this$1), inFile);
                                } else {
                                    String thePreparedFileName = Externalizer.access$200(1.access$100(this.this$1), inFile.getAbsolutePath());
                                    int theCompare = RsrcManifest.compare(this.mNextRsrcListing, thePreparedFileName);
                                    if (theCompare < 0) {
                                        do {
                                            this.mNextRsrcListing = this.getNextRsrcListing();
                                            if (this.mNextRsrcListing != null) continue;
                                            Externalizer.access$300(1.access$100(this.this$1), inFile);
                                            return;
                                        } while ((theCompare = RsrcManifest.compare(this.mNextRsrcListing, thePreparedFileName)) < 0);
                                        if (theCompare > 0) {
                                            Externalizer.access$300(1.access$100(this.this$1), inFile);
                                        }
                                    } else if (theCompare != 0) {
                                        Externalizer.access$300(1.access$100(this.this$1), inFile);
                                    }
                                }
                            }
                        }.exec();
                        return null;
                    }

                    static /* synthetic */ Externalizer access$100(1 x0) {
                        return x0.Externalizer.this;
                    }
                }.access();
            }
        }
    }

    private void logAndDeleteNonListedNode(File inFile) throws ResourceException {
        if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.deletes")) {
            this.mDeployLogger.logDeletionOfNonListedNode(inFile, this.getNodeType(inFile));
        }
        this.removeNode(inFile);
    }

    private String prepareFileName(String inFileName) {
        String theResult = inFileName.replace('\\', '/');
        while (theResult.endsWith("/")) {
            theResult = theResult.substring(0, theResult.length() - 1);
        }
        return theResult;
    }

    public boolean processEntry(ResourceEntry inResEntry, int inEntryIdx, InputStream inInputStream) throws ResourceException {
        String theRelPath = ResourceStringUtils.toNativePath(inResEntry.getRelPathWFwdSlashes());
        if (this.mFirstRoot == null) {
            int theIdx = ResourceStringUtils.getSeparatorIdx(theRelPath, 0);
            this.mFirstRoot = theIdx == -1 ? theRelPath : theRelPath.substring(0, theIdx);
        }
        if (!theRelPath.startsWith(this.mFirstRoot)) {
            throw new ResourceException("rsrc.msg0269");
        }
        if ((theRelPath = theRelPath.substring(this.mFirstRoot.length(), theRelPath.length())).length() != 0 && !theRelPath.startsWith(File.separator)) {
            throw new ResourceException("rsrc.msg0270");
        }
        String theDstFileString = this.mDstLocation.getAbsolutePath() + theRelPath;
        theDstFileString = ResourceStringUtils.toNativePath(theDstFileString);
        File theSubFile = new File(theDstFileString);
        this.makeDirs(theSubFile.getParentFile(), false);
        SubnodeType theExistingSubnodeType = this.getNodeType(theSubFile);
        if (inResEntry.getType().equals(SubnodeType.DIRECTORY)) {
            if (!SubnodeType.DIRECTORY.equals(theExistingSubnodeType)) {
                if (theExistingSubnodeType != null) {
                    if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.deletes")) {
                        this.mDeployLogger.logDeletionOfNonDirToBeReplacedByDir(theSubFile, theExistingSubnodeType);
                    }
                    this.removeNode(theSubFile);
                }
                if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.creates")) {
                    this.mDeployLogger.logCreation(theSubFile, SubnodeType.DIRECTORY);
                }
                this.makeDirs(theSubFile, false);
            }
        } else if (inResEntry.getType().equals(SubnodeType.FILE)) {
            if (inInputStream == null) {
                if (theExistingSubnodeType != null) {
                    if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.optimizations")) {
                        if (SubnodeType.FILE.equals(theExistingSubnodeType)) {
                            long theExistingNodeSize = this.getNodeSize(theSubFile);
                            if (inResEntry.getSize() != theExistingNodeSize) {
                                this.mDeployLogger.logOptimizedFileOfDiffSize(theSubFile, theExistingNodeSize, inResEntry.getSize());
                            } else {
                                this.mDeployLogger.logOptimizedNodeOfSameSize(theSubFile, theExistingSubnodeType);
                            }
                        } else {
                            this.mDeployLogger.logOptimizedNodeWithDiffFilesystemNodeType(theSubFile, theExistingSubnodeType, inResEntry.getType());
                        }
                    }
                } else if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.optimizations")) {
                    this.mDeployLogger.logOptimizedNodeWithNoFilesystemNode(theSubFile, inResEntry.getType());
                }
            } else {
                if (theExistingSubnodeType != null) {
                    if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.deletes")) {
                        this.mDeployLogger.logDeletionOfNodeToBeReplacedByNonDir(theSubFile, theExistingSubnodeType);
                    }
                    this.removeNode(theSubFile);
                }
                if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.creates")) {
                    this.mDeployLogger.logCreation(theSubFile, SubnodeType.FILE);
                }
                this.createFile(theSubFile, inResEntry.getSize(), inResEntry.getTime(), inInputStream);
            }
        } else if (inResEntry.getType().equals(SubnodeType.SYMLINK)) {
            if (theExistingSubnodeType != null) {
                if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.deletes")) {
                    this.mDeployLogger.logDeletionOfNodeToBeReplacedByNonDir(theSubFile, theExistingSubnodeType);
                }
                this.removeNode(theSubFile);
            }
            if (Logger.isInfoEnabled("com.sun.n1.sps.resource.deploy.filechanges.actual.creates")) {
                this.mDeployLogger.logCreation(theSubFile, SubnodeType.SYMLINK);
            }
            this.createLink(theSubFile, inResEntry.getLinkTarget(), inResEntry.getTime());
        } else {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    private void makeDirs(File inPath, boolean inIsEnclosing) throws ResourceException {
        if (inPath == null) {
            return;
        }
        if (!this.pathExists(inPath)) {
            this.makeDirs(inPath.getAbsoluteFile().getParentFile(), inIsEnclosing);
            this.createPath(inPath);
            if (this.mPush != null && inIsEnclosing) {
                this.mPush.afterEnclosingDirCreations(this.getResourceID(), this.mDstLocation, inPath);
            }
        }
    }

    static /* synthetic */ String access$200(Externalizer x0, String x1) {
        return x0.prepareFileName(x1);
    }

    static /* synthetic */ void access$300(Externalizer x0, File x1) throws ResourceException {
        x0.logAndDeleteNonListedNode(x1);
    }
}

