/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class DictionaryIter {
    private File mTopLevelFile;
    private String mTopLevelPath;
    private boolean mResolveLinks;
    private SubnodeType mTopLevelSubnodeType;

    public abstract void process(String var1, File var2, SubnodeType var3) throws ResourceException;

    public DictionaryIter(File inTopLevel, String inRootPath, boolean inResolveLinks) {
        this.mResolveLinks = inResolveLinks;
        this.mTopLevelFile = inTopLevel;
        this.mTopLevelSubnodeType = this.getSubnodeType(this.mTopLevelFile);
        this.mTopLevelPath = inRootPath == null ? "" : inRootPath;
        this.mTopLevelPath = this.mTopLevelPath.replace('\\', '/');
        while (ResourceStringUtils.endsInSeparator(this.mTopLevelPath)) {
            this.mTopLevelPath = this.mTopLevelPath.substring(0, this.mTopLevelPath.length() - 1);
        }
        if (SubnodeType.DIRECTORY.equals(this.mTopLevelSubnodeType)) {
            this.mTopLevelPath = this.mTopLevelPath + "/";
        }
    }

    public void exec() throws ResourceException {
        this.processNodes(this.mTopLevelFile, this.mTopLevelPath, this.mTopLevelSubnodeType);
    }

    private SubnodeType getSubnodeType(File inFile) {
        String theLinkTarget;
        if (!this.mResolveLinks && (theLinkTarget = ResourceFileUtils.getLinkTarget(inFile)) != null) {
            return SubnodeType.SYMLINK;
        }
        if (!inFile.exists()) {
            return null;
        }
        if (inFile.isDirectory()) {
            return SubnodeType.DIRECTORY;
        }
        if (inFile.isFile()) {
            return SubnodeType.FILE;
        }
        return null;
    }

    private void processNodes(File inFile, String inRelPath, SubnodeType inSubnodeType) throws ResourceException {
        if (inRelPath.indexOf(92) != -1) {
            MiscUtils.throwUPE(1340486L);
        }
        if (SubnodeType.SYMLINK.equals(inSubnodeType)) {
            this.process(inRelPath, inFile, SubnodeType.SYMLINK);
            return;
        }
        if (!inFile.exists()) {
            return;
        }
        if (SubnodeType.DIRECTORY.equals(inSubnodeType)) {
            if (!inRelPath.endsWith("/")) {
                MiscUtils.throwUPE(0x147447L);
            }
            TreeMap<String, File> theTreeMap = new TreeMap<String, File>(new Comparator(){

                public int compare(Object inA, Object inB) {
                    return RsrcManifest.compare((String)inA, (String)inB);
                }
            });
            theTreeMap.put(inRelPath, inFile);
            File[] theSubFiles = inFile.listFiles();
            if (theSubFiles != null) {
                for (int i = 0; i < theSubFiles.length; ++i) {
                    File theSubFile = theSubFiles[i];
                    SubnodeType theSubnodeType = this.getSubnodeType(theSubFile);
                    String theRelPath = inRelPath + theSubFile.getName();
                    if (SubnodeType.DIRECTORY.equals(theSubnodeType)) {
                        theRelPath = theRelPath + "/";
                    }
                    theTreeMap.put(theRelPath, theSubFile);
                }
            }
            Iterator theIter = theTreeMap.entrySet().iterator();
            while (theIter.hasNext()) {
                Map.Entry theEntry = theIter.next();
                String theKey = (String)theEntry.getKey();
                File theFile = (File)theEntry.getValue();
                if (theKey.equals(inRelPath)) {
                    this.process(inRelPath, inFile, inSubnodeType);
                    continue;
                }
                this.processNodes(theFile, theKey, this.getSubnodeType(theFile));
            }
        } else {
            this.process(inRelPath, inFile, inSubnodeType);
        }
    }
}

