/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.packageformat;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import java.io.IOException;
import java.io.InputStream;

public abstract class AggregateStream
extends InputStream
implements Messages {
    private InputStream mCurSubstream;
    private boolean mClosed = false;
    private boolean mInited = false;

    abstract InputStream getNextSubstream() throws IOException;

    private void init() throws IOException {
        if (this.mInited) {
            return;
        }
        this.mInited = true;
        this.mCurSubstream = this.getNextSubstream();
        if (this.mCurSubstream == null) {
            throw new IOException(ROXMessageManager.messageAsString("rsrc.EXPECTED_MORE_DATA"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        AggregateStream aggregateStream = this;
        synchronized (aggregateStream) {
            this.init();
            if (this.mCurSubstream == null) {
                return -1;
            }
            int theNumRead = this.mCurSubstream.read(b, off, len);
            while (theNumRead == -1) {
                this.mCurSubstream.close();
                this.mCurSubstream = this.getNextSubstream();
                if (this.mCurSubstream == null) {
                    return -1;
                }
                theNumRead = this.mCurSubstream.read(b, off, len);
            }
            return theNumRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        AggregateStream aggregateStream = this;
        synchronized (aggregateStream) {
            this.init();
            if (this.mCurSubstream == null) {
                return -1;
            }
            int theValueRead = this.mCurSubstream.read();
            while (theValueRead == -1) {
                this.mCurSubstream.close();
                this.mCurSubstream = this.getNextSubstream();
                if (this.mCurSubstream == null) {
                    return -1;
                }
                theValueRead = this.mCurSubstream.read();
            }
            return theValueRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        AggregateStream aggregateStream = this;
        synchronized (aggregateStream) {
            this.init();
            if (this.mClosed || this.mCurSubstream == null) {
                return 0;
            }
            return this.mCurSubstream.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        AggregateStream aggregateStream = this;
        synchronized (aggregateStream) {
            if (!this.mClosed) {
                this.mClosed = true;
                if (this.mCurSubstream != null) {
                    this.mCurSubstream.close();
                    this.mCurSubstream = null;
                }
            }
        }
    }
}

