/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.multipipe;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;

public class StreamInSegment
extends InputStream
implements Messages {
    private long mNumBytesRemaining;
    private InputStream mParentStream;
    private int mParentCloseBehavior;

    public StreamInSegment(InputStream inParentStream, long inNumBytes, int inParentCloseBehavior) {
        this.mParentStream = inParentStream;
        this.mNumBytesRemaining = inNumBytes;
        this.mParentCloseBehavior = inParentCloseBehavior;
    }

    public StreamInSegment(InputStream inParentStream, long inNumBytes) {
        this(inParentStream, inNumBytes, 1);
    }

    public int available() throws IOException {
        int theNumAvailable = this.mParentStream.available();
        if ((long)theNumAvailable > this.mNumBytesRemaining) {
            return (int)this.mNumBytesRemaining;
        }
        return theNumAvailable;
    }

    public int read() throws IOException {
        if (this.mNumBytesRemaining <= 0L) {
            return -1;
        }
        int theReadInt = this.mParentStream.read();
        if (theReadInt != -1) {
            --this.mNumBytesRemaining;
        }
        return theReadInt;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int theNumRead;
        if (this.mNumBytesRemaining <= 0L) {
            return -1;
        }
        if ((long)len > this.mNumBytesRemaining) {
            len = (int)this.mNumBytesRemaining;
        }
        if ((theNumRead = this.mParentStream.read(b, off, len)) > 0) {
            this.mNumBytesRemaining -= (long)theNumRead;
        }
        return theNumRead;
    }

    public void close() throws IOException {
        if (this.mParentCloseBehavior == 0) {
            this.mParentStream.close();
        } else if (this.mParentCloseBehavior == 1) {
            if (this.mNumBytesRemaining > 0L) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.INCOMPLETE_STREAM"), this);
                }
                byte[] theBytes = new byte[8192];
                while (this.mNumBytesRemaining > 0L) {
                    int theNumRead;
                    int theNumToRead = theBytes.length;
                    if ((long)theNumToRead > this.mNumBytesRemaining) {
                        theNumToRead = (int)this.mNumBytesRemaining;
                    }
                    if ((theNumRead = this.mParentStream.read(theBytes, 0, theNumToRead)) < 0) {
                        throw new IOException(ROXMessageManager.messageAsString("rsrc.CANNOT_RESCUE_STREAM"));
                    }
                    this.mNumBytesRemaining -= (long)theNumRead;
                }
            }
        } else if (this.mParentCloseBehavior == 2) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Leaving parent stream open and unconsumed...", this);
            }
        } else {
            throw new IllegalStateException("Unexpected value");
        }
        super.close();
    }

    public static interface ParentStreamHandling {
        public static final int CLOSE = 0;
        public static final int LEAVE_OPEN_AND_FORCE_CONSUMPTION = 1;
        public static final int LEAVE_OPEN = 2;
    }
}

