/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.multipipe;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.multipipe.Header;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class MultiSendPipe
implements Messages {
    private String mName;
    private InputStreamQueue mInputStreamQueue;
    private SequenceInputStream mSeqInStream;
    private SendThread mSendThread;
    private FileMover mFileMover;
    private boolean mFinished = false;
    private static final InputStream mPerpetuallyEmptyStream = new InputStream(){

        public int read() {
            return -1;
        }
    };

    public MultiSendPipe(String inName, FileMover inFileMover, RoxAddress inReceiverAddress, DataId inReceiverDataId) throws ResourceException {
        this.mName = inName;
        this.mFileMover = inFileMover;
        this.createNewSequenceStream();
        this.mSendThread = new SendThread(inName, inReceiverAddress, inReceiverDataId);
        this.mSendThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewSequenceStream() throws ResourceException {
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            this.mInputStreamQueue = new InputStreamQueue();
            this.mInputStreamQueue.add(mPerpetuallyEmptyStream);
            this.mSeqInStream = new SequenceInputStream(this.mInputStreamQueue);
            this.notifyAll();
        }
    }

    private byte[] serializeObject(Serializable inObject) throws ResourceException {
        ByteArrayOutputStream theByteOutStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream theObjectOutStream = new ObjectOutputStream(theByteOutStream);
            theObjectOutStream.writeObject(inObject);
            theObjectOutStream.close();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        return theByteOutStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Serializable inObject) throws ResourceException {
        byte[] theSerializedBytes = this.serializeObject(inObject);
        ByteArrayInputStream theSerializedStream = new ByteArrayInputStream(theSerializedBytes);
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                throw new ResourceException("rsrc.DATA_CONNECTION_CLOSED");
            }
            this.prepareStreamQueue();
            this.mInputStreamQueue.add(Header.encode((byte)1, theSerializedBytes.length));
            this.mInputStreamQueue.add(theSerializedStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(InputStream inStream, long inNumBytes) throws ResourceException {
        if (inNumBytes <= 0L) {
            block7: {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    if (!Logger.isWarnEnabled(this)) break block7;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.EXCEPTION_CLOSING_STREAM"), e, this);
                }
            }
            return;
        }
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                throw new ResourceException("rsrc.DATA_CONNECTION_CLOSED");
            }
            this.prepareStreamQueue();
            this.mInputStreamQueue.add(Header.encode((byte)0, inNumBytes));
            this.mInputStreamQueue.add(inStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws ResourceException {
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                throw new ResourceException("rsrc.DATA_CONNECTION_CLOSED");
            }
            this.mInputStreamQueue.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareStreamQueue() throws ResourceException {
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                MiscUtils.throwUPE(1340485L);
            }
            if (!this.mInputStreamQueue.isAcceptingStreams()) {
                this.createNewSequenceStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws ResourceException {
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                return;
            }
            try {
                this.prepareStreamQueue();
                this.mInputStreamQueue.add(Header.encode((byte)2, 0L));
                this.mInputStreamQueue.detach();
            }
            finally {
                this.mFinished = true;
                this.notifyAll();
            }
            while (!this.mInputStreamQueue.handedOffLastByte()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ResourceException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishErr(CommandException inException) throws ResourceException {
        byte[] theSerializedBytes = this.serializeObject(inException);
        ByteArrayInputStream theSerializedStream = new ByteArrayInputStream(theSerializedBytes);
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mFinished) {
                return;
            }
            try {
                this.prepareStreamQueue();
                this.mInputStreamQueue.add(Header.encode((byte)3, theSerializedBytes.length));
                this.mInputStreamQueue.add(theSerializedStream);
                this.mInputStreamQueue.detach();
            }
            finally {
                this.mFinished = true;
                this.notifyAll();
            }
            long theStart = System.currentTimeMillis();
            while (System.currentTimeMillis() - theStart < 5000L && !this.mInputStreamQueue.handedOffLastByte()) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException e) {
                    throw new ResourceException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ResourceException {
        MultiSendPipe multiSendPipe = this;
        synchronized (multiSendPipe) {
            if (this.mInputStreamQueue != null) {
                this.mInputStreamQueue.detach();
            }
            this.mFinished = true;
            this.notifyAll();
        }
        try {
            this.mSeqInStream.close();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public String toString() {
        return this.mName;
    }

    private class SendThread
    extends SafeThread {
        private RoxAddress mReceiverAddress;
        private String mName;
        private DataId mReceiverDataId;

        public SendThread(String inName, RoxAddress inReceiverAddress, DataId inReceiverDataId) {
            super("MultiSendPipe.SendThread" + (inName != null ? ": " + inName : ""));
            this.mName = inName;
            this.mReceiverAddress = inReceiverAddress;
            this.mReceiverDataId = inReceiverDataId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block18: {
                SequenceInputStream thePrevSeqInStream = null;
                while (true) {
                    boolean doNextDataPush = false;
                    MultiSendPipe multiSendPipe = MultiSendPipe.this;
                    synchronized (multiSendPipe) {
                        if (MultiSendPipe.this.mSeqInStream != thePrevSeqInStream) {
                            doNextDataPush = true;
                        } else {
                            if (MultiSendPipe.this.mFinished && MultiSendPipe.this.mInputStreamQueue.handedOffLastByte()) {
                                break;
                            }
                            MultiSendPipe.this.wait();
                        }
                    }
                    if (!doNextDataPush) continue;
                    thePrevSeqInStream = MultiSendPipe.this.mSeqInStream;
                    this.mReceiverDataId = FileMover.getNextFTMNonDifferentDataId(this.mReceiverDataId);
                    MultiSendPipe.this.mFileMover.pushDataId(MultiSendPipe.this.mSeqInStream, this.mReceiverDataId, this.mReceiverAddress);
                }
                Object var6_6 = null;
                try {
                    MultiSendPipe.this.close();
                }
                catch (ResourceException e1) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.warn(ROXMessageManager.messageAsString("rsrc.SEND_PIPE_CLOSE_ERROR"), e1, this);
                    }
                    break block18;
                }
                {
                    catch (Throwable t) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(ROXMessageManager.messageAsString("rsrc.MSP_RUN_EXC_CAUGHT"), t, this);
                        }
                        Object var6_7 = null;
                        try {
                            MultiSendPipe.this.close();
                        }
                        catch (ResourceException e1) {
                            if (Logger.isErrorEnabled(this)) {
                                Logger.warn(ROXMessageManager.messageAsString("rsrc.SEND_PIPE_CLOSE_ERROR"), e1, this);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var6_8 = null;
                        try {
                            MultiSendPipe.this.close();
                        }
                        catch (ResourceException e1) {
                            if (!Logger.isErrorEnabled(this)) break block19;
                            Logger.warn(ROXMessageManager.messageAsString("rsrc.SEND_PIPE_CLOSE_ERROR"), e1, this);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private class InputStreamQueue
    implements Enumeration {
        private boolean mDetached = false;
        private boolean mLastByteRead = false;
        private LinkedList mStreamList = new LinkedList();

        private InputStreamQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(InputStream inStream) throws ResourceException {
            MultiSendPipe multiSendPipe = MultiSendPipe.this;
            synchronized (multiSendPipe) {
                if (this.mDetached) {
                    if (this.mStreamList.size() == 0) {
                        MiscUtils.throwUPE(0x147444L);
                    }
                    this.mStreamList.add(this.mStreamList.size() - 1, inStream);
                    MultiSendPipe.this.notifyAll();
                } else {
                    this.mStreamList.add(inStream);
                    MultiSendPipe.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            MultiSendPipe multiSendPipe = MultiSendPipe.this;
            synchronized (multiSendPipe) {
                if (!this.mDetached) {
                    this.mDetached = true;
                    MultiSendPipe.this.notifyAll();
                    this.mStreamList.add(new InputStream(this){
                        private final /* synthetic */ InputStreamQueue this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public int read() {
                            MultiSendPipe multiSendPipe = InputStreamQueue.access$000(this.this$1);
                            synchronized (multiSendPipe) {
                                InputStreamQueue.access$102(this.this$1, true);
                                InputStreamQueue.access$000(this.this$1).notifyAll();
                            }
                            return -1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void close() throws IOException {
                            MultiSendPipe multiSendPipe = InputStreamQueue.access$000(this.this$1);
                            synchronized (multiSendPipe) {
                                InputStreamQueue.access$102(this.this$1, true);
                                InputStreamQueue.access$000(this.this$1).notifyAll();
                            }
                            super.close();
                        }
                    });
                    MultiSendPipe.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreElements() {
            MultiSendPipe multiSendPipe = MultiSendPipe.this;
            synchronized (multiSendPipe) {
                return this.mStreamList.size() != 0 || !this.mDetached;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            MultiSendPipe multiSendPipe = MultiSendPipe.this;
            synchronized (multiSendPipe) {
                block7: {
                    if (this.mStreamList.size() == 0) {
                        if (this.mDetached) {
                            throw new NoSuchElementException();
                        }
                        try {
                            MultiSendPipe.this.wait();
                        }
                        catch (InterruptedException e) {
                            if (!Logger.isWarnEnabled(this)) break block7;
                            Logger.warn("Wait interrupted, ignoring...", this);
                        }
                    }
                }
                return this.mStreamList.size() != 0 ? this.mStreamList.remove(0) : mPerpetuallyEmptyStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAcceptingStreams() {
            MultiSendPipe multiSendPipe = MultiSendPipe.this;
            synchronized (multiSendPipe) {
                return !this.mDetached || this.mStreamList.size() != 0;
            }
        }

        public boolean handedOffLastByte() {
            return this.mLastByteRead;
        }

        static /* synthetic */ MultiSendPipe access$000(InputStreamQueue x0) {
            return x0.MultiSendPipe.this;
        }

        static /* synthetic */ boolean access$102(InputStreamQueue x0, boolean x1) {
            x0.mLastByteRead = x1;
            return x0.mLastByteRead;
        }
    }
}

