/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.multipipe;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.multipipe.Header;
import com.raplix.rolloutexpress.resource.multipipe.StreamInSegment;
import com.raplix.rolloutexpress.resource.util.Sequence;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class MultiReceivePipe
implements Messages {
    private String mName;
    private FileMover mFileMover;
    private DataId mDataId;
    private PipedInputStream mPipeInStream;
    private PipedOutputStream mPipeOutStream;
    private ReadThread mReadThread;
    private volatile boolean mReadingData = true;
    private Throwable mThrowable = null;
    private boolean mReallyClosePipes = false;

    public void processStream(InputStream inStream, long inNumBytes) throws ResourceException {
        throw new ResourceException("rsrc.msg0400");
    }

    public void processObject(Object inObject) throws ResourceException {
        throw new ResourceException("rsrc.msg0401");
    }

    public boolean isReadingData() {
        return this.mReadingData;
    }

    public Throwable isErr() {
        return this.mThrowable;
    }

    public abstract void senderFinished() throws ResourceException;

    public abstract void senderFinishedWithError(CommandException var1) throws ResourceException;

    public MultiReceivePipe(String inName, FileMover inFileMover) throws ResourceException {
        this.mName = inName;
        this.mFileMover = inFileMover;
        try {
            this.mPipeInStream = new PipedInputStream();
            this.mPipeOutStream = new PipedOutputStream(this.mPipeInStream){

                public void close() throws IOException {
                    if (MultiReceivePipe.this.mReallyClosePipes) {
                        super.close();
                    }
                }
            };
            this.mDataId = this.mFileMover.registerOutStream(this.mPipeOutStream);
            this.mReadThread = new ReadThread(inName);
            this.mReadThread.start();
        }
        catch (IOException e) {
            this.close();
            throw new ResourceException(e);
        }
    }

    public DataId getDataId() {
        return this.mDataId;
    }

    public void close() {
        block6: {
            this.mReadingData = false;
            this.mReallyClosePipes = true;
            if (this.mReadThread != null) {
                this.mReadThread.closeThread();
                this.mReadThread = null;
            }
            if (this.mDataId != null) {
                this.mFileMover.removeOutStream(this.mDataId);
                this.mDataId = null;
            }
            try {
                if (this.mPipeOutStream != null) {
                    this.mPipeOutStream.close();
                    this.mPipeOutStream = null;
                }
                if (this.mPipeInStream != null) {
                    this.mPipeInStream.close();
                    this.mPipeInStream = null;
                }
            }
            catch (Throwable t) {
                if (!Logger.isWarnEnabled(this)) break block6;
                Logger.warn(ROXMessageManager.messageAsString("rsrc.PROBLEM_CLOSING_STREAM"), t, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStream(Header inHeader) {
        block9: {
            try {
                long theLength = inHeader.getLength();
                StreamInSegment theStreamSegment = new StreamInSegment(this.mPipeInStream, theLength, 2);
                try {
                    this.processStream(theStreamSegment, theLength);
                }
                finally {
                    try {
                        theStreamSegment.close();
                    }
                    catch (IOException e) {
                        throw new ResourceException(e);
                    }
                }
            }
            catch (ResourceException e) {
                this.mReadingData = false;
                this.mThrowable = e;
                if (!Logger.isWarnEnabled(this)) break block9;
                Logger.warn(ROXMessageManager.messageAsString("rsrc.PIPED_STREAM_ERROR"), e, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleObject(Header inHeader) {
        boolean didSucceed;
        block8: {
            didSucceed = false;
            try {
                StreamInSegment theStreamSegment = new StreamInSegment(this.mPipeInStream, inHeader.getLength(), 2);
                boolean processObjSuccess = false;
                try {
                    ObjectInputStream theObjectInStream = new ObjectInputStream(theStreamSegment);
                    Object theObject = theObjectInStream.readObject();
                    try {
                        this.processObject(theObject);
                        processObjSuccess = true;
                    }
                    catch (ClassCastException e) {
                        throw new ResourceException(e);
                    }
                }
                catch (Throwable throwable) {
                    new Sequence(processObjSuccess, theStreamSegment){
                        private final /* synthetic */ StreamInSegment val$theStreamSegment;
                        {
                            this.val$theStreamSegment = val$theStreamSegment;
                            super(x0);
                        }

                        public void populateActions() throws Exception {
                            this.addAction(new Sequence.Action(this){
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void exec() throws IOException {
                                    2.access$800(this.this$1).close();
                                }
                            });
                        }

                        static /* synthetic */ StreamInSegment access$800(2 x0) {
                            return x0.val$theStreamSegment;
                        }
                    }.exec();
                    throw throwable;
                }
                new /* invalid duplicate definition of identical inner class */.exec();
                didSucceed = true;
            }
            catch (Throwable t) {
                this.mThrowable = t;
                if (!Logger.isWarnEnabled(this)) break block8;
                Logger.warn(ROXMessageManager.messageAsString("rsrc.PIPED_OBJECT_ERROR"), t, this);
            }
        }
        if (!didSucceed) {
            this.mReadingData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinished() {
        try {
            this.senderFinished();
        }
        catch (ResourceException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("rsrc.SENDERFINISHED_ERROR"), e, this);
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleFinishedErr(Header inHeader) {
        block23: {
            CommandException theSenderCommandException = null;
            StreamInSegment theStreamSegment = new StreamInSegment(this.mPipeInStream, inHeader.getLength(), 2);
            ObjectInputStream theObjectInStream = null;
            try {
                theObjectInStream = new ObjectInputStream(theStreamSegment);
                theSenderCommandException = (CommandException)theObjectInStream.readObject();
            }
            finally {
                if (theObjectInStream != null) {
                    theObjectInStream.close();
                }
            }
            Object var7_7 = null;
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("rsrc.OTHER_SIDE_ERROR"), theSenderCommandException, this);
            }
            try {
                this.senderFinishedWithError(theSenderCommandException);
            }
            catch (ResourceException ignored) {
            }
            finally {
                this.close();
            }
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(ROXMessageManager.messageAsString("rsrc.OTHER_SIDE_ERROR"), theSenderCommandException, this);
                    }
                    try {
                        this.senderFinishedWithError(theSenderCommandException);
                    }
                    catch (ResourceException ignored) {
                        break block23;
                    }
                    finally {
                        this.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ROXMessageManager.messageAsString("rsrc.OTHER_SIDE_ERROR"), theSenderCommandException, this);
                }
                try {
                    this.senderFinishedWithError(theSenderCommandException);
                }
                catch (ResourceException ignored) {
                }
                finally {
                    this.close();
                }
                throw throwable;
            }
        }
    }

    private class ReadThread
    extends SafeThread {
        public ReadThread(String inName) {
            super("MultiReceivePipe.ReadThread" + (inName != null ? ": " + inName : ""));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block11: while (MultiReceivePipe.this.mReadingData) {
                    Header theHeader = Header.decode(MultiReceivePipe.this.mPipeInStream);
                    switch (theHeader.getType()) {
                        case 0: {
                            MultiReceivePipe.this.handleStream(theHeader);
                            continue block11;
                        }
                        case 1: {
                            MultiReceivePipe.this.handleObject(theHeader);
                            continue block11;
                        }
                        case 2: {
                            MultiReceivePipe.this.handleFinished();
                            continue block11;
                        }
                        case 3: {
                            MultiReceivePipe.this.handleFinishedErr(theHeader);
                            continue block11;
                        }
                    }
                    if (!Logger.isWarnEnabled(this)) continue;
                    Logger.warn(ROXMessageManager.messageAsString("rsrc.UNKNOWN_TYPE", new Object[]{new Byte(theHeader.getType())}), this);
                }
                return;
            }
            catch (Throwable e) {
                MultiReceivePipe.this.mReadingData = false;
                MultiReceivePipe.this.mThrowable = e;
                if (!Logger.isErrorEnabled(this)) return;
                Logger.error(ROXMessageManager.messageAsString("rsrc.RUN_EXCEPTION_CAUGHT"), e, this);
                return;
            }
            finally {
                MultiReceivePipe.this.close();
            }
        }

        public void closeThread() {
            MultiReceivePipe.this.mReadingData = false;
        }
    }
}

