/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.multipipe;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Header {
    static final byte STREAM_TYPE = 0;
    static final byte OBJECT_TYPE = 1;
    static final byte SENDER_FINISHED = 2;
    static final byte SENDER_FINISHED_ERROR = 3;
    static final byte IGNORE = 4;
    private byte mType;
    private long mNumBytes;
    private static final byte[] HEADER_CHECK = new byte[]{42, 42, 42, 42};

    public Header(byte inType, long inNumBytes) {
        this.mType = inType;
        this.mNumBytes = inNumBytes;
    }

    public byte getType() {
        return this.mType;
    }

    public long getLength() {
        return this.mNumBytes;
    }

    private static int getHeaderByteLength() {
        return HEADER_CHECK.length + 1 + 10;
    }

    static InputStream encode(byte inType, long inNumBytes) {
        byte[] theBytes = new byte[Header.getHeaderByteLength()];
        System.arraycopy(HEADER_CHECK, 0, theBytes, 0, HEADER_CHECK.length);
        theBytes[Header.HEADER_CHECK.length] = inType;
        int theIdx = HEADER_CHECK.length + 1;
        long theLong = inNumBytes;
        long the7BitMask = 127L;
        for (int i = 0; i < 10; ++i) {
            theBytes[theIdx++] = (byte)(theLong & 0x7FL);
            theLong >>= 7;
        }
        return new ByteArrayInputStream(theBytes);
    }

    public static Header decode(InputStream inStream) throws ResourceException {
        int theTotalBytesRead;
        int theNumBytesRead;
        int theHeaderByteLength = Header.getHeaderByteLength();
        byte[] theHeaderBytes = new byte[theHeaderByteLength];
        for (theTotalBytesRead = 0; theTotalBytesRead < theHeaderByteLength; theTotalBytesRead += theNumBytesRead) {
            try {
                theNumBytesRead = inStream.read(theHeaderBytes, theTotalBytesRead, theHeaderByteLength - theTotalBytesRead);
                if (theNumBytesRead == -1) break;
                continue;
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        if (theTotalBytesRead < theHeaderByteLength) {
            throw new ResourceException("rsrc.msg0396");
        }
        for (int i = 0; i < HEADER_CHECK.length; ++i) {
            if (theHeaderBytes[i] == HEADER_CHECK[i]) continue;
            throw new ResourceException("rsrc.msg0397");
        }
        byte theType = theHeaderBytes[HEADER_CHECK.length];
        switch (theType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ResourceException("rsrc.msg0398");
            }
        }
        long theByteLength = 0L;
        int theIdx = HEADER_CHECK.length + 1;
        for (int i = 0; i < 10; ++i) {
            theByteLength |= (long)theHeaderBytes[theIdx++] << i * 7;
        }
        if (theByteLength < 0L) {
            throw new ResourceException("rsrc.msg0399");
        }
        return new Header(theType, theByteLength);
    }
}

