/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.diffdeploy;

import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledResourceQuery;

public class HostPathResource {
    public static ResourceID queryInstalledResource(HostID inHostID, String inHostPath) throws ResourceException {
        try {
            String path = inHostPath;
            MultiInstalledResourceQuery query = MultiInstalledResourceQuery.byInstallPath(inHostPath);
            query.setHostFilter(inHostID, TargetType.PHYSICAL);
            InstalledResource[] results = query.select();
            if (results.length > 0) {
                ResourceID resID = results[0].getResourceID();
                return resID;
            }
            return null;
        }
        catch (RPCException e) {
            throw new ResourceException(e);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
    }
}

