/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.diffdeploy;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.util.logger.Logger;
import java.io.File;

public class DeployLogger
implements Messages {
    private static final String CREATES = ".creates";
    private static final String DELETES = ".deletes";
    private static final String OPTIMIZATIONS = ".optimizations";
    public static final String sRootCategory = "com.sun.n1.sps.resource.deploy.filechanges.actual";
    public static final String sActualCreates = "com.sun.n1.sps.resource.deploy.filechanges.actual.creates";
    public static final String sActualDeletes = "com.sun.n1.sps.resource.deploy.filechanges.actual.deletes";
    public static final String sActualOptimizations = "com.sun.n1.sps.resource.deploy.filechanges.actual.optimizations";
    private static DeployLoggerFactory sDeployLoggerFactory;

    protected void outputHdr(String inMsgKey, Object[] inMsgParams) {
        if (Logger.isDebugEnabled(sRootCategory)) {
            Logger.debug(ROXMessageManager.messageAsString(inMsgKey, inMsgParams), sRootCategory);
        } else if (Logger.isInfoEnabled(sRootCategory)) {
            Logger.info(ROXMessageManager.messageAsString(inMsgKey, inMsgParams), sRootCategory);
        }
    }

    void output(String inCategory, String inNonVerboseMsgKey, String inVerboseMsgKey, Object[] inMsgParams) {
        if (Logger.isDebugEnabled(inCategory)) {
            this.emitDebug(inVerboseMsgKey, inMsgParams, inCategory);
        } else if (Logger.isInfoEnabled(inCategory)) {
            this.emitInfo(inNonVerboseMsgKey, inMsgParams, inCategory);
        }
    }

    protected void emitInfo(String inNonVerboseMsgKey, Object[] inMsgParams, String inProxyCategory) {
        Logger.info(ROXMessageManager.messageAsString(inNonVerboseMsgKey, inMsgParams), inProxyCategory);
    }

    protected void emitDebug(String inVerboseMsgKey, Object[] inMsgParams, String inProxyCategory) {
        Logger.debug(ROXMessageManager.messageAsString(inVerboseMsgKey, inMsgParams), inProxyCategory);
    }

    public void logNonDiffDeployment(String inRsrcName, VersionNumber inRsrcVers, File inPath, DeployMode inDeployMode) {
        Object[] theMsgParams = new Object[]{inRsrcName, inRsrcVers, inPath.getAbsoluteFile(), inDeployMode};
        this.outputHdr("rsrc.NON_DIFF_DEPLOY", theMsgParams);
    }

    public void logDiffDeployment(String inRsrcName, VersionNumber inRsrcVers, File inPath, DeployMode inDeployMode, VersionNumber inPrevVers) {
        Object[] theMsgParams = new Object[]{inRsrcName, inRsrcVers, inPath.getAbsoluteFile(), inDeployMode, inPrevVers};
        this.outputHdr("rsrc.DIFF_DEPLOY", theMsgParams);
    }

    public void logCreation(File inFile, SubnodeType inType) {
        this.output(sActualCreates, "rsrc.CREATING_FILE", "rsrc.CREATING_FILE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logTopLevelNonDiffReplaceDeletion(File inFile, SubnodeType inType) {
        this.output(sActualDeletes, "rsrc.DELETING_TOP_NODE", "rsrc.DELETING_TOP_NODE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logDeletionOfNonListedNode(File inFile, SubnodeType inType) {
        this.output(sActualDeletes, "rsrc.DELETING_NONLISTED_NODE", "rsrc.DELETING_NONLISTED_NODE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logDeletionOfNonDirToBeReplacedByDir(File inFile, SubnodeType inType) {
        this.output(sActualDeletes, "rsrc.DELETING_NONDIR_FOR_DIR", "rsrc.DELETING_NONDIR_FOR_DIR_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logDeletionOfNodeToBeReplacedByNonDir(File inFile, SubnodeType inType) {
        this.output(sActualDeletes, "rsrc.DELETING_NONDIR_FOR_NEW_FILE", "rsrc.DELETING_NONDIR_FOR_NEW_FILE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logOptimizedFileOfDiffSize(File inFile, long inFileSystemSize, long inResourceListingSize) {
        this.output(sActualOptimizations, "rsrc.OPTIMIZED_FILE_DIFFSIZED", "rsrc.OPTIMIZED_FILE_DIFFSIZED_VERBOSE", new Object[]{inFile.getAbsoluteFile(), "" + inFileSystemSize, "" + inResourceListingSize});
    }

    public void logOptimizedNodeOfSameSize(File inFile, SubnodeType inType) {
        this.output(sActualOptimizations, "rsrc.OPTIMIZED_SAME_TYPE_AND_SIZE", "rsrc.OPTIMIZED_SAME_TYPE_AND_SIZE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logOptimizedNodeWithNoFilesystemNode(File inFile, SubnodeType inType) {
        this.output(sActualOptimizations, "rsrc.OPTIMIZED_NO_NODE", "rsrc.OPTIMIZED_NO_NODE_VERBOSE", new Object[]{inType, inFile.getAbsoluteFile()});
    }

    public void logOptimizedNodeWithDiffFilesystemNodeType(File inFile, SubnodeType inFileSystemType, SubnodeType inRsrcListedType) {
        this.output(sActualOptimizations, "rsrc.OPTIMIZED_DIFF_TYPE", "rsrc.OPTIMIZED_DIFF_TYPE_VERBOSE", new Object[]{inFileSystemType, inFile.getAbsoluteFile(), inRsrcListedType});
    }

    public static DeployLogger makeActualDeployLogger() {
        if (sDeployLoggerFactory != null) {
            return sDeployLoggerFactory.makeDeployLogger();
        }
        return new DeployLogger();
    }

    public static void forTestOnly_SetDeployLoggerFactory(Object inKey, DeployLoggerFactory inDeployLoggerFactory) {
        TransPackageKeys.verifyResourceKey(inKey);
        sDeployLoggerFactory = inDeployLoggerFactory;
    }

    public static interface DeployLoggerFactory {
        public DeployLogger makeDeployLogger();
    }
}

