/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.compression;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Deflater;

public class SummedCompressionInputStream
extends InputStream {
    private InputStream mInputStream;
    private MessageDigest mPostMD5;
    private Deflater mDeflater;
    private boolean mInputFinished = false;
    private byte[] mBytesIn;
    private int mNumBytesIn;
    private byte[] mBytesOut;
    private int mNumBytesOut;
    private int mNextByteOut;
    private byte[] mDigest;
    private long mUncompressedLength = 0L;

    public SummedCompressionInputStream(InputStream inInputStream) throws ResourceException {
        if (inInputStream == null) {
            throw new NullPointerException();
        }
        this.mInputStream = inInputStream;
        try {
            this.mPostMD5 = MessageDigest.getInstance("MD5");
            if (this.mPostMD5 == null) {
                throw new ResourceException("rsrc.msg0394");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ResourceException(e);
        }
        this.mDeflater = new Deflater();
        this.mBytesIn = new byte[8192];
        this.mNumBytesIn = 0;
        this.mBytesOut = new byte[this.mBytesIn.length];
        this.mNumBytesOut = 0;
        this.mNextByteOut = 0;
    }

    public byte[] getDigest() throws ResourceException {
        if (!this.mInputFinished) {
            throw new ResourceException("rsrc.msg0395");
        }
        return this.mPostMD5.digest();
    }

    public long getUncompressedLength() throws ResourceException {
        if (!this.mInputFinished) {
            throw new ResourceException("rsrc.msg0421");
        }
        return this.mUncompressedLength;
    }

    private boolean moreBytesToRead() throws IOException {
        if (this.mNextByteOut < this.mNumBytesOut) {
            return true;
        }
        if (!this.mInputFinished && this.mDeflater.needsInput()) {
            this.mNumBytesIn = this.mInputStream.read(this.mBytesIn);
            if (this.mNumBytesIn == -1) {
                this.mInputFinished = true;
                this.mDeflater.finish();
            } else {
                this.mDeflater.setInput(this.mBytesIn, 0, this.mNumBytesIn);
                this.mUncompressedLength += (long)this.mNumBytesIn;
            }
        }
        this.mNumBytesOut = this.mDeflater.deflate(this.mBytesOut);
        if (this.mNumBytesOut > 0) {
            this.mPostMD5.update(this.mBytesOut, 0, this.mNumBytesOut);
        }
        this.mNextByteOut = 0;
        return !this.mInputFinished || this.mNumBytesOut != 0;
    }

    public int read() throws IOException {
        do {
            if (this.mNextByteOut >= this.mNumBytesOut) continue;
            return this.mBytesOut[this.mNextByteOut++];
        } while (this.moreBytesToRead());
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.moreBytesToRead()) {
            return -1;
        }
        int theNumReturned = this.available();
        if (theNumReturned > len) {
            theNumReturned = len;
        }
        System.arraycopy(this.mBytesOut, this.mNextByteOut, b, off, theNumReturned);
        this.mNextByteOut += theNumReturned;
        return theNumReturned;
    }

    public int available() throws IOException {
        return this.mNumBytesOut - this.mNextByteOut;
    }

    public void close() throws IOException {
        this.mInputStream.close();
        super.close();
    }
}

