/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DecompressionInputStream
extends InputStream {
    private InputStream mInputStream;
    private Inflater mInflater;
    private boolean mInputFinished = false;
    private byte[] mBytesIn;
    private int mNumBytesIn;
    private byte[] mBytesOut;
    private int mNumBytesOut;
    private int mNextByteOut;
    private byte[] mDigest;

    public DecompressionInputStream(InputStream inInputStream) {
        if (inInputStream == null) {
            throw new NullPointerException();
        }
        this.mInputStream = inInputStream;
        this.mInflater = new Inflater();
        this.mBytesIn = new byte[8192];
        this.mNumBytesIn = 0;
        this.mBytesOut = new byte[this.mBytesIn.length];
        this.mNumBytesOut = 0;
        this.mNextByteOut = 0;
    }

    private boolean moreBytesToRead() throws IOException {
        if (this.mNextByteOut < this.mNumBytesOut) {
            return true;
        }
        if (!this.mInputFinished && this.mInflater.needsInput()) {
            this.mNumBytesIn = this.mInputStream.read(this.mBytesIn);
            if (this.mNumBytesIn == -1) {
                this.mInputFinished = true;
                this.mInflater.finished();
            } else {
                this.mInflater.setInput(this.mBytesIn, 0, this.mNumBytesIn);
            }
        }
        this.mNextByteOut = 0;
        try {
            this.mNumBytesOut = this.mInflater.inflate(this.mBytesOut);
        }
        catch (DataFormatException e) {
            throw new IOException("DataFormatException: " + e.getMessage());
        }
        return !this.mInputFinished || this.mNumBytesOut != 0;
    }

    public int read() throws IOException {
        do {
            if (this.mNextByteOut >= this.mNumBytesOut) continue;
            return this.mBytesOut[this.mNextByteOut++];
        } while (this.moreBytesToRead());
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.moreBytesToRead()) {
            return -1;
        }
        int theNumReturned = this.available();
        if (theNumReturned > len) {
            theNumReturned = len;
        }
        System.arraycopy(this.mBytesOut, this.mNextByteOut, b, off, theNumReturned);
        this.mNextByteOut += theNumReturned;
        return theNumReturned;
    }

    public int available() throws IOException {
        return this.mNumBytesOut - this.mNextByteOut;
    }

    public void close() throws IOException {
        this.mInputStream.close();
        super.close();
    }
}

