/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobID;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobImpl;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.Key;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.RelPathInfo;
import com.raplix.rolloutexpress.resource.checkInJob.RemoteCheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.RemoteSideCheckInData;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.InProgress;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.multipipe.MultiReceivePipe;
import com.raplix.rolloutexpress.resource.multipipe.MultiSendPipe;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcPacker;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.resource.util.Sequence;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.InputStream;
import java.io.Serializable;

public class StandardCheckIn
extends CheckInJobImpl
implements Messages {
    static final String SERVER_DONE_STR = "SERVER_DONE_STR";
    private MultiReceivePipe mPackReceiver;
    private MultiSendPipe mPackSender;
    private boolean mReceivingDataToPack = true;
    private RemoteCheckInInterface mRemoteCheckInInterface;
    private Object mTableInsertionToken = new Object();
    private boolean mInserted = false;
    private VersionedSaveContext mVersionedSaveContext;
    private ResourceTypeAndOptions mResourceTypeAndOptions;
    private ResourceID mPreviousID;
    private CheckInMode mCheckInMode;
    private ResourceAccessor mResourceAccessor;
    private VersionNumber mPreviousVersion;
    private boolean mResolveLinks;
    private RsrcManifest mPrevRsrcManifest;
    private RsrcPacker mRsrcPacker;
    private boolean mScreenedAllData = false;
    private int mOutstandingStreamRequests = 0;
    private boolean mFromMSApp = false;

    StandardCheckIn(CheckInJobID inNewJobID, ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheckMode, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, RoxAddress inInitiatorAddress, ResourceSubsysImpl inRsrcCtx, UserID inUserID, boolean inResolveLinks, PluginID inPluginID, boolean inFromMSApp) throws ResourceException {
        super(inNewJobID, "StandardCheckIn", inInitiatorAddress, inRsrcCtx, inUserID);
        this.mResourceTypeAndOptions = inResourceTypeAndOptions;
        this.mVersionedSaveContext = inVersionedSaveContext;
        this.mResolveLinks = inResolveLinks;
        this.mFromMSApp = inFromMSApp;
        this.setUpJobRecord(inResourceTypeAndOptions.getHostID(), inResourceTypeAndOptions.getAbstractPath(), inResourceTypeAndOptions.getResourceType(), inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheckMode, inPlatform, inPluginID);
    }

    public void doSafeRun() throws ResourceException {
        this.resourceStart();
        this.resourceLoop();
        this.resourceFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postInsert() throws ResourceException {
        Object object = this.mTableInsertionToken;
        synchronized (object) {
            this.mInserted = true;
            this.mTableInsertionToken.notifyAll();
        }
    }

    public void checkWhetherDone() throws ResourceException {
        if (this.mScreenedAllData && this.mOutstandingStreamRequests == 0) {
            this.mPackSender.addObject((Serializable)((Object)SERVER_DONE_STR));
            this.mPackSender.finish();
            this.mReceivingDataToPack = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPhase1() throws ResourceException {
        block20: {
            block21: {
                Object object = this.mStatusTransition;
                synchronized (object) {
                    this.resourceTestFlow();
                    this.mCheckInJobMgr.enqueue(this);
                }
                while (!this.mCheckInJobMgr.isOkToStart(this)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new ResourceException(e);
                    }
                    this.resourceTestFlow();
                }
                RsrcInfo theMostRecent = this.mRsrcCtx.checkForMostRecentVersion(this.mResourceSpec);
                if (theMostRecent != null) {
                    this.mPreviousID = theMostRecent.getResourceID();
                    this.mPreviousVersion = theMostRecent.getVersionNumber();
                    this.verifyTypeCoherence(theMostRecent.getTypeName(), this.mResourceTypeAndOptions.getResourceType());
                }
                CheckInMode checkInMode = this.mCheckInMode = theMostRecent == null ? CheckInMode.REPLACE : this.mResourceTypeAndOptions.getCheckInMode();
                if (this.mCheckInMode == null) {
                    this.mCheckInMode = CheckInMode.REPLACE;
                }
                if (theMostRecent != null) {
                    this.mResourceAccessor = new ResourceAccessor(this.mRsrcCtx, null){

                        public Object innerAccess() {
                            return null;
                        }
                    };
                    this.mResourceAccessor.beginUse(Key.sKey);
                    this.mPrevRsrcManifest = this.mResourceAccessor.getManifest(this.mPreviousID, null);
                }
                RoxAddress theDataSrcAddress = this.resolveDataSrcAddress();
                this.mRemoteCheckInInterface = this.mFromMSApp ? this.mRsrcCtx.getLocalProxyCheckInInterface(theDataSrcAddress) : this.mRsrcCtx.getRemoteCheckInInterface(theDataSrcAddress);
                this.mRsrcPacker = new RsrcPacker(null, ResourceStringUtils.getURLFileName(this.mResourceTypeAndOptions.getAbstractPath()), this.mCheckInMode, this.mRedundancyCheckMode, this.mPrevRsrcManifest, this.mPreviousVersion);
                this.mPackReceiver = new MultiReceivePipe("SrvrStdCheckInReceiver " + this.getCheckInJobID(), this.mRsrcCtx.getFileMover()){

                    public void processObject(Object inObject) throws ResourceException {
                        if (!(StandardCheckIn.this.getStatus() instanceof InProgress)) {
                            throw new ResourceException("rsrc.msg0384");
                        }
                        if (inObject instanceof String) {
                            String theString = (String)inObject;
                            if ("CLIENT_COMPRESSION_DONE_STR_///".equals(theString)) {
                                StandardCheckIn.this.mScreenedAllData = true;
                                StandardCheckIn.this.checkWhetherDone();
                            } else {
                                StandardCheckIn.this.mRsrcPacker.syncDataToAddMode(theString);
                            }
                            return;
                        }
                        if (!(inObject instanceof RelPathInfo)) {
                            throw new IllegalStateException();
                        }
                        RelPathInfo theRelPathInfo = (RelPathInfo)inObject;
                        StandardCheckIn.this.mRsrcPacker.syncEntriesToAddMode(theRelPathInfo.mRelPath);
                        SegEntry theMatchingPrevRsrcSegEntry = null;
                        if (theRelPathInfo.mSubnodeType.equals(SubnodeType.FILE) && StandardCheckIn.this.mPrevRsrcManifest != null && !StandardCheckIn.this.mRedundancyCheckMode.equals(RedundancyCheckMode.NO_REDUNDANCY_CHECK)) {
                            theMatchingPrevRsrcSegEntry = StandardCheckIn.this.mPrevRsrcManifest.findBackrefableData((Object)Key.sKey, theRelPathInfo);
                        }
                        StandardCheckIn.this.mRsrcPacker.packEntryCluster(theRelPathInfo.mRelPath, theRelPathInfo.mUncompressedSize, theRelPathInfo.mSizePerCompressionSetting, theRelPathInfo.mTime, theRelPathInfo.mSubnodeType, theRelPathInfo.mPerms, theRelPathInfo.mLinkTarget, theRelPathInfo.mFileMd5PerCompressionSetting, theRelPathInfo.mCompressed, theMatchingPrevRsrcSegEntry);
                        if (theRelPathInfo.mSubnodeType.equals(SubnodeType.FILE) && theMatchingPrevRsrcSegEntry == null) {
                            ++StandardCheckIn.this.mOutstandingStreamRequests;
                            StandardCheckIn.this.mPackSender.addObject(theRelPathInfo);
                            StandardCheckIn.this.mPackSender.flush();
                        }
                    }

                    public void processStream(InputStream inStream, long inNumBytes) throws ResourceException {
                        StandardCheckIn.this.mRsrcPacker.packThenCloseDataStream(inStream, inNumBytes);
                        --StandardCheckIn.this.mOutstandingStreamRequests;
                        StandardCheckIn.this.checkWhetherDone();
                    }

                    public void senderFinished() {
                    }

                    public void senderFinishedWithError(CommandException inError) {
                        StandardCheckIn.this.handleError(inError);
                    }
                };
                boolean didSucceed = false;
                try {
                    RemoteSideCheckInData theRemoteData = null;
                    try {
                        theRemoteData = this.mRemoteCheckInInterface.spawnRemoteCheckIn(this.mResourceTypeAndOptions, this.getCheckInJobID(), this.mPackReceiver.getDataId(), theMostRecent == null ? RedundancyCheckMode.NO_REDUNDANCY_CHECK : this.mRedundancyCheckMode, this.mResolveLinks);
                    }
                    catch (RPCException e) {
                        throw new ResourceException(e);
                    }
                    if (theRemoteData.mHierarchical != this.mResourceTypeAndOptions.getTypeIsHierarchical()) {
                        throw new ResourceException("rsrc.msg0420");
                    }
                    this.mPackSender = new MultiSendPipe("SrvrCheckInSender " + this.getCheckInJobID(), this.mRsrcCtx.getFileMover(), theDataSrcAddress, theRemoteData.mReceiveDataId);
                    this.mRsrcPacker.setOSInfo(theRemoteData.mSourceOSIsPosix, theRemoteData.mSourceOSName);
                    didSucceed = true;
                    Object var7_8 = null;
                    if (didSucceed) break block20;
                    if (this.mPackReceiver != null) {
                        this.mPackReceiver.close();
                        this.mPackReceiver = null;
                    }
                    if (this.mPackSender == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (!didSucceed) {
                        if (this.mPackReceiver != null) {
                            this.mPackReceiver.close();
                            this.mPackReceiver = null;
                        }
                        if (this.mPackSender != null) {
                            this.mPackSender.close();
                            this.mPackSender = null;
                        }
                        if (this.mResourceAccessor != null) {
                            this.mResourceAccessor.endUse(Key.sKey);
                            this.mResourceAccessor = null;
                        }
                    }
                    throw throwable;
                }
                this.mPackSender.close();
                this.mPackSender = null;
            }
            if (this.mResourceAccessor != null) {
                this.mResourceAccessor.endUse(Key.sKey);
                this.mResourceAccessor = null;
            }
        }
        this.resourceTestFlow();
    }

    private RoxAddress resolveDataSrcAddress() throws ResourceException {
        RoxAddress theDataSrcAddress = this.mInitiatorAddress;
        if (this.mHostID != null) {
            boolean initiatorIsMS = false;
            try {
                AppInstance appInst = SingleAppInstanceQuery.byAddress(this.mInitiatorAddress, AppType.MS).select();
                initiatorIsMS = true;
            }
            catch (NoResultsFoundException e) {
            }
            catch (RPCException e) {
                throw new ResourceException("rsrc.msg0378", (Throwable)e);
            }
            catch (PersistenceManagerException e) {
                throw new ResourceException("rsrc.msg0378", (Throwable)e);
            }
            if (this.mHostID.equals(Host.MASTER_SERVER_ID) && (initiatorIsMS || this.mPluginID != null || this.mFromMSApp)) {
                theDataSrcAddress = RoxAddress.local;
            } else {
                try {
                    Host theHost = this.mHostID.getByIDQuery().select();
                    theDataSrcAddress = theHost.getRARoxAddress();
                }
                catch (HostDBException e) {
                    throw new ResourceException("rsrc.msg0378", (Throwable)e);
                }
                catch (PersistenceManagerException e) {
                    throw new ResourceException("rsrc.msg0379", (Throwable)e);
                }
                catch (RPCException e) {
                    throw new ResourceException("rsrc.msg0380", (Throwable)e);
                }
            }
        }
        return theDataSrcAddress;
    }

    void startPhase2() throws ResourceException {
        this.resourceTestFlow();
        new SafeThread("FinalRemoteCheckInGoAhead " + this.getCheckInJobID()){

            public void run() {
                try {
                    StandardCheckIn.this.mRemoteCheckInInterface.postServerInsert(StandardCheckIn.this.getCheckInJobID());
                }
                catch (Throwable t) {
                    StandardCheckIn.this.failed(t);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceStart() throws ResourceException {
        this.startPhase1();
        Object object = this.mTableInsertionToken;
        synchronized (object) {
            if (!this.mInserted) {
                try {
                    this.mTableInsertionToken.wait();
                }
                catch (InterruptedException e) {
                    throw new ResourceException(e);
                }
            }
        }
        this.startPhase2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resourceLoop() throws ResourceException {
        while (true) {
            this.resourceTestFlow();
            StandardCheckIn standardCheckIn = this;
            synchronized (standardCheckIn) {
                if (!this.mReceivingDataToPack || !this.mPackReceiver.isReadingData()) {
                    if (this.mPackReceiver.isErr() != null) {
                        MiscUtils.resourceThrow(this.mPackReceiver.isErr());
                    }
                    return;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new ResourceException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resourceFinish() throws ResourceException {
        final long theFinalTotalRsrcSize = this.mRsrcPacker.finish();
        boolean success = false;
        try {
            if (!new CheckInJobImpl.StateTransition(){

                CheckInStatus makeNewStatus() throws ResourceException {
                    RsrcInfo theRsrcInfo = StandardCheckIn.this.mRsrcCtx.finalizeCheckIn(StandardCheckIn.this.mRsrcPacker.getWorkspaceDir(), StandardCheckIn.this.mResourceTypeAndOptions, StandardCheckIn.this.mConfigurable, StandardCheckIn.this.mResourceSpec, StandardCheckIn.this.mVersionedSaveContext, StandardCheckIn.this.mPlatform, StandardCheckIn.this.mCategoryIDSet, StandardCheckIn.this.mPluginID, theFinalTotalRsrcSize);
                    return new Succeeded(System.currentTimeMillis(), theRsrcInfo);
                }
            }.attempt()) {
                this.mRsrcPacker.deleteDirSnuff();
            }
            success = true;
        }
        catch (Throwable e) {
            try {
                this.mRsrcPacker.deleteDirSnuff();
                MiscUtils.resourceThrow(e);
            }
            catch (Throwable throwable) {
                new Sequence(success){

                    public void populateActions() {
                        this.addAction(new Sequence.Action(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void exec() throws ResourceException {
                                if (StandardCheckIn.access$900(5.access$800(this.this$1)) != null) {
                                    StandardCheckIn.access$900(5.access$800(this.this$1)).endUse(Key.sKey);
                                    StandardCheckIn.access$902(5.access$800(this.this$1), null);
                                }
                            }
                        });
                    }

                    static /* synthetic */ StandardCheckIn access$800(5 x0) {
                        return x0.StandardCheckIn.this;
                    }
                }.exec();
                throw throwable;
            }
            new /* invalid duplicate definition of identical inner class */.exec();
        }
        new /* invalid duplicate definition of identical inner class */.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleError(final Throwable inError) {
        block16: {
            try {
                StandardCheckIn standardCheckIn = this;
                synchronized (standardCheckIn) {
                    this.mReceivingDataToPack = false;
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(ROXMessageManager.messageAsString("rsrc.ENTRY_PACKING_ERROR"), inError, this);
                    }
                    new CheckInJobImpl.StateTransition(){

                        CheckInStatus makeNewStatus() {
                            CommandException theCommandException = null;
                            theCommandException = inError instanceof CommandException ? (CommandException)inError : new ResourceException(inError);
                            return new Failed(System.currentTimeMillis(), theCommandException);
                        }
                    }.attemptAndSnuffErrs();
                    new SafeThread("AbortClientFromServer " + this.getCheckInJobID()){

                        public void run() {
                            try {
                                StandardCheckIn.this.mRemoteCheckInInterface.abortFromServer(StandardCheckIn.this.getCheckInJobID());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                    if (this.mPackReceiver != null) {
                        this.mPackReceiver.close();
                        this.mPackReceiver = null;
                    }
                    if (this.mPackSender != null) {
                        block14: {
                            try {
                                this.mPackSender.close();
                            }
                            catch (ResourceException e) {
                                if (!Logger.isErrorEnabled(this)) break block14;
                                Logger.error("Error closing send stream", e, this);
                            }
                        }
                        this.mPackSender = null;
                    }
                    if (this.mResourceAccessor != null) {
                        block15: {
                            try {
                                this.mResourceAccessor.endUse(Key.sKey);
                            }
                            catch (ResourceException e) {
                                if (!Logger.isErrorEnabled(this)) break block15;
                                Logger.error("Error from ResourceAccessor.endUse: ", e, this);
                            }
                        }
                        this.mResourceAccessor = null;
                    }
                }
                if (this.mRsrcPacker != null) {
                    this.mRsrcPacker.deleteDirSnuff();
                }
            }
            catch (Throwable t) {
                if (!Logger.isErrorEnabled(this)) break block16;
                Logger.error("Error while handling error", t, this);
            }
        }
    }

    static /* synthetic */ ResourceAccessor access$900(StandardCheckIn x0) {
        return x0.mResourceAccessor;
    }

    static /* synthetic */ ResourceAccessor access$902(StandardCheckIn x0, ResourceAccessor x1) {
        x0.mResourceAccessor = x1;
        return x0.mResourceAccessor;
    }
}

