/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import java.io.File;

public class ResourceTypeAndOptions
implements RPCSerializable {
    private String mResourceType;
    private String mAbstractPath;
    private String mOverrideFilePath;
    private CheckInMode mCheckInMode;
    private HostID mHostID;
    private PermOptions mPermOpts = PermOptions.makeSuppress();
    private boolean mTypeHasPermissions;
    private boolean mTypeIsHierarchical;
    private boolean mTypeIsConfigurable;

    public static ResourceTypeAndOptions makeCheckIn(String inResourceType, File inFileSysNode, HostID inHostID, PermOptions inPermOpts, CheckInMode inCheckInMode) throws ResourceException {
        if (inCheckInMode == null) {
            throw new NullPointerException();
        }
        if (!inResourceType.equals(RsrcInfo.getDirTypeName()) && !inResourceType.equals(RsrcInfo.getFileTypeName())) {
            throw new ResourceException("rsrc.msg0484" + inResourceType);
        }
        ResourceTypeAndOptions theResult = new ResourceTypeAndOptions(inResourceType, inHostID, inFileSysNode.getAbsoluteFile().getAbsolutePath());
        if (inPermOpts != null && theResult.mTypeHasPermissions) {
            theResult.mPermOpts = inPermOpts;
        }
        theResult.mCheckInMode = inCheckInMode;
        return theResult;
    }

    public static ResourceTypeAndOptions makeCheckIn(String inResourceType, String inAbstractPath, HostID inHostID, PermOptions inPermOpts, CheckInMode inCheckInMode) throws ResourceException {
        if (inAbstractPath == null) {
            throw new NullPointerException();
        }
        if (inResourceType == null) {
            throw new NullPointerException();
        }
        if (inCheckInMode == null) {
            throw new NullPointerException();
        }
        ResourceTypeAndOptions theResult = new ResourceTypeAndOptions(inResourceType, inHostID, inAbstractPath);
        if (inPermOpts != null && theResult.mTypeHasPermissions) {
            theResult.mPermOpts = inPermOpts;
        }
        theResult.mCheckInMode = inCheckInMode;
        return theResult;
    }

    public static ResourceTypeAndOptions makeDataBlockPostExport(String inResourceType, File inExportedFile, HostID inHostID, String inAbstractPath) throws ResourceException {
        if (inExportedFile == null) {
            throw new NullPointerException();
        }
        ResourceTypeAndOptions theResult = new ResourceTypeAndOptions(inResourceType, inHostID, inAbstractPath);
        theResult.mOverrideFilePath = inExportedFile.getAbsolutePath();
        return theResult;
    }

    public String toString() {
        return "Type=" + this.mResourceType + " Path=" + this.mAbstractPath + (this.mOverrideFilePath == null ? "" : " OverridePath=" + this.mOverrideFilePath) + " CheckInMode=" + this.mCheckInMode + (this.mHostID == null ? "" : " HostID=" + this.mHostID) + " PermOpts=" + this.mPermOpts + " typeHasPerms=" + this.mTypeHasPermissions + " typeIsHier=" + this.mTypeIsHierarchical + " typeIsCfgable=" + this.mTypeIsConfigurable;
    }

    private ResourceTypeAndOptions(String inResourceType, HostID inHostID, String inAbstractPath) throws ResourceException {
        if (inResourceType == null) {
            throw new NullPointerException();
        }
        this.mResourceType = inResourceType;
        this.mAbstractPath = inAbstractPath;
        this.mHostID = inHostID;
        this.mTypeHasPermissions = true;
        this.mTypeIsHierarchical = RsrcInfo.getDirTypeName().equals(inResourceType);
        this.mTypeIsConfigurable = !this.mTypeIsHierarchical;
    }

    public String getResourceType() {
        return this.mResourceType;
    }

    public String getAbstractPath() {
        return this.mAbstractPath;
    }

    public PermOptions getPermOpts() {
        return this.mPermOpts;
    }

    public boolean getTypeHasPermissions() {
        return this.mTypeHasPermissions;
    }

    public boolean getTypeIsHierarchical() {
        return this.mTypeIsHierarchical;
    }

    public boolean getTypeIsConfigurable() {
        return this.mTypeIsConfigurable;
    }

    public File getOverrideSourceFile() {
        if (this.mOverrideFilePath == null) {
            return null;
        }
        return new File(this.mOverrideFilePath);
    }

    public CheckInMode getCheckInMode() {
        return this.mCheckInMode;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    ResourceTypeAndOptions() {
    }
}

