/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.sun.n1.util.RPCSerializable;
import org.w3c.dom.Element;

public class ResourceDescriptorEntry
implements RPCSerializable {
    public static final String NO_VALUE_SENTINEL = ":NONE:";
    public static final String ROOT = "root";
    static String NAME_ATTR = "name";
    static String SETTINGS_ELEMENT = "settings";
    static String OWNER_ATTR = "owner";
    static String GROUP_ATTR = "group";
    static String PERMISSIONS_ATTR = "permissions";
    private String mName;
    private String mOwner;
    private String mGroup;
    private String mPermissions;

    ResourceDescriptorEntry(Element element) throws SystemModelParseException {
        this.mName = XMLUtil.getAttribute(element, NAME_ATTR);
        if (this.mName != null && !this.mName.equals(ROOT) && !this.mName.startsWith("root/")) {
            ROXMessage message = new ROXMessage("rsrc.descriptor.MALFORMED_ENTRY_NAME", new String[]{this.mName, ROOT});
            throw new SystemModelParseException(message);
        }
        Element[] settings = XMLUtil.getChildren(element, SETTINGS_ELEMENT);
        if (settings.length > 0) {
            this.mOwner = XMLUtil.getAttribute(settings[0], OWNER_ATTR);
            this.mGroup = XMLUtil.getAttribute(settings[0], GROUP_ATTR);
            this.mPermissions = XMLUtil.getAttribute(settings[0], PERMISSIONS_ATTR);
        }
    }

    ResourceDescriptorEntry(String name, String owner, String group, String permissions) {
        this.mName = name;
        this.mOwner = owner;
        this.mGroup = group;
        this.mPermissions = permissions;
    }

    public String getName() {
        return this.mName;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public String getPermissions() {
        return this.mPermissions;
    }
}

