/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceDescriptorEntry;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.sun.n1.util.RPCSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.ecs.xml.XML;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceDescriptor
implements RPCSerializable {
    private static final String RESOURCE_DESCRIPTOR_SCHEMA = "resourceDescriptor.xsd";
    private static final String ELEMENT_NAME = "resourceDescriptor";
    private static final String ENTRY_LIST_ATTR = "entryList";
    private static final String SCHEMA_VERSION_ATTR = "schemaVersion";
    private static final String DEFAULT_ENTRY_ELEMENT = "defaultEntry";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String DEFAULT_VERSION = "5.2";
    static final char DESCRIPTOR_SEPARATOR = '/';
    private String mSchemaVersion = "5.2";
    private ResourceDescriptorEntry mDefaultEntry;
    private HashMap mEntries = new HashMap();

    public static ResourceDescriptor getResourceDescriptor(final ResourceID resourceID) throws PersistenceManagerException, RPCException {
        ResourceDescriptorCtx result = (ResourceDescriptorCtx)ResourceDescriptor.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                ResourceDescriptorCtx rdc = null;
                try {
                    rdc = ResourceDescriptor.trGetResourceDescriptor(resourceID);
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
                catch (ResourceException e) {
                    throw new PersistenceManagerException(e);
                }
                return rdc;
            }
        });
        return result.getResourceDescriptor();
    }

    static PersistContext transactRPC(RPCTransaction transaction) throws PersistenceManagerException, RPCException {
        return PersistentServicesInit.transact(transaction);
    }

    static ResourceDescriptorCtx trGetResourceDescriptor(final ResourceID resourceID) throws PersistenceManagerException, RPCException, ResourceException {
        RsrcInfo info = resourceID.getByIDQuery().select();
        ResourceSubsystem rs = null;
        try {
            rs = PluginDBSubsystem.getInstance().getApplication().getResourceSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceException("rsrc.descriptor.UNEXPECTED_GENERATE_ERROR", (Throwable)e, new Object[]{info.getName()});
        }
        ResourceDescriptor rd = (ResourceDescriptor)new ResourceAccessor(rs){

            public Object innerAccess() throws ResourceException {
                ResourceDescriptor rd = new ResourceDescriptor();
                RsrcManifest manifest = this.getManifest(resourceID, null);
                ResourceEntryIterator entries = manifest.getEntryIterator();
                while (entries.hasNext()) {
                    ResourceEntry entry = entries.next();
                    NodePerms nodePerms = entry.getPerms();
                    String ownerName = ":NONE:";
                    String groupName = ":NONE:";
                    String permissions = ":NONE:";
                    if (nodePerms instanceof PosixNodePerms) {
                        PosixNodePerms pnp = (PosixNodePerms)nodePerms;
                        String pnpOwnerName = pnp.getOwnerName();
                        String pnpGroupName = pnp.getGroupName();
                        long pnpPerms = pnp.getPermBits();
                        if (pnpOwnerName != null) {
                            ownerName = pnpOwnerName;
                        }
                        if (pnpGroupName != null) {
                            groupName = pnpGroupName;
                        }
                        if (!pnp.isNoPerms()) {
                            permissions = Long.toOctalString(pnpPerms);
                        }
                    }
                    String entryName = ResourceDescriptor.getEntryName(entry);
                    rd.addEntry(new ResourceDescriptorEntry(entryName, ownerName, groupName, permissions));
                }
                return rd;
            }
        }.access();
        return new ResourceDescriptorCtx(rd);
    }

    public static String parseEntryPath(RsrcInfo info, ResourceEntry entry) {
        String resourceName = ResourceStringUtils.getURLFileName(info.getSourcePath());
        String path = entry.getRelPathWFwdSlashes();
        if ((path = path.replaceFirst("root", resourceName)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getEntryName(ResourceEntry entry) {
        String entryName = entry.getRelPathWFwdSlashes();
        if (entryName.endsWith("/")) {
            entryName = entryName.substring(0, entryName.length() - 1);
        }
        return entryName;
    }

    private ResourceDescriptor() {
    }

    public ResourceDescriptor(InputStream in) throws ResourceException, SystemModelParseException {
        this.readFromXML(new InputSource(in));
    }

    public String getSchemaVersion() {
        return this.mSchemaVersion;
    }

    public ResourceDescriptorEntry getDefaultEntry() {
        return this.mDefaultEntry;
    }

    public ResourceDescriptorEntry getEntry(String fileName) {
        return (ResourceDescriptorEntry)this.mEntries.get(fileName);
    }

    public ResourceDescriptorEntry[] getEntries() {
        return this.mEntries.values().toArray(new ResourceDescriptorEntry[this.mEntries.size()]);
    }

    public String writeToXML() {
        String sep = System.getProperty("line.separator");
        return XMLUtil.getXMLHeaderString() + this.writeToXMLElement().toString() + sep;
    }

    public void writeToXML(OutputStream out) throws IOException {
        XMLUtil.writeXMLHeader(out);
        this.writeToXMLElement().output(out);
        new PrintWriter(out, true).println();
    }

    private XML writeToXMLElement() {
        XML descriptor = new XML(ELEMENT_NAME);
        descriptor.setPrettyPrint(true);
        XMLUtil.addSchemaAttributes(descriptor, RESOURCE_DESCRIPTOR_SCHEMA);
        XMLUtil.addAttributeIfNotNull(descriptor, SCHEMA_VERSION_ATTR, this.mSchemaVersion);
        XML entryList = new XML(ENTRY_LIST_ATTR);
        entryList.setPrettyPrint(true);
        descriptor.addElement((org.apache.ecs.Element)entryList);
        if (this.mDefaultEntry != null) {
            entryList.addElement((org.apache.ecs.Element)this.writeDefaultEntryToXMLElement(this.mDefaultEntry));
        }
        ResourceDescriptorEntry[] entries = this.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            entryList.addElement((org.apache.ecs.Element)this.writeEntryToXMLElement(entries[i]));
        }
        return descriptor;
    }

    private XML writeEntryToXMLElement(ResourceDescriptorEntry rde) {
        XML entry = new XML(ENTRY_ELEMENT);
        entry.setPrettyPrint(true);
        XMLUtil.addAttributeIfNotNull(entry, ResourceDescriptorEntry.NAME_ATTR, rde.getName());
        entry.addElement((org.apache.ecs.Element)this.writeSettingsToXMLElement(rde));
        return entry;
    }

    private XML writeDefaultEntryToXMLElement(ResourceDescriptorEntry rde) {
        XML defaultEntry = new XML(DEFAULT_ENTRY_ELEMENT);
        defaultEntry.setPrettyPrint(true);
        defaultEntry.addElement((org.apache.ecs.Element)this.writeSettingsToXMLElement(rde));
        return defaultEntry;
    }

    private XML writeSettingsToXMLElement(ResourceDescriptorEntry rde) {
        XML settings = new XML(ResourceDescriptorEntry.SETTINGS_ELEMENT);
        settings.setPrettyPrint(true);
        XMLUtil.addAttributeIfNotNull(settings, ResourceDescriptorEntry.OWNER_ATTR, rde.getOwner());
        XMLUtil.addAttributeIfNotNull(settings, ResourceDescriptorEntry.GROUP_ATTR, rde.getGroup());
        XMLUtil.addAttributeIfNotNull(settings, ResourceDescriptorEntry.PERMISSIONS_ATTR, rde.getPermissions());
        return settings;
    }

    private void readFromXML(InputSource inputSource) throws SystemModelParseException {
        Element topLevelElement = this.parseInputSource(inputSource, true);
        this.mSchemaVersion = XMLUtil.getAttribute(topLevelElement, SCHEMA_VERSION_ATTR);
        Element[] entryListElement = XMLUtil.getChildren(topLevelElement, ENTRY_LIST_ATTR);
        if (entryListElement.length > 0) {
            Element[] defaultEntryElem = XMLUtil.getChildren(entryListElement[0], DEFAULT_ENTRY_ELEMENT);
            if (defaultEntryElem.length > 0) {
                this.mDefaultEntry = new ResourceDescriptorEntry(defaultEntryElem[0]);
            }
            Element[] entryList = XMLUtil.getChildren(entryListElement[0], ENTRY_ELEMENT);
            for (int i = 0; i < entryList.length; ++i) {
                ResourceDescriptorEntry rde = new ResourceDescriptorEntry(entryList[i]);
                this.addEntry(rde);
            }
        }
    }

    private Element parseInputSource(InputSource input, boolean reportErrors) throws SystemModelParseException {
        DOMParser parser = XMLUtil.obtainParser(reportErrors, RESOURCE_DESCRIPTOR_SCHEMA, "rsrc.descriptor.");
        try {
            parser.parse(input);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw ResourceDescriptor.newParseError(e);
        }
        catch (SAXException e) {
            throw ResourceDescriptor.newParseError(e);
        }
    }

    static SystemModelParseException newParseError(Exception e) {
        return new SystemModelParseException(e, "rsrc.descriptor.");
    }

    private void addEntry(ResourceDescriptorEntry rde) {
        this.mEntries.put(rde.getName(), rde);
    }

    static final class ResourceDescriptorCtx
    extends PersistContext {
        private ResourceDescriptor mResourceDescriptor;

        public ResourceDescriptorCtx(ResourceDescriptor resourceDescriptor) {
            this.setDescriptor(resourceDescriptor);
        }

        public ResourceDescriptor getResourceDescriptor() {
            return this.mResourceDescriptor;
        }

        private void setDescriptor(ResourceDescriptor resourceDescriptor) {
            this.mResourceDescriptor = resourceDescriptor;
        }
    }
}

