/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.FileMover;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInInterface;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobID;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.RelPathInfo;
import com.raplix.rolloutexpress.resource.checkInJob.RemoteSideCheckInData;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceDescriptor;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.multipipe.MultiReceivePipe;
import com.raplix.rolloutexpress.resource.multipipe.MultiSendPipe;
import com.raplix.rolloutexpress.resource.packageformat.DictionaryIter;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.PosixPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.threads.SafeThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class ClientCheckInImpl
implements Messages {
    private static final String NON_RELPATH_STR = "///";
    static final String CLIENT_COMPRESSION_DONE_STR = "CLIENT_COMPRESSION_DONE_STR_///";
    private MultiSendPipe mPackSender;
    private MultiReceivePipe mPackReceiver;
    private File mDataSrc;
    private File mTmpCompressedStore;
    private CompressThread mCompressThread;
    private RedundancyCheckMode mRedundancyCheckMode;
    private ResourceTypeAndOptions mResourceTypeAndOptions;
    private CheckInJobID mCheckInJobID;
    private CheckInInterface mCheckInInterface;
    private ClientCheckInImpl mClientCheckInImplThis = this;
    private boolean mResolveLinks = true;
    private boolean mFinished = false;
    private boolean mSleepLoop = true;
    private ResourceDescriptor mResourceDescriptor;

    CheckInJobID getCheckInJobID() {
        return this.mCheckInJobID;
    }

    public static RemoteSideCheckInData startClientCheckInImpl(ResourceTypeAndOptions inResourceTypeAndOptions, CheckInJobID inCheckInJobID, DataId inPackReceiverDataId, RedundancyCheckMode inRedundancyCheckMode, FileMover inFileMover, NetSubsystem inNetSubsys, CheckInInterface inCheckInInterface, boolean inResolveLinks) throws ResourceException {
        ClientCheckInImpl theClientCheckInImpl = new ClientCheckInImpl();
        return theClientCheckInImpl.setUp(inResourceTypeAndOptions, inCheckInJobID, inPackReceiverDataId, inRedundancyCheckMode, inFileMover, inNetSubsys, inCheckInInterface, inResolveLinks);
    }

    private RemoteSideCheckInData setUp(ResourceTypeAndOptions inResourceTypeAndOptions, CheckInJobID inCheckInJobID, DataId inPackReceiverDataId, RedundancyCheckMode inRedundancyCheckMode, FileMover inFileMover, NetSubsystem inNetSubsys, CheckInInterface inCheckInInterface, boolean inResolveLinks) throws ResourceException {
        this.mResourceTypeAndOptions = inResourceTypeAndOptions;
        PermOptions permOptions = this.mResourceTypeAndOptions.getPermOpts();
        String descriptorPath = permOptions.getResourceDescriptorPath();
        if (descriptorPath != null) {
            this.retrieveResourceDescriptor(descriptorPath);
        }
        this.mCheckInJobID = inCheckInJobID;
        this.mRedundancyCheckMode = inRedundancyCheckMode;
        this.mCheckInInterface = inCheckInInterface;
        this.mResolveLinks = inResolveLinks;
        this.createTmpStorage(inResourceTypeAndOptions);
        RoxAddress theRepoAddress = inNetSubsys.getRPC().getInvokerAddress();
        this.mPackSender = new MultiSendPipe("GoldSrvrSender " + inCheckInJobID, inFileMover, theRepoAddress, inPackReceiverDataId);
        this.mPackReceiver = new MultiReceivePipe("CheckInGoldsrvrReceiver " + inCheckInJobID, inFileMover){

            public void processObject(Object inObject) throws ResourceException {
                DeferredFileInputStream theFileInStream;
                if (inObject instanceof String) {
                    String theString = (String)inObject;
                    if (!"SERVER_DONE_STR".equals(theString)) {
                        MiscUtils.throwUPE(1340480L);
                    }
                    ClientCheckInImpl.this.finish();
                    return;
                }
                RelPathInfo theRelPathInfo = (RelPathInfo)inObject;
                File theCompressedFile = ClientCheckInImpl.this.relPathToCompressedFile(theRelPathInfo.mRelPath);
                ClientCheckInImpl.this.mPackSender.addObject((Serializable)((Object)theRelPathInfo.mRelPath));
                try {
                    theFileInStream = new DeferredFileInputStream(theCompressedFile);
                }
                catch (FileNotFoundException e) {
                    throw new ResourceException(e);
                }
                ClientCheckInImpl.this.mPackSender.addStream(theFileInStream, theCompressedFile.length());
                ClientCheckInImpl.this.mPackSender.flush();
            }

            public void senderFinished() {
                ClientCheckInImpl.this.finish();
            }

            public void senderFinishedWithError(CommandException inError) {
                ClientCheckInImpl.this.finish();
            }
        };
        this.mCheckInInterface.insert(this);
        return new RemoteSideCheckInData(RsrcManifest.getOSName(), PlatformUtil.isPOSIX(), this.mDataSrc.isDirectory(), this.mPackReceiver.getDataId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void retrieveResourceDescriptor(String descriptorPath) throws ResourceException {
        Object rd = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(descriptorPath);
                this.mResourceDescriptor = new ResourceDescriptor(fis);
            }
            catch (IOException e) {
                throw new ResourceException("rsrc.descriptor.IO_ERROR", (Throwable)e, new Object[]{descriptorPath});
            }
            catch (SystemModelParseException e) {
                throw new ResourceException(e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceException("rsrc.descriptor.IO_ERROR", (Throwable)e, new Object[]{descriptorPath});
            }
        }
        try {}
        catch (IOException e) {
            throw new ResourceException("rsrc.descriptor.IO_ERROR", (Throwable)e, new Object[]{descriptorPath});
        }
        if (fis == null) return;
        fis.close();
    }

    private File relPathToCompressedFile(String inRelPath) {
        return new File(this.mTmpCompressedStore, ResourceParser.stripRoot(inRelPath));
    }

    void postServerInsert() {
        this.mCompressThread = new CompressThread();
        this.mCompressThread.start();
    }

    void abortFromServer() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        MultiSendPipe thePackSender = null;
        ClientCheckInImpl clientCheckInImpl = this;
        synchronized (clientCheckInImpl) {
            if (this.mFinished) {
                return;
            }
            this.mFinished = true;
            thePackSender = this.mPackSender;
            this.mPackSender = null;
        }
        try {
            block11: {
                this.mCheckInInterface.remove(this.mClientCheckInImplThis);
                if (thePackSender != null) {
                    try {
                        thePackSender.finish();
                    }
                    catch (ResourceException e) {
                        if (!Logger.isErrorEnabled(this)) break block11;
                        Logger.error(ROXMessageManager.messageAsString("rsrc.PACKSENDER_CLOSE_FAILED"), this);
                    }
                }
            }
            if (this.mPackReceiver != null) {
                this.mPackReceiver.close();
                this.mPackReceiver = null;
            }
        }
        finally {
            this.mSleepLoop = false;
        }
    }

    private void createTmpStorage(ResourceTypeAndOptions inResourceTypeAndOptions) throws ResourceException {
        this.mDataSrc = inResourceTypeAndOptions.getOverrideSourceFile() != null ? inResourceTypeAndOptions.getOverrideSourceFile() : new File(inResourceTypeAndOptions.getAbstractPath());
        if (!this.mDataSrc.exists()) {
            throw new ResourceException("rsrc.msg0388", new Object[]{this.mDataSrc});
        }
        String theTmpName = "compressed_" + System.currentTimeMillis();
        this.mTmpCompressedStore = this.mDataSrc.isDirectory() ? ResourceFileUtils.createTempFolder(theTmpName) : ResourceFileUtils.createTempFile(theTmpName);
    }

    private void compressAndProcess(File inSrcUncompressedFile, String inRootRelPath, final PermOptions inPermOptions) throws ResourceException {
        new DictionaryIter(inSrcUncompressedFile, inRootRelPath, this.mResolveLinks){

            public void process(String inDictRelPath, File inFile, SubnodeType inSubnodeType) throws ResourceException {
                if (ClientCheckInImpl.this.mPackSender == null) {
                    throw new ResourceException("rsrc.msg0389");
                }
                if (inSubnodeType == null) {
                    return;
                }
                NodePerms theNodePerms = null;
                if (ClientCheckInImpl.this.mResourceDescriptor != null) {
                    theNodePerms = PlatformPermissionFactory.getInstance().createDescriptorNodePerms(inFile, inPermOptions);
                    String thePathWithoutTrailingSep = inDictRelPath;
                    while (ResourceStringUtils.endsInSeparator(thePathWithoutTrailingSep)) {
                        thePathWithoutTrailingSep = thePathWithoutTrailingSep.substring(0, thePathWithoutTrailingSep.length() - 1);
                    }
                    PosixPermissionFactory.overrideNodePerms(theNodePerms, thePathWithoutTrailingSep, ClientCheckInImpl.this.mResourceDescriptor);
                } else {
                    theNodePerms = PlatformPermissionFactory.getInstance().createNodePerms(inFile, inPermOptions);
                }
                if (SubnodeType.SYMLINK.equals(inSubnodeType)) {
                    String theLinkTarget = ResourceFileUtils.getLinkTarget(inFile);
                    if (theLinkTarget == null) {
                        MiscUtils.throwUPE(1340482L);
                    }
                    RelPathInfo theRelPathInfo = new RelPathInfo(inDictRelPath, SubnodeType.SYMLINK, 0L, inFile.lastModified(), theNodePerms, theLinkTarget, 0L, null, false);
                    ClientCheckInImpl.this.informServerOfEntry(theRelPathInfo);
                } else if (SubnodeType.DIRECTORY.equals(inSubnodeType)) {
                    RelPathInfo theRelPathInfo = new RelPathInfo(inDictRelPath, SubnodeType.DIRECTORY, 0L, inFile.lastModified(), theNodePerms, null, 0L, null, false);
                    ClientCheckInImpl.this.informServerOfEntry(theRelPathInfo);
                } else if (SubnodeType.FILE.equals(inSubnodeType)) {
                    File theDstCompressedFile = ClientCheckInImpl.this.relPathToCompressedFile(inDictRelPath);
                    theDstCompressedFile.getParentFile().mkdirs();
                    byte[] theDigest = MiscUtils.compressAndGetMD5(inFile, theDstCompressedFile);
                    RelPathInfo theRelPathInfo = new RelPathInfo(inDictRelPath, SubnodeType.FILE, inFile.length(), inFile.lastModified(), theNodePerms, null, theDstCompressedFile.length(), theDigest, true);
                    ClientCheckInImpl.this.informServerOfEntry(theRelPathInfo);
                } else {
                    MiscUtils.throwUPE(0x147441L);
                }
            }
        }.exec();
    }

    private void informServerOfEntry(RelPathInfo inRelPathInfo) throws ResourceException {
        if (this.mPackSender != null) {
            this.mPackSender.addObject(inRelPathInfo);
            this.mPackSender.flush();
        }
    }

    static class DeferredFileInputStream
    extends InputStream {
        private File mFile;
        private FileInputStream mFileInputStream;

        DeferredFileInputStream(File inFile) throws FileNotFoundException {
            this.mFile = inFile;
            if (!inFile.isFile()) {
                throw new FileNotFoundException(ROXMessageManager.messageAsString("rsrc.FILE_NOT_FOUND", new Object[]{inFile}));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            DeferredFileInputStream deferredFileInputStream = this;
            synchronized (deferredFileInputStream) {
                if (this.mFileInputStream != null) {
                    this.mFileInputStream.close();
                    this.mFileInputStream = null;
                }
                this.mFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureOpen() throws IOException {
            if (this.mFileInputStream == null) {
                DeferredFileInputStream deferredFileInputStream = this;
                synchronized (deferredFileInputStream) {
                    if (this.mFileInputStream == null) {
                        this.mFileInputStream = new FileInputStream(this.mFile);
                    }
                }
            }
        }

        public int available() throws IOException {
            this.ensureOpen();
            return this.mFileInputStream.available();
        }

        public int read() throws IOException {
            this.ensureOpen();
            return this.mFileInputStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            return this.mFileInputStream.read(b, off, len);
        }
    }

    private class CompressThread
    extends SafeThread {
        private CompressThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            ClientCheckInImpl.this.compressAndProcess(ClientCheckInImpl.this.mDataSrc, "root", ClientCheckInImpl.this.mResourceTypeAndOptions.getPermOpts());
            CompressThread compressThread = this;
            synchronized (compressThread) {
                if (ClientCheckInImpl.this.mPackSender != null) {
                    ClientCheckInImpl.this.mPackSender.addObject((Serializable)((Object)ClientCheckInImpl.CLIENT_COMPRESSION_DONE_STR));
                    ClientCheckInImpl.this.mPackSender.flush();
                }
            }
            while (ClientCheckInImpl.this.mSleepLoop) {
                MiscUtils.resourceSleep(250L);
            }
            Object var5_6 = null;
            try {
                try {
                    ResourceFileUtils.deleteDirectory(ClientCheckInImpl.this.mTmpCompressedStore);
                    return;
                }
                catch (ResourceException e) {
                    if (!Logger.isErrorEnabled(this)) return;
                    String message = ROXMessageManager.messageAsString("rsrc.DELETE_DIR_FAILED", new Object[]{ClientCheckInImpl.this.mTmpCompressedStore});
                    Logger.error(message, this);
                }
                return;
            }
            finally {
                ClientCheckInImpl.this.mCheckInInterface.remove(ClientCheckInImpl.this.mClientCheckInImplThis);
            }
            {
                catch (Throwable t) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(ROXMessageManager.messageAsString("rsrc.COMPRESS_PROCESS_ERROR"), t, this);
                    }
                    try {
                        CompressThread compressThread2 = this;
                        synchronized (compressThread2) {
                            if (ClientCheckInImpl.this.mPackSender != null) {
                                ClientCheckInImpl.this.mPackSender.finishErr(MiscUtils.resourceWrap(t));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    Object var5_7 = null;
                    try {
                        try {
                            ResourceFileUtils.deleteDirectory(ClientCheckInImpl.this.mTmpCompressedStore);
                            return;
                        }
                        catch (ResourceException e) {
                            if (!Logger.isErrorEnabled(this)) return;
                            String message = ROXMessageManager.messageAsString("rsrc.DELETE_DIR_FAILED", new Object[]{ClientCheckInImpl.this.mTmpCompressedStore});
                            Logger.error(message, this);
                        }
                        return;
                    }
                    finally {
                        ClientCheckInImpl.this.mCheckInInterface.remove(ClientCheckInImpl.this.mClientCheckInImplThis);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    try {
                        ResourceFileUtils.deleteDirectory(ClientCheckInImpl.this.mTmpCompressedStore);
                        throw throwable;
                    }
                    catch (ResourceException e) {
                        if (!Logger.isErrorEnabled(this)) throw throwable;
                        String message = ROXMessageManager.messageAsString("rsrc.DELETE_DIR_FAILED", new Object[]{ClientCheckInImpl.this.mTmpCompressedStore});
                        Logger.error(message, this);
                    }
                    throw throwable;
                }
                finally {
                    ClientCheckInImpl.this.mCheckInInterface.remove(ClientCheckInImpl.this.mClientCheckInImplThis);
                }
            }
        }
    }
}

