/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.resource.DeferredDeleteTable;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobHash;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobID;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobImpl;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.StandardCheckIn;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Iterator;
import java.util.Vector;

public class CheckInJobMgr {
    private ResourceSubsysImpl mRsrcCtx;
    private Vector mQueuedJobs = new Vector();
    private CheckInJobHash mCheckInJobImpls = new CheckInJobHash();

    public CheckInJobMgr(ResourceSubsysImpl inRsrcCtx) throws ResourceException {
        if (!inRsrcCtx.isServer()) {
            throw new ResourceException("rsrc.msg0386");
        }
        this.mRsrcCtx = inRsrcCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusMonitor spawnCheckInJobOnMS(ResourceTypeAndOptions inResourceTypeAndOptions, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheckMode, VersionedSaveContext inVersionedSaveContext, HostSetID inPlatform, UserID inUserID, boolean inResolveLinks, boolean inIsAsync, PluginID inPluginID, boolean inFromMSApp) throws ResourceException, RPCException {
        DeferredDeleteTable.enterCheckInWithinTree(inResourceSpec);
        try {
            Object object;
            RoxAddress theAddress = this.mRsrcCtx.getApplication().getNetSubsystem().getRPC().getInvokerAddress();
            StandardCheckIn theJobImpl = new StandardCheckIn(CheckInJobID.generateCheckInJobID(), inResourceTypeAndOptions, inCategoryIDSet, inConfigurable, inResourceSpec, inRedundancyCheckMode, inVersionedSaveContext, inPlatform, theAddress, this.mRsrcCtx, inUserID, inResolveLinks, inPluginID, inFromMSApp);
            if (inIsAsync) {
                theJobImpl.start();
                object = this.mCheckInJobImpls;
                synchronized (object) {
                    this.mCheckInJobImpls.put(theJobImpl);
                }
                try {
                    ((CheckInJobImpl)theJobImpl).postInsert();
                }
                catch (ResourceException e) {
                    this.mCheckInJobImpls.remove(theJobImpl);
                    theJobImpl.cancel();
                    throw e;
                }
            }
            ((CheckInJobImpl)theJobImpl).startPhase1();
            CheckInJobHash e = this.mCheckInJobImpls;
            synchronized (e) {
                this.mCheckInJobImpls.put(theJobImpl);
            }
            try {
                ((CheckInJobImpl)theJobImpl).postInsert();
            }
            catch (ResourceException e2) {
                this.mCheckInJobImpls.remove(theJobImpl);
                theJobImpl.cancel();
                throw e2;
            }
            ((CheckInJobImpl)theJobImpl).startPhase2();
            ((CheckInJobImpl)theJobImpl).resourceLoop();
            ((CheckInJobImpl)theJobImpl).resourceFinish();
            object = theJobImpl;
            return object;
        }
        finally {
            DeferredDeleteTable.leaveCheckInWithinTree(inResourceSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informOfStatusChange(CheckInJobImpl inCheckInJobImpl) {
        Object object = this.mCheckInJobImpls;
        synchronized (object) {
            this.mCheckInJobImpls.remove(inCheckInJobImpl);
        }
        object = this.mQueuedJobs;
        synchronized (object) {
            this.mQueuedJobs.remove(inCheckInJobImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(CheckInJobImpl inCheckInJobImpl) {
        Vector vector = this.mQueuedJobs;
        synchronized (vector) {
            this.mQueuedJobs.add(inCheckInJobImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOkToStart(CheckInJobImpl inCheckInJobImpl) throws ResourceException {
        ResourceSpec theResourceSpec = inCheckInJobImpl.mResourceSpec;
        Vector vector = this.mQueuedJobs;
        synchronized (vector) {
            Iterator theIter = this.mQueuedJobs.iterator();
            while (theIter.hasNext()) {
                CheckInJobImpl theJobImpl = (CheckInJobImpl)theIter.next();
                if (theJobImpl == inCheckInJobImpl) {
                    return true;
                }
                if (!theJobImpl.mResourceSpec.equals(theResourceSpec)) continue;
                return false;
            }
        }
        throw new ResourceException("CheckIn job no longer pending: " + theResourceSpec);
    }
}

