/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.checkInJob;

import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobID;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInJobMgr;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Cancelled;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.InProgress;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.threads.RunnableContext;
import com.raplix.util.threads.ThreadAbortedException;

public abstract class CheckInJobImpl
extends RunnableContext
implements StatusMonitor {
    private CheckInJobID mCheckInJobID;
    private boolean mWasError = false;
    protected HostID mHostID;
    protected String mResourceType;
    protected String mAbstractPath;
    protected CategoryIDSet mCategoryIDSet;
    protected boolean mConfigurable;
    protected ResourceSpec mResourceSpec;
    protected RedundancyCheckMode mRedundancyCheckMode;
    protected HostSetID mPlatform;
    protected RoxAddress mInitiatorAddress;
    protected UserID mUserID;
    protected String mHostName;
    protected ResourceSubsysImpl mRsrcCtx;
    protected CheckInJobMgr mCheckInJobMgr;
    protected PluginID mPluginID;
    private boolean mIsDone = false;
    private CheckInStatus mStatus = new InProgress();
    Object mStatusTransition = new Object();

    protected CheckInJobImpl(CheckInJobID inNewJobID, String inCheckInType, RoxAddress inInitiatorAddress, ResourceSubsysImpl inRsrcCtx, UserID inUserID) {
        super((inCheckInType == null ? "CheckInJobImpl" : inCheckInType) + " " + inNewJobID.toString(), inRsrcCtx.getGlobalContext());
        this.mCheckInJobID = inNewJobID;
        this.mInitiatorAddress = inInitiatorAddress;
        this.mRsrcCtx = inRsrcCtx;
        this.mUserID = inUserID;
        this.mCheckInJobMgr = inRsrcCtx.getCheckInJobMgr();
    }

    public boolean isDone() {
        return this.mIsDone;
    }

    public CheckInStatus waitWhileInProgress() throws ResourceException {
        while (this.getStatus() instanceof InProgress) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new ResourceException(e);
            }
        }
        return this.getStatus();
    }

    protected void verifyTypeCoherence(String inPreviousType, String inNewType) throws ResourceException {
        if (!inPreviousType.equals(inNewType)) {
            throw new ResourceException("rsrc.msg0442", new Object[]{inNewType, inPreviousType});
        }
    }

    void setUpJobRecord(HostID inHostID, String inAbstractPath, String inResourceType, CategoryIDSet inCategoryIDSet, boolean inConfigurable, ResourceSpec inResourceSpec, RedundancyCheckMode inRedundancyCheckMode, HostSetID inPlatform, PluginID inPluginID) throws ResourceException {
        if (inResourceType == null) {
            throw new NullPointerException();
        }
        if (inResourceSpec == null) {
            throw new NullPointerException();
        }
        if (inRedundancyCheckMode == null) {
            throw new NullPointerException();
        }
        this.mHostID = inHostID;
        if (inHostID != null) {
            try {
                Host theHost = inHostID.getByIDQuery().select();
                this.mHostName = theHost.getName();
            }
            catch (RPCException e) {
                throw new ResourceException("rsrc.msg0449", new Object[]{inHostID});
            }
            catch (PersistenceManagerException e) {
                throw new ResourceException("rsrc.msg0450", new Object[]{inHostID});
            }
        }
        this.mAbstractPath = inAbstractPath;
        this.mResourceType = inResourceType;
        this.mCategoryIDSet = inCategoryIDSet;
        this.mConfigurable = inConfigurable;
        this.mResourceSpec = inResourceSpec;
        this.mRedundancyCheckMode = inRedundancyCheckMode;
        this.mPlatform = inPlatform;
        this.mPluginID = inPluginID;
        if (this.mPlatform == null) {
            try {
                this.mPlatform = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID;
            }
            catch (RPCException e) {
                throw new ResourceException(e);
            }
            catch (PersistenceManagerException e) {
                throw new ResourceException(e);
            }
        }
    }

    public CheckInJobID getCheckInJobID() {
        return this.mCheckInJobID;
    }

    public abstract void doSafeRun() throws ResourceException;

    abstract void handleError(Throwable var1);

    public final CheckInStatus getStatus() {
        return this.mStatus;
    }

    void postInsert() throws ResourceException {
    }

    public final void safeRun() throws ResourceException {
        this.doSafeRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() throws Exception {
        try {
            this.mRsrcCtx.getApplication().getResourceSubsystem().subsystemTaskComplete(this.getName());
        }
        finally {
            super.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void gatedHandleError(Throwable inThrowable) {
        CheckInJobImpl checkInJobImpl = this;
        synchronized (checkInJobImpl) {
            if (this.mWasError) {
                return;
            }
            this.mWasError = true;
        }
        this.handleError(inThrowable);
    }

    protected final void failed(Throwable inThrowable) {
        this.gatedHandleError(inThrowable);
        super.failed(inThrowable);
        this.mIsDone = true;
    }

    protected final void aborted(ThreadAbortedException inAbortedException) {
        this.gatedHandleError(inAbortedException);
        super.aborted(inAbortedException);
        this.mIsDone = true;
    }

    protected final void ended() {
        this.mIsDone = true;
    }

    public final void cancel() {
        new StateTransition(){

            CheckInStatus makeNewStatus() {
                return new Cancelled(System.currentTimeMillis());
            }
        }.attemptAndSnuffErrs();
        this.abort();
        while (!this.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    protected void resourceTestFlow() throws ResourceException {
        try {
            this.testFlow();
        }
        catch (InterruptedException e) {
            throw new ResourceException(e);
        }
    }

    public void start() throws ResourceException {
        try {
            this.mRsrcCtx.getApplication().getResourceSubsystem().startSubsystemTask(this);
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceException(e);
        }
        catch (RaplixShutdownException e) {
            throw new ResourceException(e);
        }
    }

    void startPhase1() throws ResourceException {
    }

    void startPhase2() throws ResourceException {
    }

    void resourceLoop() throws ResourceException {
    }

    void resourceFinish() throws ResourceException {
    }

    abstract class StateTransition {
        StateTransition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean attempt() throws ResourceException {
            Object object = CheckInJobImpl.this.mStatusTransition;
            synchronized (object) {
                if (CheckInJobImpl.this.mStatus instanceof InProgress) {
                    CheckInJobImpl.this.mStatus = this.makeNewStatus();
                    CheckInJobImpl.this.mCheckInJobMgr.informOfStatusChange(CheckInJobImpl.this);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attemptAndSnuffErrs() {
            Object object = CheckInJobImpl.this.mStatusTransition;
            synchronized (object) {
                if (CheckInJobImpl.this.mStatus instanceof InProgress) {
                    boolean didSucceed = false;
                    try {
                        CheckInJobImpl.this.mStatus = this.makeNewStatus();
                        didSucceed = true;
                    }
                    catch (ResourceException resourceException) {
                    }
                    finally {
                        if (didSucceed) {
                            CheckInJobImpl.this.mCheckInJobMgr.informOfStatusChange(CheckInJobImpl.this);
                        }
                    }
                }
            }
        }

        abstract CheckInStatus makeNewStatus() throws ResourceException;
    }
}

