/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.capture;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.capture.FileDatabase;
import com.raplix.rolloutexpress.resource.capture.OwnedCaptureID;
import com.raplix.rolloutexpress.resource.capture.OwnedCaptureType;
import com.raplix.rolloutexpress.resource.capture.ServerRefDbase;
import com.raplix.rolloutexpress.resource.capture.ServerReference;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTableEntry;
import com.raplix.rolloutexpress.resource.compression.DecompressionInputStream;
import com.raplix.rolloutexpress.resource.compression.SummedCompressionInputStream;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.ZipPacker;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.util.logger.Logger;
import com.raplix.util.minidb.SearchCriteria;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class SnapshotOwnerTable
implements Messages {
    private boolean mIsTransacting = false;
    private boolean mIsWin32 = PlatformUtil.isWin32();
    private File mSnapshotOwnerDir;
    private File mSavedCapturesDir;
    private FileDatabase mOwnerTableDbase;
    private File mDeletedCapturesDir;
    private ResourceSubsysImpl mRsrcCtx;
    private ServerRefDbase mServerRefDbase;
    private static final String META_TAG = "_META_:";
    private static final String VERSION = "0";
    private static final int sUniqueOIDIdx = 0;
    private static final int sEntryNameIdx = 1;
    private static final int sInstalledCompIDIdx = 2;
    private static final int sSnapshotIDIdx = 3;
    private static final int sOwnedCaptureIDIdx = 4;
    private static final int sOwnedCaptureTypeIdx = 5;
    private static final int sLengthBytesIdx = 6;
    private static final int sOwnerDBColumnCount = 7;
    private static final String SINGLE_ENTRY_NAME = "Single";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeOrphanedEntries(InstalledComponentID[] inCurrentCompIDs) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            final HashSet<String> theRetainedStrings = new HashSet<String>();
            for (int i = 0; i < inCurrentCompIDs.length; ++i) {
                theRetainedStrings.add(inCurrentCompIDs[i].toString());
            }
            String[] theMatches = this.mOwnerTableDbase.search(new SearchCriteria(){

                public boolean matches(String[] inDbaseRow) {
                    String theDbaseString = inDbaseRow[2];
                    return !theRetainedStrings.contains(theDbaseString);
                }
            });
            this.deleteKeys(theMatches);
            this.moveUnrefdCaptures();
        }
    }

    private boolean namesEqual(String inName1, String inName2) {
        if (this.mIsWin32) {
            return inName1.equalsIgnoreCase(inName2);
        }
        return inName1.equals(inName2);
    }

    public SnapshotOwnerTable(ResourceSubsysImpl inCtx, File inSnapshotOwnerDir) throws CaptureException {
        if (inCtx == null) {
            throw new CaptureException("rsrc.msg0331");
        }
        this.mRsrcCtx = inCtx;
        this.mSnapshotOwnerDir = inSnapshotOwnerDir.getAbsoluteFile();
        this.mSavedCapturesDir = new File(this.mSnapshotOwnerDir, "__SAVED_CAPTURES__");
        this.mDeletedCapturesDir = new File(this.mSnapshotOwnerDir, "__DELETED_FILES__");
        this.mServerRefDbase = ServerRefDbase.makeServerRefDbase(new File(this.mSnapshotOwnerDir, "__ServerRefDbase__"));
        this.initDirs();
        this.loadDbases();
        this.deleteUnrefdFiles();
    }

    public void addRefs(RsrcManifest inResourceManifest) throws CaptureException {
        this.mServerRefDbase.addRefs(inResourceManifest);
    }

    private void initDirs() throws CaptureException {
        this.mSnapshotOwnerDir.mkdirs();
        if (!this.mSnapshotOwnerDir.isDirectory()) {
            throw new CaptureException("rsrc.msg0332", new Object[]{this.mSnapshotOwnerDir.getAbsolutePath()});
        }
        this.mSavedCapturesDir.mkdirs();
        if (!this.mSavedCapturesDir.isDirectory()) {
            throw new CaptureException("rsrc.msg0333", new Object[]{this.mSavedCapturesDir.getAbsolutePath()});
        }
        this.deleteAndCreateDeletedFilesDir();
    }

    public void forTestOnly_ClearTable() throws CaptureException {
        try {
            ResourceFileUtils.deleteDirectory(this.mSnapshotOwnerDir);
            ResourceFileUtils.deleteDirectory(this.mSavedCapturesDir);
            ResourceFileUtils.deleteDirectory(this.mDeletedCapturesDir);
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
        this.initDirs();
        this.mOwnerTableDbase.forTestOnly_Clear();
    }

    void setTransacting(boolean inIsTransacting) throws CaptureException {
        if (this.mIsTransacting == inIsTransacting) {
            throw new CaptureException("rsrc.msg0412");
        }
        this.mIsTransacting = inIsTransacting;
    }

    private void deleteAndCreateDeletedFilesDir() throws CaptureException {
        try {
            ResourceFileUtils.deleteDirectory(this.mDeletedCapturesDir);
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
        this.mDeletedCapturesDir.mkdirs();
        if (!this.mDeletedCapturesDir.isDirectory()) {
            throw new CaptureException("rsrc.msg0334", new Object[]{this.mDeletedCapturesDir.getAbsolutePath()});
        }
    }

    private File getCaptureFileObject(OwnedCaptureID inCaptureID) {
        return new File(this.mSavedCapturesDir, inCaptureID.toString()).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteKeys(String[] inKeys) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            for (int i = 0; i < inKeys.length; ++i) {
                this.mOwnerTableDbase.forceDelete(inKeys[i]);
            }
        }
    }

    private void loadDbases() throws CaptureException {
        this.mOwnerTableDbase = new FileDatabase(new File(this.mSnapshotOwnerDir, "__OwnerDbase__"), 7, 0);
        this.mOwnerTableDbase.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revert() throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            if (this.mIsTransacting) {
                throw new CaptureException("rsrc.msg0335");
            }
            this.loadDbases();
            File[] theDeletedFiles = this.mDeletedCapturesDir.listFiles();
            if (theDeletedFiles != null) {
                for (int i = 0; i < theDeletedFiles.length; ++i) {
                    File theSrcFile = theDeletedFiles[i];
                    File theDstFile = new File(this.mSavedCapturesDir, theSrcFile.getName());
                    theDstFile.delete();
                    try {
                        ResourceFileUtils.moveData(theSrcFile, theDstFile);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CaptureException(e);
                    }
                }
            }
            this.deleteUnrefdFiles();
            this.deleteAndCreateDeletedFilesDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            if (this.mIsTransacting) {
                throw new CaptureException("rsrc.msg0336");
            }
            this.mOwnerTableDbase.save();
            this.deleteAndCreateDeletedFilesDir();
        }
    }

    private void verifyTransacting() throws CaptureException {
        if (!this.mIsTransacting) {
            throw new CaptureException("rsrc.msg0337");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeStreamToInternalFormat(File inDstZipFile, long inDstFileTime, InputStream inStream, String inLabel) throws CaptureException {
        long l;
        ZipPacker thePacker = new ZipPacker(new ZipOutputStream(new FileOutputStream(inDstZipFile)));
        try {
            ZipEntry theZipEntry = new ZipEntry(inLabel);
            theZipEntry.setTime(inDstFileTime);
            thePacker.pack(theZipEntry, inStream);
            l = theZipEntry.getSize();
        }
        catch (Throwable throwable) {
            try {
                thePacker.finish();
                throw throwable;
            }
            catch (ResourceException e) {
                throw new CaptureException(e);
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
        thePacker.finish();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertInternalFormatToFile(File inZipFile, File inDstFile) throws CaptureException {
        try {
            ZipFile theZipFile = new ZipFile(inZipFile);
            try {
                Enumeration<? extends ZipEntry> theEntries = theZipFile.entries();
                ZipEntry theZipEntry = theEntries.nextElement();
                String theEntryName = theZipEntry.getName();
                if (theEntryName.startsWith(META_TAG)) {
                    ServerReference theRef = new ServerReference(ResourceFileUtils.getObjectInputStreamFromZipEntry(theZipFile, theZipEntry));
                    this.mRsrcCtx.pullServerEntryToLocalFile(theRef.mResourceID, theRef.mRelPath, inDstFile.getAbsoluteFile());
                } else {
                    InputStream theInputStream = theZipFile.getInputStream(theZipEntry);
                    ResourceFileUtils.writeStreamToFile(inDstFile, inZipFile.lastModified(), theInputStream);
                }
            }
            finally {
                theZipFile.close();
            }
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
        catch (IOException e) {
            throw new CaptureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OwnedCaptureID insertSet(String inEntryName, InstalledComponentID inInstalledComponentID, SnapshotID inSnapshotID, OwnedCaptureType inOwnedCaptureType, InputStream inSrcStream) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            File theTempFile = null;
            try {
                OwnedCaptureID theOwnedCaptureID;
                File theNewFile;
                String theLabel = SINGLE_ENTRY_NAME;
                InputStream theInputStream = inSrcStream;
                ServerReference theServerRef = null;
                long theLengthBytes = 0L;
                if (inOwnedCaptureType.equals(OwnedCaptureType.FILE_CONTENTS)) {
                    theTempFile = File.createTempFile("snapshot_", null);
                    SummedCompressionInputStream theCompressionStream = new SummedCompressionInputStream(inSrcStream);
                    ResourceFileUtils.writeStreamToFile(theTempFile, System.currentTimeMillis(), theCompressionStream);
                    theTempFile.deleteOnExit();
                    byte[] theMD5 = theCompressionStream.getDigest();
                    theLengthBytes = theCompressionStream.getUncompressedLength();
                    theServerRef = this.mServerRefDbase.get(theMD5, theLengthBytes);
                    if (theServerRef != null) {
                        try {
                            if (!this.mRsrcCtx.getMSRsrcMgr().isSnapshotOptimizable(theServerRef.mResourceID, this.mRsrcCtx.getApplication().getLocalNodeAddress())) {
                                theServerRef = null;
                            }
                        }
                        catch (RPCException e) {
                            throw new CaptureException("rsrc.msg0441", (Throwable)e);
                        }
                    }
                    if (theServerRef != null) {
                        ByteArrayOutputStream theByteOutStream = new ByteArrayOutputStream();
                        ObjectOutputStream theObjectOutStream = new ObjectOutputStream(theByteOutStream);
                        theServerRef.toStream(theObjectOutStream);
                        theObjectOutStream.close();
                        byte[] theBytes = theByteOutStream.toByteArray();
                        theInputStream = new ByteArrayInputStream(theBytes);
                        theLabel = "_META_:0";
                    } else {
                        theInputStream = new DecompressionInputStream(new FileInputStream(theTempFile));
                        theLabel = SINGLE_ENTRY_NAME;
                    }
                }
                if ((theNewFile = this.getCaptureFileObject(theOwnedCaptureID = OwnedCaptureID.generateOwnedCaptureID())).exists()) {
                    throw new CaptureException("rsrc.msg0338", new Object[]{theNewFile});
                }
                try {
                    long theWrittenLength = SnapshotOwnerTable.writeStreamToInternalFormat(theNewFile, System.currentTimeMillis(), theInputStream, theLabel);
                    if (!inOwnedCaptureType.equals(OwnedCaptureType.FILE_CONTENTS)) {
                        theLengthBytes = theWrittenLength;
                    }
                }
                catch (Exception e) {
                    throw new CaptureException(e);
                }
                ObjectID theObjectID = new ObjectID(ResourceID.generateResourceID().toString());
                this.writeEntry(theObjectID, inEntryName, inInstalledComponentID, inSnapshotID, theOwnedCaptureID, inOwnedCaptureType.toString(), Long.toString(theLengthBytes));
                OwnedCaptureID ownedCaptureID = theOwnedCaptureID;
                return ownedCaptureID;
            }
            catch (ResourceException e) {
                throw new CaptureException("rsrc.msg0413", (Throwable)e);
            }
            catch (IOException e) {
                throw new CaptureException("rsrc.msg0414", (Throwable)e);
            }
            finally {
                if (theTempFile != null) {
                    theTempFile.delete();
                }
            }
        }
    }

    private void writeEntry(ObjectID inObjectID, String inEntryName, InstalledComponentID inInstalledComponentID, SnapshotID inSnapshotID, OwnedCaptureID inOwnedCaptureID, String inOwnedCaptureTypeString, String inLengthBytesString) throws CaptureException {
        if (inEntryName == null) {
            throw new NullPointerException();
        }
        final String[] theRow = new String[]{inObjectID.toString(), inEntryName, inInstalledComponentID.toString(), inSnapshotID.toString(), inOwnedCaptureID.toString(), inOwnedCaptureTypeString, inLengthBytesString};
        String[] theMatchingKeys = this.mOwnerTableDbase.search(new SearchCriteria(){

            public boolean matches(String[] inDbaseRow) {
                if (!SnapshotOwnerTable.this.namesEqual(theRow[1], inDbaseRow[1])) {
                    return false;
                }
                if (!theRow[2].equals(inDbaseRow[2])) {
                    return false;
                }
                if (!theRow[3].equals(inDbaseRow[3])) {
                    return false;
                }
                return theRow[4].equals(inDbaseRow[4]);
            }
        });
        this.deleteKeys(theMatchingKeys);
        this.mOwnerTableDbase.insert(theRow);
        this.moveUnrefdCaptures();
    }

    private String[] getUnrefdCaptureNames() throws CaptureException {
        String[] theCurCaptures = this.mSavedCapturesDir.list();
        if (theCurCaptures == null) {
            return new String[0];
        }
        final HashMap<String, Object> theCaptureIDHash = new HashMap<String, Object>();
        Object theDummyObj = new Object();
        for (int i = 0; i < theCurCaptures.length; ++i) {
            theCaptureIDHash.put(theCurCaptures[i], theDummyObj);
        }
        this.mOwnerTableDbase.search(new SearchCriteria(){

            public boolean matches(String[] inDbaseRow) {
                theCaptureIDHash.remove(inDbaseRow[4]);
                return false;
            }
        });
        return theCaptureIDHash.keySet().toArray(new String[0]);
    }

    private void deleteUnrefdFiles() throws CaptureException {
        String[] theUnrefdFiles = this.getUnrefdCaptureNames();
        for (int i = 0; i < theUnrefdFiles.length; ++i) {
            File theFile = new File(this.mSavedCapturesDir, theUnrefdFiles[i]);
            theFile.delete();
        }
    }

    private void moveUnrefdCaptures() throws CaptureException {
        String[] theUnrefdFiles = this.getUnrefdCaptureNames();
        for (int i = 0; i < theUnrefdFiles.length; ++i) {
            String theCaptureIDString = theUnrefdFiles[i];
            File theSavedCaptureFile = new File(this.mSavedCapturesDir, theCaptureIDString);
            File theDeletedFile = new File(this.mDeletedCapturesDir, theCaptureIDString);
            if (!theDeletedFile.exists()) {
                try {
                    ResourceFileUtils.moveData(theSavedCaptureFile, theDeletedFile);
                    continue;
                }
                catch (ResourceException e) {
                    throw new CaptureException(e);
                }
            }
            theSavedCaptureFile.delete();
        }
    }

    private CaptureIDFixedAttrs getCaptureIDFixedAttrs(OwnedCaptureID inOwnedCaptureID) throws CaptureException {
        final String theExistingCaptureIDString = inOwnedCaptureID.toString();
        String[] theMatches = this.mOwnerTableDbase.search(new SearchCriteria(){

            public boolean matches(String[] inDbaseRow) {
                return inDbaseRow[4].equals(theExistingCaptureIDString);
            }
        });
        if (theMatches == null || theMatches.length < 1) {
            throw new CaptureException("rsrc.msg0339");
        }
        String[] theFirstMatchingRow = this.mOwnerTableDbase.query(theMatches[0]);
        return new CaptureIDFixedAttrs(theFirstMatchingRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAdd(String inEntryName, InstalledComponentID inInstalledComponentID, SnapshotID inSnapshotID, OwnedCaptureID inExistingOwnedCaptureID) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            File theNewFile = new File(this.mSavedCapturesDir, inExistingOwnedCaptureID.toString()).getAbsoluteFile();
            if (!theNewFile.exists()) {
                throw new CaptureException("rsrc.msg0340", new Object[]{theNewFile});
            }
            CaptureIDFixedAttrs theCaptureIDAttrs = this.getCaptureIDFixedAttrs(inExistingOwnedCaptureID);
            ObjectID theObjectID = new ObjectID(ResourceID.generateResourceID().toString());
            this.writeEntry(theObjectID, inEntryName, inInstalledComponentID, inSnapshotID, inExistingOwnedCaptureID, theCaptureIDAttrs.mCaptureTypeString, theCaptureIDAttrs.mLengthBytesString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntriesByComponent(InstalledComponentID inInstalledComponentID) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            final String theInstalledComponentIDString = inInstalledComponentID.toString();
            String[] theMatches = this.mOwnerTableDbase.search(new SearchCriteria(){

                public boolean matches(String[] inDbaseRow) {
                    return inDbaseRow[2].equals(theInstalledComponentIDString);
                }
            });
            this.deleteKeys(theMatches);
            this.moveUnrefdCaptures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntriesByName(final String inEntryName) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            String[] theMatches = this.mOwnerTableDbase.search(new SearchCriteria(){

                public boolean matches(String[] inDbaseRow) {
                    return SnapshotOwnerTable.this.namesEqual(inDbaseRow[1], inEntryName);
                }
            });
            this.deleteKeys(theMatches);
            this.moveUnrefdCaptures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotOwnerTableEntry[] queryByName(final String inEntryName) throws CaptureException {
        final Vector theMatchingOwnerTableEntries = new Vector();
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            this.mOwnerTableDbase.search(new SearchCriteria(){

                public boolean matches(String[] inDbaseRow) {
                    if (SnapshotOwnerTable.this.namesEqual(inDbaseRow[1], inEntryName)) {
                        String theCaptureIDString = inDbaseRow[4];
                        File theCaptureFile = new File(SnapshotOwnerTable.this.mSavedCapturesDir, theCaptureIDString);
                        if (!theCaptureFile.isFile()) {
                            String message = ROXMessageManager.messageAsString("rsrc.NONEXISTENT_SNAPSHOT", new Object[]{theCaptureIDString});
                            Logger.error(message, this);
                        } else {
                            theMatchingOwnerTableEntries.add(new SnapshotOwnerTableEntry(inDbaseRow[1], new InstalledComponentID(inDbaseRow[2]), new SnapshotID(inDbaseRow[3]), new OwnedCaptureID(theCaptureIDString), OwnedCaptureType.FACTORY.get(inDbaseRow[5]), Long.decode(inDbaseRow[6])));
                        }
                    }
                    return false;
                }
            });
        }
        return theMatchingOwnerTableEntries.toArray(new SnapshotOwnerTableEntry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OwnedCaptureType getOwnedCaptureContents(OwnedCaptureID inOwnedCaptureID, File inDstFile) throws CaptureException {
        SnapshotOwnerTable snapshotOwnerTable = this;
        synchronized (snapshotOwnerTable) {
            this.verifyTransacting();
            OwnedCaptureType theOwnedCaptureType = OwnedCaptureType.FACTORY.get(this.getCaptureIDFixedAttrs((OwnedCaptureID)inOwnedCaptureID).mCaptureTypeString);
            File theCaptureFile = this.getCaptureFileObject(inOwnedCaptureID);
            this.convertInternalFormatToFile(theCaptureFile, inDstFile);
            return theOwnedCaptureType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forTestOnly_IsServerReference(OwnedCaptureID inOwnedCaptureID) throws CaptureException {
        boolean bl;
        File theCaptureFile = this.getCaptureFileObject(inOwnedCaptureID);
        ZipFile theZipFile = new ZipFile(theCaptureFile);
        try {
            Enumeration<? extends ZipEntry> theEntries = theZipFile.entries();
            ZipEntry theZipEntry = theEntries.nextElement();
            String theEntryName = theZipEntry.getName();
            bl = theEntryName.startsWith(META_TAG);
        }
        catch (Throwable throwable) {
            try {
                theZipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
        theZipFile.close();
        return bl;
    }

    private class CaptureIDFixedAttrs {
        String mCaptureTypeString;
        String mLengthBytesString;

        CaptureIDFixedAttrs(String[] inRow) {
            this.mCaptureTypeString = inRow[5];
            this.mLengthBytesString = inRow[6];
        }
    }
}

