/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.capture;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.capture.ContentsTableEntry;
import com.raplix.rolloutexpress.resource.capture.OwnedCaptureType;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Vector;

public class SnapshotContentsTable
implements Messages {
    private static final String BACKUP_EXTENSION = "_backup";
    private final File mSnapshotContentsDir;

    public SnapshotContentsTable(ResourceSubsysImpl inCtx, File inSnapshotContentsDir) throws CaptureException {
        if (inCtx == null) {
            throw new CaptureException("rsrc.msg0322");
        }
        this.mSnapshotContentsDir = inSnapshotContentsDir.getAbsoluteFile();
        this.mSnapshotContentsDir.mkdirs();
        if (!inSnapshotContentsDir.isDirectory()) {
            throw new CaptureException("rsrc.msg0323", new Object[]{this.mSnapshotContentsDir.getAbsolutePath()});
        }
    }

    public synchronized void purgeOrphanedEntries(SnapshotID[] inSnapshotsToRetain) throws CaptureException {
        HashSet<File> theHash = new HashSet<File>();
        for (int i = 0; i < inSnapshotsToRetain.length; ++i) {
            File theFile = this.snapshotIDToFile(inSnapshotsToRetain[i]);
            theHash.add(theFile);
        }
        File[] theExistingSnapshotFiles = this.mSnapshotContentsDir.listFiles();
        if (theExistingSnapshotFiles == null) {
            return;
        }
        for (int i = 0; i < theExistingSnapshotFiles.length; ++i) {
            File theExistingSnapshot = theExistingSnapshotFiles[i];
            if (theHash.contains(theExistingSnapshot)) continue;
            if (!theExistingSnapshot.isFile()) {
                throw new CaptureException("rsrc.msg0325", new Object[]{theExistingSnapshot});
            }
            theExistingSnapshot.delete();
        }
    }

    public void forTestOnly_ClearTable() throws ResourceException {
        this.clearTable();
    }

    public synchronized void clearTable() throws ResourceException {
        ResourceFileUtils.deleteDirectory(this.mSnapshotContentsDir);
        this.mSnapshotContentsDir.mkdirs();
    }

    private File snapshotIDToFile(SnapshotID inSnapshotID) {
        String theFileName = inSnapshotID.toString();
        return new File(this.mSnapshotContentsDir, theFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(SnapshotID inSnapshotID, ContentsTableEntry[] inEntries) throws CaptureException {
        if (inSnapshotID == null) {
            throw new NullPointerException();
        }
        if (inEntries == null) {
            throw new NullPointerException();
        }
        String[][] theStringsArray = new String[inEntries.length][3];
        for (int i = 0; i < inEntries.length; ++i) {
            ContentsTableEntry theEntry = inEntries[i];
            theStringsArray[i] = new String[]{theEntry.getEntryName(), theEntry.getOwnedCaptureType().toString(), theEntry.getDisplayName()};
        }
        File theFile = this.snapshotIDToFile(inSnapshotID);
        try {
            File theBackup = null;
            if (theFile.exists()) {
                theBackup = new File(theFile.getAbsoluteFile().getParent(), theFile.getName() + BACKUP_EXTENSION);
                ResourceFileUtils.deleteDirectory(theBackup);
                ResourceFileUtils.moveData(theFile, theBackup);
            }
            try {
                ObjectOutputStream theOutStream = new ObjectOutputStream(new FileOutputStream(theFile));
                try {
                    theOutStream.writeObject(theStringsArray);
                }
                finally {
                    theOutStream.close();
                }
            }
            catch (IOException e) {
                try {
                    theFile.delete();
                    if (theBackup != null) {
                        ResourceFileUtils.moveData(theBackup, theFile);
                    }
                }
                catch (ResourceException e2) {
                    String message = ROXMessageManager.messageAsString("rsrc.SNAPSHOT_RECOVERY_FAILED", new Object[]{theFile.getName()});
                    Logger.error(message, e2, this);
                }
                throw new ResourceException(e);
            }
            if (theBackup != null) {
                theBackup.delete();
            }
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ContentsTableEntry[] get(SnapshotID inSnapshotID) throws CaptureException {
        File theFile = this.snapshotIDToFile(inSnapshotID);
        Vector<String[][]> theCallbackResult = new Vector<String[][]>();
        try {
            try {
                ObjectInputStream theInStream = new ObjectInputStream(new FileInputStream(theFile));
                try {
                    if (!theFile.isFile()) {
                        throw new ResourceException("rsrc.msg0324", new Object[]{inSnapshotID});
                    }
                    String[][] theStringsArray = (String[][])theInStream.readObject();
                    theCallbackResult.add(theStringsArray);
                }
                finally {
                    theInStream.close();
                }
            }
            catch (ClassNotFoundException e) {
                throw new ResourceException(e);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
        String[][] theStringsArray = (String[][])theCallbackResult.get(0);
        ContentsTableEntry[] theEntries = new ContentsTableEntry[theStringsArray.length];
        for (int i = 0; i < theStringsArray.length; ++i) {
            ContentsTableEntry theEntry;
            theEntries[i] = theEntry = new ContentsTableEntry(theStringsArray[i][0], OwnedCaptureType.FACTORY.get(theStringsArray[i][1]), theStringsArray[i].length < 3 ? null : theStringsArray[i][2]);
        }
        return theEntries;
    }

    public synchronized void delete(SnapshotID inSnapshotID) throws CaptureException {
        File theFile = this.snapshotIDToFile(inSnapshotID);
        try {
            if (!theFile.isFile()) {
                throw new ResourceException("rsrc.msg0325", new Object[]{inSnapshotID});
            }
            theFile.delete();
        }
        catch (ResourceException e) {
            throw new CaptureException(e);
        }
    }
}

