/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.capture;

import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class ServerReference
implements Serializable {
    private static final String FORMAT_TAG = "FORMAT_TAG";
    ResourceID mResourceID;
    String mRelPath;
    long mLength;
    byte[] mMD5Checksum;

    void toStream(ObjectOutputStream inOutStream) throws CaptureException {
        String[] theStrings = new String[]{FORMAT_TAG, this.mResourceID.toString(), this.mRelPath, Long.toString(this.mLength), ServerReference.bytesToString(this.mMD5Checksum)};
        try {
            inOutStream.writeObject(theStrings);
        }
        catch (IOException e) {
            throw new CaptureException("rsrc.msg0408", (Throwable)e);
        }
    }

    ServerReference(ObjectInputStream inInStream) throws CaptureException {
        String[] theStrings = null;
        try {
            theStrings = (String[])inInStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new CaptureException("rsrc.msg0409", (Throwable)e);
        }
        catch (IOException e) {
            throw new CaptureException("rsrc.msg0410", (Throwable)e);
        }
        if (theStrings.length != 5 || !theStrings[0].equals(FORMAT_TAG)) {
            throw new CaptureException("rsrc.msg0411");
        }
        this.mResourceID = new ResourceID(theStrings[1]);
        this.mRelPath = theStrings[2];
        this.mLength = Long.valueOf(theStrings[3]);
        this.mMD5Checksum = ServerReference.stringToBytes(theStrings[4]);
    }

    ServerReference(ResourceID inResourceID, String inRelPath, long inLength, byte[] inMD5Checksum) {
        this.mResourceID = inResourceID;
        this.mRelPath = inRelPath;
        this.mLength = inLength;
        this.mMD5Checksum = inMD5Checksum;
    }

    private static String bytesToString(byte[] inBytes) {
        StringBuffer theStringBuffer = new StringBuffer(inBytes.length);
        for (int i = 0; i < inBytes.length; ++i) {
            char theChar = (char)inBytes[i];
            theStringBuffer.append(theChar);
        }
        return theStringBuffer.toString();
    }

    private static byte[] stringToBytes(String inString) throws CaptureException {
        byte[] theBytes = new byte[inString.length()];
        boolean theByteIdx = false;
        for (int i = 0; i < inString.length(); ++i) {
            char theChar = inString.charAt(i);
            theBytes[i] = (byte)theChar;
        }
        return theBytes;
    }
}

