/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.capture;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.capture.Key;
import com.raplix.rolloutexpress.resource.capture.ServerReference;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;

public class ServerRefDbase
implements Messages {
    private static final int MAX_ENTRIES = 1000;
    public static final long MIN_SNAPSHOT_SIZE = 1500L;
    private File mDbaseFile;

    static ServerRefDbase makeServerRefDbase(File inDbaseFile) {
        return new ServerRefDbase(inDbaseFile);
    }

    private ServerRefDbase(File inDbaseFile) {
        this.mDbaseFile = inDbaseFile;
    }

    synchronized ServerReference get(byte[] inMD5Checksum, long inUncompressedLength) {
        ServerRefCollection theCollection = this.load();
        return theCollection.get(inMD5Checksum, inUncompressedLength);
    }

    /*
     * WARNING - void declaration
     */
    synchronized void addRefs(RsrcManifest inResourceManifest) throws CaptureException {
        Vector<ServerReference> theNewRefVector = new Vector<ServerReference>();
        try {
            ResourceID theResourceID = inResourceManifest.getResourceID();
            long theCapacity = inResourceManifest.getNumEntries() / 4L;
            if (theCapacity > 256L) {
                theCapacity = 256L;
            }
            theNewRefVector.ensureCapacity((int)theCapacity);
            SegIter theIter = SegIter.makeIter(Key.sKey, inResourceManifest);
        }
        catch (ResourceException e) {
            throw new CaptureException("rsrc.msg0406", (Throwable)e);
        }
        while (true) {
            void var3_3;
            boolean hasNext = false;
            SegEntry theEntry = null;
            try {
                void var4_8;
                hasNext = var4_8.hasMoreSubfiles();
                if (!hasNext) break;
                theEntry = var4_8.getNextSubfile();
            }
            catch (ResourceException e) {
                throw new CaptureException(e);
            }
            if (theEntry.getUncompressedFileSize() <= 1500L || theEntry.getFileMd5PerCompressionSetting() == null) continue;
            ServerReference theRef = new ServerReference((ResourceID)var3_3, theEntry.getRelPathWFwdSlashes(), theEntry.getUncompressedFileSize(), theEntry.getFileMd5PerCompressionSetting());
            theNewRefVector.add(theRef);
        }
        if (theNewRefVector.size() == 0) {
            return;
        }
        ServerReference[] theNewRefArray = theNewRefVector.toArray(new ServerReference[0]);
        ServerRefCollection theCollection = this.load();
        int theNumExcess = theCollection.size() + theNewRefArray.length - 1000;
        if (theNumExcess > 0) {
            theCollection.reduceLRU(theNumExcess);
        }
        theCollection.add(theNewRefArray);
        this.save(theCollection);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save(ServerRefCollection inCollection) throws CaptureException {
        this.mDbaseFile.delete();
        ObjectOutputStream theObjectOutStream = null;
        theObjectOutStream = new ObjectOutputStream(new FileOutputStream(this.mDbaseFile));
        theObjectOutStream.writeObject(inCollection);
        Object var5_3 = null;
        if (theObjectOutStream == null) return;
        try {
            theObjectOutStream.close();
            return;
        }
        catch (IOException e) {
            if (!Logger.isErrorEnabled(this)) return;
            Logger.error(ROXMessageManager.messageAsString("rsrc.SERVERREF_CLOSE_FAILED"), this);
        }
        return;
        {
            catch (Exception e) {
                throw new CaptureException("rsrc.msg0407", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (theObjectOutStream == null) throw throwable;
            try {
                theObjectOutStream.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!Logger.isErrorEnabled(this)) throw throwable;
                Logger.error(ROXMessageManager.messageAsString("rsrc.SERVERREF_CLOSE_FAILED"), this);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerRefCollection load() {
        ServerRefCollection theCollection;
        block7: {
            theCollection = null;
            if (this.mDbaseFile.exists()) {
                try {
                    ObjectInputStream theInStream = new ObjectInputStream(new FileInputStream(this.mDbaseFile));
                    try {
                        theCollection = (ServerRefCollection)theInStream.readObject();
                    }
                    finally {
                        theInStream.close();
                    }
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block7;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.SERVERREF_READ_FAILED"), this);
                }
            }
        }
        if (theCollection != null) {
            return theCollection;
        }
        this.mDbaseFile.delete();
        return new ServerRefCollection();
    }

    static class MD5WithLengthComparator
    implements Comparator,
    Serializable {
        MD5WithLengthComparator() {
        }

        public int compare(Object inA, Object inB) {
            MD5WithLength theMD5nLenA = (MD5WithLength)inA;
            MD5WithLength theMD5nLenB = (MD5WithLength)inB;
            if (theMD5nLenA.mLength < theMD5nLenB.mLength) {
                return -1;
            }
            if (theMD5nLenA.mLength > theMD5nLenB.mLength) {
                return 1;
            }
            byte[] theFirstMD5 = theMD5nLenA.mMD5Checksum;
            byte[] theSecondMD5 = theMD5nLenB.mMD5Checksum;
            int theSharedLength = theFirstMD5.length;
            if (theFirstMD5.length > theSecondMD5.length) {
                theSharedLength = theSecondMD5.length;
            }
            for (int i = 0; i < theSharedLength; ++i) {
                byte theFirstByte = theFirstMD5[i];
                byte theSecondByte = theSecondMD5[i];
                if (theFirstByte < theSecondByte) {
                    return -1;
                }
                if (theFirstByte <= theSecondByte) continue;
                return 1;
            }
            if (theFirstMD5.length < theSecondMD5.length) {
                return -1;
            }
            if (theFirstMD5.length > theSecondMD5.length) {
                return -1;
            }
            return 0;
        }
    }

    static class MD5WithLength
    implements Serializable {
        byte[] mMD5Checksum;
        long mLength;

        MD5WithLength(byte[] inMD5Checksum, long inLength) {
            this.mMD5Checksum = inMD5Checksum;
            this.mLength = inLength;
        }
    }

    static class ServerRefCollection
    implements Serializable {
        private LinkedList mOldestToNewestRefs = new LinkedList();
        private TreeMap mMD5ToServerRefHash = new TreeMap(new MD5WithLengthComparator());

        ServerRefCollection() {
        }

        int size() {
            return this.mOldestToNewestRefs.size();
        }

        void reduceLRU(int inNumToRemove) {
            int theNumToRemove = inNumToRemove;
            if (theNumToRemove >= this.size()) {
                this.mMD5ToServerRefHash.clear();
                this.mOldestToNewestRefs.clear();
                return;
            }
            while (inNumToRemove > 0) {
                ServerReference theRef = (ServerReference)this.mOldestToNewestRefs.get(0);
                this.mOldestToNewestRefs.remove(0);
                this.mMD5ToServerRefHash.remove(new MD5WithLength(theRef.mMD5Checksum, theRef.mLength));
                --inNumToRemove;
            }
        }

        void add(ServerReference[] inRefs) {
            for (int i = 0; i < inRefs.length; ++i) {
                ServerReference theRef = inRefs[i];
                this.mOldestToNewestRefs.add(theRef);
                this.mMD5ToServerRefHash.put(new MD5WithLength(theRef.mMD5Checksum, theRef.mLength), theRef);
            }
        }

        ServerReference get(byte[] inMD5Checksum, long inUncompressedLength) {
            return (ServerReference)this.mMD5ToServerRefHash.get(new MD5WithLength(inMD5Checksum, inUncompressedLength));
        }
    }
}

