/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.capture;

import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.util.minidb.SearchCriteria;
import com.raplix.util.minidb.WritableTable;
import java.io.File;
import java.io.IOException;

class FileDatabase {
    private final File mTableFile;
    private final int mNumColumns;
    private final int mKeyColumn;
    private WritableTable mDbase;

    FileDatabase(File inFile, int inColumns, int inKeyColumn) throws CaptureException {
        this.mTableFile = inFile.getAbsoluteFile();
        this.mNumColumns = inColumns;
        this.mKeyColumn = inKeyColumn;
        File theParentDir = this.mTableFile.getParentFile().getAbsoluteFile();
        if (!theParentDir.exists()) {
            theParentDir.mkdirs();
        }
        if (!theParentDir.isDirectory()) {
            throw new CaptureException("rsrc.msg0326", new Object[]{theParentDir});
        }
        if (!this.mTableFile.exists()) {
            try {
                this.mTableFile.createNewFile();
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        } else if (!this.mTableFile.isFile()) {
            throw new CaptureException("rsrc.msg0327", new Object[]{this.mTableFile});
        }
    }

    int getNumColumns() {
        return this.mNumColumns;
    }

    File getFile() {
        return this.mTableFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws CaptureException {
        if (!this.mTableFile.isFile()) {
            throw new CaptureException("rsrc.msg0328", new Object[]{this.mTableFile});
        }
        FileDatabase fileDatabase = this;
        synchronized (fileDatabase) {
            this.mDbase = new WritableTable(this.mTableFile.getAbsolutePath(), this.mNumColumns, this.mKeyColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws CaptureException {
        if (!this.mTableFile.isFile()) {
            throw new CaptureException("rsrc.msg0329", new Object[]{this.mTableFile});
        }
        FileDatabase fileDatabase = this;
        synchronized (fileDatabase) {
            try {
                this.mDbase.commit();
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forTestOnly_Clear() throws CaptureException {
        FileDatabase fileDatabase = this;
        synchronized (fileDatabase) {
            try {
                this.mTableFile.delete();
                this.mTableFile.createNewFile();
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(String[] inRow) throws CaptureException {
        if (inRow.length != this.mNumColumns) {
            throw new CaptureException("rsrc.msg0330");
        }
        FileDatabase fileDatabase = this;
        synchronized (fileDatabase) {
            try {
                this.mDbase.insert(inRow);
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
    }

    String[] search(SearchCriteria inCriteria) throws CaptureException {
        FileDatabase fileDatabase = this;
        synchronized (fileDatabase) {
            try {
                return this.mDbase.search(inCriteria);
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
        }
    }

    String[] query(String inKey) throws CaptureException {
        try {
            return this.mDbase.query(inKey);
        }
        catch (IOException e) {
            throw new CaptureException(e);
        }
    }

    void forceDelete(String inKey) throws CaptureException {
        try {
            this.mDbase.forceDelete(inKey);
        }
        catch (IOException e) {
            throw new CaptureException(e);
        }
    }
}

