/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.SingleObjectErrorMapper;
import com.raplix.rolloutexpress.persist.query.SingleObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;

public class SingleRsrcInfoQuery
extends SingleObjectQueryImpl {
    private static final ResourceTable RT = new ResourceTable("rsrcT");

    public static SingleRsrcInfoQuery bySpec(ResourceSpec inSpec, String inVersion) {
        return SingleRsrcInfoQuery.byName(inSpec.getName(), inVersion, null);
    }

    static SingleRsrcInfoQuery byName(String inName, String inVersion, ResourceID inCustomParentID) {
        AndExp cond = ResourceTable.and(ResourceTable.equals(SingleRsrcInfoQuery.RT.Name, inName), ResourceTable.and(ResourceTable.equals(SingleRsrcInfoQuery.RT.CustomParentID, inCustomParentID), RT.matchesVersion(inVersion)));
        String cacheName = null;
        CacheKey cacheKey = null;
        if (inVersion != null) {
            cacheName = "byFullNameAndVersion";
            cacheKey = SingleVersionedObjectByFullNameCache.createKey(inCustomParentID, inName, inVersion);
        }
        SingleObjectErrorMapper mapper = SingleRsrcInfoQuery.getByNameErrorMapper(inName, inVersion);
        return new SingleRsrcInfoQuery(cond, cacheName, cacheKey, mapper);
    }

    private SingleRsrcInfoQuery(ConditionalExpression inCond, String cacheName, CacheKey cacheKey, SingleObjectErrorMapper errorMapper) {
        super(RT, inCond, cacheName, cacheKey, errorMapper);
    }

    SingleRsrcInfoQuery(ResourceID inID) {
        super((Table)RT, inID);
    }

    public RsrcInfo select() throws RPCException, PersistenceManagerException {
        return new RsrcInfo(this.selectResource());
    }

    Resource selectResource() throws RPCException, PersistenceManagerException {
        return (Resource)this.selectBean();
    }
}

