/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PMSQLException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.TooManyResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.VersionedTable;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.MetaDbase;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.SingleRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import java.io.File;
import java.util.ArrayList;

class SQLMetaDbase
extends MetaDbase {
    private Database mDatabase = PersistenceManager.getInstance().getDefaultDatabase();

    SQLMetaDbase(ResourceSubsysImpl inRsrcCtx, Application inApplication, DirPath inAbsRepoRoot) throws ResourceException {
        super(inRsrcCtx, inApplication, inAbsRepoRoot);
    }

    public long getResourceDataBytesInDir(File inDir) {
        return ResourceFileUtils.getBytesInDir(inDir);
    }

    Resource retrieveFirstVersion(ResourceSpec inResourceSpec) throws ResourcePersistenceException {
        try {
            return SingleRsrcInfoQuery.byName(inResourceSpec.getName(), VersionNumber.ROOT.getAsString(), inResourceSpec.getCustomParentID()).selectResource();
        }
        catch (NoResultsFoundException e) {
            return null;
        }
        catch (TooManyResultsFoundException e) {
            throw new ResourcePersistenceException("rsrc.msg0111");
        }
        catch (PersistenceManagerException e) {
            Object[] theSubs = new Object[]{inResourceSpec};
            throw new ResourcePersistenceException("rsrc.msg0110", (Throwable)e, theSubs);
        }
        catch (RPCException e) {
            Object[] theSubs = new Object[]{inResourceSpec};
            throw new ResourcePersistenceException("rsrc.msg0110", (Throwable)e, theSubs);
        }
    }

    public Resource get(ResourceSpec inResourceSpec, VersionNumber inVersion, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        try {
            return SingleRsrcInfoQuery.byName(inResourceSpec.getName(), inVersion.getAsString(), inResourceSpec.getCustomParentID()).selectResource();
        }
        catch (NoResultsFoundException e) {
            Object[] theSubs = new Object[]{inResourceSpec, inVersion};
            throw new ResourceNotLocalException("rsrc.msg0114", theSubs);
        }
        catch (TooManyResultsFoundException e) {
            throw new ResourcePersistenceException("rsrc.msg0113");
        }
        catch (Exception e) {
            Object[] theSubs = new Object[]{inResourceSpec, inVersion};
            throw new ResourcePersistenceException("rsrc.msg0112", (Throwable)e, theSubs);
        }
    }

    public Resource get(ResourceID inResourceID, PushID inPushID) throws ResourcePersistenceException, ResourceNotLocalException {
        try {
            return inResourceID.getByIDQuery().selectResource();
        }
        catch (NoResultsFoundException e) {
            Object[] theSubs = new Object[]{inResourceID};
            throw new ResourceNotLocalException("rsrc.msg0117", theSubs);
        }
        catch (TooManyResultsFoundException e) {
            throw new ResourcePersistenceException("rsrc.msg0116");
        }
        catch (Exception e) {
            Object[] theSubs = new Object[]{inResourceID};
            throw new ResourcePersistenceException("rsrc.msg0115", (Throwable)e, theSubs);
        }
    }

    public synchronized void add(Resource inResource, VersionedSaveContext inVersionedSaveContext) throws ResourcePersistenceException {
        try {
            if (inVersionedSaveContext != null) {
                inVersionedSaveContext.setLatestVersion(inResource);
            }
            inResource.save(inVersionedSaveContext);
        }
        catch (PMSQLException e) {
            throw new ResourcePersistenceException("rsrc.msg0121", (Throwable)e);
        }
        catch (PersistenceManagerException e) {
            throw new ResourcePersistenceException("rsrc.msg0120", (Throwable)e);
        }
    }

    Resource getMostRecentVersionOnMS(ResourceSpec inResourceSpec) throws ResourcePersistenceException {
        Resource theResult = null;
        try {
            Resource theFirstVersion = this.retrieveFirstVersion(inResourceSpec);
            if (theFirstVersion == null) {
                return null;
            }
            theResult = (Resource)theFirstVersion.retrieveLatest();
        }
        catch (PMSQLException e) {
            Object[] theSubs = new Object[]{inResourceSpec};
            throw new ResourcePersistenceException("rsrc.msg0123", (Throwable)e, theSubs);
        }
        catch (PersistenceManagerException e) {
            Object[] theSubs = new Object[]{inResourceSpec};
            throw new ResourcePersistenceException("rsrc.msg0123", (Throwable)e, theSubs);
        }
        return theResult;
    }

    void startupResources() throws ResourceException {
    }

    synchronized Resource grabVersion(ResourceSpec inResourceSpec, long inSize, String inType, HostID inSourceHostID, String inSourcePath, boolean inConfigurable, boolean inHierarchical, boolean inHasPermissions, HostSetID inPlatform, VersionedSaveContext inVersionedSaveContext, CategoryIDSet inCategoryIDSet, PluginID inPluginID) throws ResourceException {
        int thePrevKnownGreatestVersion = 0;
        Resource theResource = this.getMostRecentVersionOnMS(inResourceSpec);
        if (theResource == null) {
            thePrevKnownGreatestVersion = -1;
            theResource = new Resource(inResourceSpec, inSize, inType, inSourceHostID, inSourcePath, inConfigurable, inHierarchical, inHasPermissions, inPlatform, inPluginID);
        } else {
            thePrevKnownGreatestVersion = theResource.getVersionNumber().getSingleVersionNumber();
            theResource.adjust(inType, inSourceHostID, inSourcePath, inConfigurable, inHierarchical, inHasPermissions, inPlatform, inPluginID);
        }
        theResource.setCategories(inCategoryIDSet);
        if (inVersionedSaveContext != null) {
            inVersionedSaveContext = (VersionedSaveContext)inVersionedSaveContext.clone();
        }
        while (true) {
            try {
                this.add(theResource, inVersionedSaveContext);
            }
            catch (ResourceException e) {
                theResource = this.getMostRecentVersionOnMS(inResourceSpec);
                if (theResource == null) {
                    throw new ResourcePersistenceException("rsrc.msg0125", (Throwable)e);
                }
                int theNewMostRecentVersion = theResource.getVersionNumber().getSingleVersionNumber();
                if (theNewMostRecentVersion <= thePrevKnownGreatestVersion) {
                    throw new ResourcePersistenceException("rsrc.msg0125", (Throwable)e);
                }
                thePrevKnownGreatestVersion = theNewMostRecentVersion;
                theResource.adjust(inType, inSourceHostID, inSourcePath, inConfigurable, inHierarchical, inHasPermissions, inPlatform, inPluginID);
                continue;
            }
            break;
        }
        return theResource;
    }

    public ArrayList getAllResIDs() throws ResourcePersistenceException {
        ResourceTable theTable = new ResourceTable("a");
        PersistentBean[] theResources = null;
        try {
            theResources = QueryBuilder.executeMultiResult(QueryBuilder.select(theTable.allColumns(), QueryBuilder.tList(theTable)), theTable);
        }
        catch (PMSQLException ex) {
            throw new ResourcePersistenceException("rsrc.msg0118", (Throwable)ex);
        }
        catch (PersistenceManagerException pmex) {
            throw new ResourcePersistenceException("rsrc.msg0118", (Throwable)pmex);
        }
        ArrayList<ResourceID> theResourceArrayList = new ArrayList<ResourceID>();
        theResourceArrayList.ensureCapacity(theResources.length);
        for (int i = 0; i < theResources.length; ++i) {
            Resource theNextResource = (Resource)theResources[i];
            if (!this.verifyDataExists(theNextResource)) continue;
            theResourceArrayList.add(theNextResource.getResourceID());
        }
        return theResourceArrayList;
    }

    void removeFromLRU(Resource inResource) throws ResourceException {
    }

    void setAsLRU(Resource inResource) throws ResourceException {
    }

    boolean clearSpace(long inIncrAmountNeeded) throws ResourceException {
        throw new ResourceException("rsrc.msg0197");
    }

    void removeMetaData(Resource inResource) throws ResourceException, ResourcePersistenceException {
        throw new ResourceException("rsrc.msg0198");
    }

    public Resource getNextHighestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        Resource theFirstVersion = this.retrieveFirstVersion(inResourceSpec);
        if (theFirstVersion == null) {
            return null;
        }
        ObjectID theRootID = theFirstVersion.getRootID();
        ResourceTable vTable = ResourceTable.DEFAULT;
        VersionedTable innerTable = (VersionedTable)vTable.instance("theInner");
        Resource theResult = null;
        try {
            theResult = (Resource)ResourceTable.executeSingleResult(ResourceTable.select(vTable.allColumns(), ResourceTable.tList(vTable), ResourceTable.where(ResourceTable.and(ResourceTable.equals(vTable.RootID, theRootID), ResourceTable.equals((ColumnNode)vTable.Version, VersionedTable.select(VersionedTable.sList(VersionedTable.min(innerTable.Version)), VersionedTable.tList(innerTable), VersionedTable.where(VersionedTable.and(VersionedTable.equals(innerTable.RootID, theRootID), VersionedTable.greaterThan(innerTable.Version, inVersionNumber.getSingleVersionNumber())))))))), vTable);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
        return theResult;
    }

    public Resource getNextLowestVersion(ResourceSpec inResourceSpec, VersionNumber inVersionNumber) throws ResourceException {
        Resource theFirstVersion = this.retrieveFirstVersion(inResourceSpec);
        if (theFirstVersion == null) {
            return null;
        }
        ObjectID theRootID = theFirstVersion.getRootID();
        ResourceTable vTable = ResourceTable.DEFAULT;
        VersionedTable innerTable = (VersionedTable)vTable.instance("theInner");
        Resource theResult = null;
        try {
            theResult = (Resource)ResourceTable.executeSingleResult(ResourceTable.select(vTable.allColumns(), ResourceTable.tList(vTable), ResourceTable.where(ResourceTable.and(ResourceTable.equals(vTable.RootID, theRootID), ResourceTable.equals((ColumnNode)vTable.Version, VersionedTable.select(VersionedTable.sList(VersionedTable.max(innerTable.Version)), VersionedTable.tList(innerTable), VersionedTable.where(VersionedTable.and(VersionedTable.equals(innerTable.RootID, theRootID), VersionedTable.lessThan(innerTable.Version, inVersionNumber.getSingleVersionNumber())))))))), vTable);
        }
        catch (PersistenceManagerException e) {
            throw new ResourceException(e);
        }
        return theResult;
    }
}

