/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.config.HostUpdateManager;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.AddrGroup;
import com.raplix.rolloutexpress.resource.Key;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.NodePushStatus;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.PushParams;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceProcess;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RouteTree;
import com.raplix.rolloutexpress.resource.RsrcDirLayout;
import com.raplix.rolloutexpress.resource.RsrcGroup;
import com.raplix.rolloutexpress.resource.TimedSequence;
import com.raplix.rolloutexpress.resource.VersionMap;
import com.raplix.rolloutexpress.resource.diffdeploy.HostPathResource;
import com.raplix.rolloutexpress.resource.diffdeploy.ResPath;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLocalException;
import com.raplix.rolloutexpress.resource.exception.ResourceNotLockableException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.exception.ResourceProcessException;
import com.raplix.rolloutexpress.resource.exception.ResourcePushFinishedWithErrorsException;
import com.raplix.rolloutexpress.resource.exception.ResourceRouteException;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SegEntry;
import com.raplix.rolloutexpress.resource.packageformat.SegIter;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceMemixUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBSubsystem;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.threads.SafeThread;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class RsrcPushImpl
implements RPCSerializable,
Messages {
    private long mUpstreamStatusRetrySecs;
    private long mUpstreamMaxUpdateAttemptSecs;
    private transient PushExec mPushExec = null;
    private transient ResourceSubsysImpl mRsrcCtx = null;
    private volatile transient int mNextAddrIdx = 0;
    private volatile transient boolean mResetCount = false;
    private volatile transient boolean mDisposing = false;
    private transient boolean mPushedAtLeastOnce = false;
    private transient StatusReceived mStatusReceived = new StatusReceived();
    private transient File mPushVirtualDir = null;
    private PushParams mPushParams;
    private RoxAddress mParentPushAddr = null;
    private RouteTree mRouteTree = null;
    private ProcessMap mProcesses = new ProcessMap();
    private boolean mForTestOnly_NeverComplete = false;
    private boolean mForTestOnly_GuaranteeOneFailure = false;
    private int mForTestOnly_ErrorCode = 2;
    private TimedSequence mTimedSequence = null;
    private HostID mDeployHostID;

    RsrcPushImpl() {
    }

    public boolean getIsSimulated() {
        return this.mPushParams.mIsSimulated;
    }

    public VersionMap getFwdDeletionMap() {
        return this.mPushParams.mFwdDeletionMap;
    }

    public Resource getResourceIfVirtual(ResourceID inResourceID) throws ResourceNotLocalException {
        PushParams.OneRsrc theOneRsrc = this.mPushParams.getOneRsrc(inResourceID);
        if (theOneRsrc != null && (this.mPushParams.mIsSimulated || !theOneRsrc.isActualDuringActualPush())) {
            return theOneRsrc.mResource;
        }
        return null;
    }

    public Resource getResourceIfVirtual(ResourceSpec inResourceSpec, VersionNumber inVersion) throws ResourceNotLocalException {
        PushParams.OneRsrcsIter theIter = this.mPushParams.getOneRsrcsIter();
        while (theIter.hasNext()) {
            PushParams.OneRsrc thePRD = theIter.next();
            Resource theResource = thePRD.mResource;
            if (!theResource.getResourceSpec().equals(inResourceSpec) || !theResource.getVersionNumber().equals(inVersion)) continue;
            return this.mPushParams.mIsSimulated || !thePRD.isActualDuringActualPush() ? theResource : null;
        }
        return null;
    }

    public boolean includesNonVirtualResource(ResourceSpec inResourceSpec, VersionNumber inVersion) {
        if (this.mPushParams.mIsSimulated) {
            return false;
        }
        PushParams.OneRsrcsIter theIter = this.mPushParams.getOneRsrcsIter();
        while (theIter.hasNext()) {
            PushParams.OneRsrc thePRD = theIter.next();
            Resource theResource = thePRD.mResource;
            if (!theResource.getResourceSpec().equals(inResourceSpec) || !theResource.getVersionNumber().equals(inVersion)) continue;
            return thePRD.isActualDuringActualPush();
        }
        return false;
    }

    public String getDiffSuppressedPath(ResourceID inResourceID) {
        PushParams.OneRsrc theOneRsrc = this.mPushParams.getOneRsrc(inResourceID);
        return theOneRsrc == null ? null : theOneRsrc.getKnownPreviousDeployPath();
    }

    RsrcManifest getVirtualManifest(ResourceID inResourceID) throws ResourceException {
        if (this.getResourceIfVirtual(inResourceID) == null) {
            return null;
        }
        return RsrcManifest.makeVirtualManifest(Key.sKey, inResourceID, this.getVirtualRsrcDir(inResourceID).getAbsolutePath() + "/");
    }

    File getVirtualRsrcDir(ResourceID inResourceID) {
        return RsrcPushImpl.calcRsrcVirtualDir(this.getVirtualPushDir(), inResourceID);
    }

    static File calcRsrcVirtualDir(PushID inPushID, ResourceSubsysImpl inCtx, ResourceID inResourceID) {
        return RsrcPushImpl.calcRsrcVirtualDir(RsrcPushImpl.calcPushVirtualDir(inPushID, inCtx), inResourceID);
    }

    private static File calcRsrcVirtualDir(File inVirtualPushDir, ResourceID inResourceID) {
        return new File(inVirtualPushDir, inResourceID.toString());
    }

    private File getVirtualPushDir() {
        if (this.mPushVirtualDir == null) {
            this.mPushVirtualDir = RsrcPushImpl.calcPushVirtualDir(this.mPushParams.mPushID, this.mRsrcCtx);
        }
        return this.mPushVirtualDir;
    }

    static File calcPushVirtualDir(PushID inPushID, ResourceSubsysImpl inCtx) {
        return new File(RsrcDirLayout.getVirtualResourceDir(inCtx), inPushID.toString());
    }

    void externalize(ResourceID inResourceID, SessionCommand inMemixSession, File inHierarchyRoot) throws ResourceException {
        if (!this.getIsSimulated()) {
            throw new ResourceException("rsrc.msg0255");
        }
        RsrcManifest theRsrcManifest = this.getVirtualManifest(inResourceID);
        SegIter theSegIter = SegIter.makeIter(Key.sKey, theRsrcManifest);
        while (theSegIter.hasMoreSubfiles()) {
            SegEntry theEntry = theSegIter.getNextSubfile();
            String theFileString = inHierarchyRoot.getAbsolutePath();
            String theStrippedName = ResourceParser.stripRoot(theEntry.getRelPathWFwdSlashes());
            if (theStrippedName != null) {
                theFileString = theFileString + File.separator + theStrippedName;
            }
            theFileString = ResourceStringUtils.toNativePath(theFileString);
            File theSubFile = new File(theFileString);
            if (inMemixSession == null) continue;
            if (theEntry.getType().equals(SubnodeType.FILE)) {
                try {
                    ResourceMemixUtils.removeDirOrFile(inMemixSession, theSubFile);
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
            }
            ResourceMemixUtils.createFile(inMemixSession, theSubFile, theEntry.getType(), theEntry.getUncompressedFileSize(), theEntry.getTime());
        }
    }

    public RsrcPushImpl(RsrcGroup inRsrcGroup, AddrGroup inAddrGroup, ResourceSubsystem inRsrcCtx, boolean inIsSimulated, HostID inDeployHostID) throws ResourceNotLockableException, ResourcePersistenceException, ResourceNotLocalException, ResourceRouteException, ResourceException {
        this.mPushParams = new PushParams(inIsSimulated);
        this.initServerPush(inRsrcGroup, inAddrGroup, inRsrcCtx, inDeployHostID);
        this.constructRouteTree(inAddrGroup);
        this.finishInit(inRsrcCtx.getImpl());
    }

    private boolean getNeedResourceLocks() {
        return this.mRsrcCtx.isServer() || !this.getIsSimulated();
    }

    private void initServerPush(RsrcGroup inRsrcGroup, AddrGroup inAddrGroup, ResourceSubsystem inRsrcCtx, HostID inDeployHostID) throws ResourceException {
        this.mDeployHostID = inDeployHostID;
        if (inDeployHostID != null && inAddrGroup.size() != 1) {
            throw new IllegalStateException();
        }
        try {
            this.mUpstreamStatusRetrySecs = inRsrcCtx.getConfigUpstreamStatusRetryInterval();
            this.mUpstreamMaxUpdateAttemptSecs = inRsrcCtx.getConfigUpstreamStatusResendTimeout();
        }
        catch (ConfigurationException e) {
            throw new ResourceException(e);
        }
        this.mRsrcCtx = inRsrcCtx.getImpl();
        Application theApplication = this.mRsrcCtx.getApplication();
        InstallDBSubsystem theInstallDBSubsystem = null;
        try {
            theInstallDBSubsystem = theApplication.getInstallDBSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw new ResourceRouteException("rsrc.msg0103");
        }
        int theNumRsrcs = inRsrcGroup.size();
        for (int i = 0; i < theNumRsrcs; ++i) {
            ResPath theResPath = inRsrcGroup.getResPath(i);
            ResourceID theResourceID = theResPath.getResourceID();
            final Resource theResource = this.mRsrcCtx.getResource(theResourceID, null);
            if (theResource == null) {
                Object[] theSubs = new Object[]{theResourceID};
                throw new ResourceNotLocalException("rsrc.msg0104", theSubs);
            }
            ResourceID thePrevInstalledResID = null;
            VersionNumber thePrevInstalledVers = null;
            String theDeployPath = theResPath.getDeployPath();
            if (theDeployPath != null) {
                if (this.mDeployHostID == null) {
                    throw new IllegalStateException();
                }
                String theUniversalDeployPath = InstalledComponentRef.toUniversalPath(theDeployPath);
                thePrevInstalledResID = HostPathResource.queryInstalledResource(this.mDeployHostID, theUniversalDeployPath);
                if (thePrevInstalledResID == null && !theDeployPath.equals(theUniversalDeployPath)) {
                    thePrevInstalledResID = HostPathResource.queryInstalledResource(this.mDeployHostID, theDeployPath);
                }
                if (thePrevInstalledResID != null) {
                    try {
                        thePrevInstalledVers = thePrevInstalledResID.getByIDQuery().select().getVersionNumber();
                    }
                    catch (PersistenceManagerException e) {
                        MiscUtils.resourceThrow(e);
                    }
                    catch (RPCException e) {
                        MiscUtils.resourceThrow(e);
                    }
                }
            }
            if (theResourceID.equals(thePrevInstalledResID)) {
                PushParams.OneRsrc theOneRsrc = this.mPushParams.getOneRsrc(theResourceID);
                if (theOneRsrc != null && theOneRsrc.isActualDuringActualPush()) continue;
                this.mPushParams.add(theResource, theDeployPath, thePrevInstalledVers, this.mRsrcCtx);
                continue;
            }
            this.mPushParams.add(theResource, null, thePrevInstalledVers, this.mRsrcCtx);
            ResourceID thePrevInstResIDwMatchingSpec = thePrevInstalledResID;
            if (thePrevInstResIDwMatchingSpec != null) {
                ResourceSpec thePrevSpec = this.mRsrcCtx.getResource(thePrevInstalledResID, null).getResourceSpec();
                if (!theResource.getResourceSpec().equals(thePrevSpec)) {
                    thePrevInstResIDwMatchingSpec = null;
                }
            }
            final ResourceID theFinalPrevInstalledResID = thePrevInstResIDwMatchingSpec;
            new ResourceAccessor(this.mRsrcCtx, null){

                public Object innerAccess() throws ResourceException {
                    RsrcManifest thePrevInstalledManifest = null;
                    if (theFinalPrevInstalledResID != null) {
                        thePrevInstalledManifest = this.getManifest(theFinalPrevInstalledResID, null);
                    }
                    RsrcPushImpl.this.addBackRefs(theResource, this, thePrevInstalledManifest);
                    return null;
                }
            }.access();
        }
    }

    VersionNumber getPreviousResourceVersion(ResourceID inResourceID) {
        PushParams.OneRsrc theOneRsrc = this.mPushParams.getOneRsrc(inResourceID);
        return theOneRsrc == null ? null : theOneRsrc.getPrevVersion();
    }

    private void addBackRefs(Resource inResource, ResourceAccessor inAccessor, RsrcManifest inPrevInstalledManifest) throws ResourceException {
        ResourceID thePrevInstalledResID;
        RsrcManifest theManifest = inAccessor.getManifest(inResource.getResourceID(), null);
        SegIter theIter = SegIter.makeIter(Key.sKey, theManifest);
        ResourceID resourceID = thePrevInstalledResID = inPrevInstalledManifest != null ? inPrevInstalledManifest.getResourceID() : null;
        while (theIter.hasMoreSubfilesWBackRefs()) {
            SegEntry theResEntry;
            Resource theReferencedResource;
            VersionNumber theFwdMappedVers;
            SegEntry theEntry = theIter.getNextSubfileWBackRef();
            VersionNumber theBackRef = theEntry.getBackRef();
            if (theBackRef == null) {
                MiscUtils.throwUPE(5072146L);
            }
            if ((theFwdMappedVers = this.mPushParams.mFwdDeletionMap.get(inResource.getResourceSpec(), theBackRef)) != null) {
                theBackRef = theFwdMappedVers;
                theReferencedResource = this.mRsrcCtx.getResource(inResource.getResourceSpec(), theBackRef, null);
            } else {
                try {
                    theReferencedResource = this.mRsrcCtx.getResource(inResource.getResourceSpec(), theBackRef, null);
                }
                catch (ResourceNotLocalException e) {
                    theReferencedResource = this.mRsrcCtx.getNextHighestVersion(inResource.getResourceSpec(), theBackRef);
                    if (!theReferencedResource.getVersionNumber().isLessThan(inResource.getVersionNumber())) {
                        throw new ResourceException("rsrc.msg0482", new Object[]{inResource});
                    }
                    this.mPushParams.mFwdDeletionMap.set(inResource.getResourceSpec(), theBackRef, theReferencedResource.getVersionNumber());
                    theBackRef = theReferencedResource.getVersionNumber();
                }
            }
            ResourceID theReferencedResourceID = theReferencedResource.getResourceID();
            boolean isAlreadyThere = false;
            if (theReferencedResourceID.equals(thePrevInstalledResID)) {
                isAlreadyThere = true;
            } else if (inPrevInstalledManifest != null && (theResEntry = inPrevInstalledManifest.getFirstClusterSegEntry(Key.sKey, theEntry.getRelPathWFwdSlashes())) != null) {
                isAlreadyThere = theBackRef.equals(theResEntry.getBackRef());
            }
            if (isAlreadyThere) continue;
            this.mPushParams.add(theReferencedResource, this.mRsrcCtx);
        }
    }

    void forTestOnly_SetRoute(RoxAddress[] inRoute) throws ResourceException {
        this.integrateRoute(inRoute);
        this.finishTree();
    }

    void forTestOnly_SetDisposeSynchronous() {
        this.mPushParams.mForTestOnly_DisposeSync = true;
    }

    private void constructRouteTree(AddrGroup inAddrGroup) throws ResourceRouteException {
        HostUpdateManager theHostUpdateMgr = null;
        try {
            theHostUpdateMgr = this.mRsrcCtx.getApplication().getNetSubsystem().getTransport().getHostUpdateManager();
        }
        catch (SetupException e) {
            throw new ResourceRouteException("rsrc.msg0105");
        }
        RoxAddress theLocalAddress = this.mRsrcCtx.getApplication().getLocalNodeAddress();
        this.mRouteTree = new RouteTree(theLocalAddress);
        int theNumAddrs = inAddrGroup.size();
        for (int theAddrIdx = 0; theAddrIdx < theNumAddrs; ++theAddrIdx) {
            RoxAddress theAddress = inAddrGroup.get(theAddrIdx);
            RoxAddress[] theRoute = null;
            try {
                theRoute = theHostUpdateMgr.getRouteTo(theAddress);
                this.integrateRoute(theRoute);
                continue;
            }
            catch (TransportConfigException e) {
                throw new ResourceRouteException("rsrc.msg0106", (Throwable)e, new Object[]{theAddress});
            }
        }
    }

    private void integrateRoute(RoxAddress[] inRoute) throws ResourceRouteException {
        if (inRoute == null || inRoute.length == 0) {
            throw new ResourceRouteException("rsrc.msg0432");
        }
        this.mRouteTree.integrate(inRoute);
    }

    public void addProcess(ResourceProcess inProcess, ResourceID inResourceID) throws ResourceException {
        this.mProcesses.addProcess(inResourceID, inProcess);
    }

    void beforeResourceExtern(ResourceID inResourceID, File inResourceDstRoot) throws ResourceProcessException {
        Vector theProcesses = this.mProcesses.getAllProcessesToCall(inResourceID);
        if (theProcesses == null) {
            return;
        }
        Iterator theIter = theProcesses.iterator();
        while (theIter.hasNext()) {
            ResourceProcess theProcess = (ResourceProcess)theIter.next();
            theProcess.beforeResourceExtern(inResourceID, inResourceDstRoot);
        }
    }

    public void afterEnclosingDirCreations(ResourceID inResourceID, File inResourceDstRoot, File inEnclosingDir) throws ResourceProcessException {
        Vector theProcesses = this.mProcesses.getAllProcessesToCall(inResourceID);
        if (theProcesses == null) {
            return;
        }
        Iterator theIter = theProcesses.iterator();
        while (theIter.hasNext()) {
            ResourceProcess theProcess = (ResourceProcess)theIter.next();
            theProcess.afterEnclosingDirCreations(inResourceID, inResourceDstRoot, inEnclosingDir);
        }
    }

    public void afterResourceSubFileExternBottomUp(ResourceID inResourceID, File inResourceDstRoot, RsrcManifest inResourceManifest, NodePerms inGlobalOverridePerms, SessionCommand inMemixSession) throws ResourceException {
        if (!inResourceManifest.getResourceID().equals(inResourceID)) {
            throw new ResourceProcessException("rsrc.msg0301");
        }
        Vector theProcesses = this.mProcesses.getAllProcessesToCall(inResourceID);
        ResourceSpec theResourceSpec = null;
        try {
            theResourceSpec = this.mRsrcCtx.getResource(inResourceID, this.getPushID()).getResourceSpec();
        }
        catch (ResourceNotLocalException e) {
            try {
                theResourceSpec = this.mRsrcCtx.serverGetRsrcInfo(inResourceID).getResourceSpec();
            }
            catch (RPCException e1) {
                throw new ResourceException(e1);
            }
        }
        HashSet<VersionNumber> theIncludedVersions = new HashSet<VersionNumber>();
        PushParams.OneRsrcsIter theOneRsrcIter = this.mPushParams.getOneRsrcsIter();
        while (theOneRsrcIter.hasNext()) {
            Resource theResource;
            PushParams.OneRsrc theOneRsrc = theOneRsrcIter.next();
            if (!theOneRsrc.isActualDuringActualPush() || !(theResource = theOneRsrc.mResource).getResourceSpec().equals(theResourceSpec)) continue;
            theIncludedVersions.add(theResource.getVersionNumber());
        }
        NodePerms theDefaultOverriddenPerms = null;
        if (inGlobalOverridePerms != null) {
            theDefaultOverriddenPerms = this.mRsrcCtx.createDefaultNodePerms();
            if (theDefaultOverriddenPerms == null) {
                theDefaultOverriddenPerms = PlatformPermissionFactory.getInstance().createDefaultNodePerms();
            }
            theDefaultOverriddenPerms.integrateValidFields(inGlobalOverridePerms);
        }
        String theDstFilePath = inResourceDstRoot.getAbsolutePath();
        SegIter theEntryIter = SegIter.makeBackwardsIter(Key.sKey, inResourceManifest);
        while (theEntryIter.hasMoreSubfiles()) {
            SegEntry theEntry = theEntryIter.getNextSubfile();
            VersionNumber theBackRef = theEntry.getBackRef();
            if (theBackRef != null && !theIncludedVersions.contains(theBackRef)) continue;
            String theRelPath = ResourceParser.stripRoot(theEntry.getRelPathWFwdSlashes());
            File theSubFile = new File(theDstFilePath, theRelPath);
            NodePerms theNodePerms = theEntry.getPerms();
            if (inGlobalOverridePerms != null) {
                if (theNodePerms == null) {
                    theNodePerms = theDefaultOverriddenPerms;
                } else {
                    theNodePerms.integrateValidFields(inGlobalOverridePerms);
                }
            }
            boolean doesFileExist = false;
            doesFileExist = inMemixSession == null ? ResourceFileUtils.getSubnodeType(theSubFile) != null : ResourceMemixUtils.nodeExists(inMemixSession, theSubFile);
            if (!doesFileExist) {
                if (!Logger.isInfoEnabled(this)) continue;
                Logger.info(ROXMessageManager.messageAsString("rsrc.NONEXISTENT_FILE_SKIPPED", new Object[]{theSubFile}), this);
                continue;
            }
            if (theNodePerms != null) {
                try {
                    if (inMemixSession == null) {
                        PlatformPermissionFactory.getInstance().applyPerms(theNodePerms, theSubFile);
                    } else {
                        PlatformPermissionFactory.getInstance().applyPermsPreflight(theNodePerms, theSubFile, inMemixSession);
                    }
                }
                catch (ResourceException e) {
                    Resource theResource = this.mRsrcCtx.getResource(inResourceID, this.getPushID());
                    throw new ResourceException("rsrc.msg0345", (Throwable)e, new Object[]{theResource.getName()});
                }
            }
            if (inMemixSession == null && theEntry.getTime() != 0L) {
                theSubFile.setLastModified(theEntry.getTime());
            }
            if (theProcesses == null) continue;
            Iterator theIter = theProcesses.iterator();
            while (theIter.hasNext()) {
                ResourceProcess theProcess = (ResourceProcess)theIter.next();
                theProcess.afterResourceSubFileExternBottomUp(inResourceID, inResourceDstRoot, theSubFile, theNodePerms);
            }
        }
    }

    public void afterResourceExtern(ResourceID inResourceID, File inResourceDstRoot) throws ResourceProcessException {
        Vector theProcesses = this.mProcesses.getAllProcessesToCall(inResourceID);
        if (theProcesses == null) {
            return;
        }
        Iterator theIter = theProcesses.iterator();
        while (theIter.hasNext()) {
            ResourceProcess theProcess = (ResourceProcess)theIter.next();
            theProcess.afterResourceExtern(inResourceID, inResourceDstRoot);
        }
    }

    boolean getIsDisposing() {
        return this.mDisposing;
    }

    public static RsrcPushImpl makeRepeater(RoxAddress inSrcAddress, PushParams inPushParams, RouteTree inRouteTree, ResourceSubsysImpl inRsrcCtx, TimedSequence inTimedSequence) throws ResourceException {
        return new RsrcPushImpl(inSrcAddress, inPushParams, inRouteTree, inRsrcCtx, inTimedSequence);
    }

    private RsrcPushImpl(RoxAddress inParentPushAddr, PushParams inPushParams, RouteTree inRouteTree, ResourceSubsysImpl inRsrcCtx, TimedSequence inTimedSequence) throws ResourceException {
        this.mPushParams = inPushParams;
        this.mRouteTree = inRouteTree;
        this.mParentPushAddr = inParentPushAddr;
        this.mTimedSequence = inTimedSequence;
        this.finishInit(inRsrcCtx);
    }

    void finishInit(ResourceSubsysImpl inRsrcCtx) throws ResourcePersistenceException, ResourceRouteException, ResourceNotLockableException, ResourceNotLocalException, ResourceException {
        this.mRsrcCtx = inRsrcCtx;
        this.mRsrcCtx.lockRsrcPush(this, this.getNeedResourceLocks());
        if (this.mRsrcCtx.getDoForceFailure()) {
            int theFailMode = this.mRsrcCtx.getForcedPushFailMode();
            if (theFailMode == 0) {
                this.forTestOnly_SetNeverComplete();
            } else {
                this.forTestOnly_GuaranteeOneFailure(theFailMode);
            }
        }
        this.finishTree();
    }

    private void finishTree() {
        this.mRouteTree.markSubtreeEntirely(this.mRsrcCtx, 0, null);
        this.mRouteTree.setRootStatus(2, null);
    }

    int getMaxRouteLength() {
        return this.mRouteTree.getMaxRouteLength();
    }

    public AddrGroup getAddrGroup() {
        return this.mRouteTree.getAllAddrs();
    }

    public PushID getPushID() {
        return this.mPushParams.mPushID;
    }

    Resource[] getResourcesThatNeedLocking() {
        if (this.mPushParams.mIsSimulated) {
            return new Resource[0];
        }
        Vector<Resource> theResults = new Vector<Resource>();
        PushParams.OneRsrcsIter theIter = this.mPushParams.getOneRsrcsIter();
        while (theIter.hasNext()) {
            PushParams.OneRsrc thePRD = theIter.next();
            if (!thePRD.isActualDuringActualPush()) continue;
            theResults.add(thePRD.mResource);
        }
        return theResults.toArray(new Resource[0]);
    }

    private void throwIfErrors() throws ResourcePushFinishedWithErrorsException {
        String theEOL = System.getProperty("line.separator");
        AddrGroup theAddrGroup = this.getAddrGroup();
        int theTotalErrors = 0;
        int theInterestingErrors = 0;
        StringBuffer theErrorDetails = new StringBuffer();
        int theMaxInterestingErrors = 10;
        for (int i = 0; i < theAddrGroup.size(); ++i) {
            RoxAddress theAddr = theAddrGroup.get(i);
            int theNodePushStatus = this.getAddrStatus(theAddr);
            if (!NodePushStatus.isError(theNodePushStatus)) continue;
            theErrorDetails.append(theEOL + "  " + ROXMessageManager.messageAsString("rsrc.NodeErrHdr") + " " + theAddr.toString() + " " + ROXMessageManager.messageAsString("rsrc.NodeErrFtr") + " ");
            theErrorDetails.append(NodePushStatus.getVerbiage(theNodePushStatus));
            Exception theNodeException = this.getAddrException(theAddr);
            if (theNodeException != null) {
                String theMessage = theNodeException instanceof RaplixException ? ((RaplixException)theNodeException).getTopLevelStackTrace() : theNodeException.getMessage();
                theErrorDetails.append(theEOL + "    " + ROXMessageManager.messageAsString("rsrc.NodeErrDetail") + " " + theMessage);
            }
            ++theTotalErrors;
            if (theNodePushStatus == -5 || ++theInterestingErrors <= 10) continue;
            theErrorDetails.append(theEOL + ROXMessageManager.messageAsString("rsrc.FurtherErrsSuppressed"));
            break;
        }
        if (theTotalErrors > 0) {
            throw new ResourcePushFinishedWithErrorsException("rsrc.msg0208", new Object[]{"" + theTotalErrors, theErrorDetails});
        }
    }

    public synchronized boolean isActive() throws ResourcePushFinishedWithErrorsException {
        if (this.mPushExec == null || !this.mPushExec.isAlive() || this.mPushExec.isCompleted()) {
            this.throwIfErrors();
            return false;
        }
        return true;
    }

    public synchronized void activate(boolean inSynchronous) throws ResourcePushFinishedWithErrorsException, ResourceException {
        if (this.mDisposing) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("rsrc.IGNORING_PUSH_REACTIVATE"), this);
            }
            return;
        }
        this.mPushedAtLeastOnce = true;
        if (this.mRouteTree.size() == 0) {
            return;
        }
        this.mResetCount = true;
        if (!this.isActive()) {
            this.mPushExec = new PushExec();
            this.mPushExec.start();
        }
        if (inSynchronous) {
            try {
                this.waitForCompletion();
            }
            catch (InterruptedException e) {
                block9: {
                    try {
                        this.dispose();
                    }
                    catch (Exception ex) {
                        if (!Logger.isErrorEnabled(this)) break block9;
                        Logger.error(ROXMessageManager.messageAsString("rsrc.DISPOSE_EXCEPTION"), ex, this);
                    }
                }
                throw new ResourcePushFinishedWithErrorsException("rsrc.msg0215", (Throwable)e);
            }
            this.throwIfErrors();
        }
    }

    private synchronized void waitForCompletion() throws InterruptedException {
        if (this.mPushExec != null) {
            this.mPushExec.waitForCompletion();
        }
    }

    public long forTestOnly_GetBytesStreamed() {
        return this.mRsrcCtx.getBytesStreamed(this.mPushParams.mPushID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws ResourcePersistenceException, ResourceRouteException, ResourceException {
        Object object = this;
        synchronized (object) {
            if (this.mDisposing) {
                return;
            }
            this.mDisposing = true;
        }
        this.mRsrcCtx.cleanUpPushData(this.mPushParams.mPushID);
        if (this.mPushExec != null) {
            this.mPushExec.interruptSafe();
        }
        if (this.mPushParams.mForTestOnly_DisposeSync) {
            this.notifyDownstreamsOfDispose();
        } else {
            new SafeThread(){

                public void run() {
                    RsrcPushImpl.this.notifyDownstreamsOfDispose();
                }
            }.start();
        }
        this.mRsrcCtx.unlockRsrcPush(this, this.getNeedResourceLocks());
        if (!this.mRsrcCtx.isServer()) {
            object = this.mRsrcCtx.getRepoContentSyncObj();
            synchronized (object) {
                ResourceFileUtils.deleteDirectory(this.getVirtualPushDir());
                this.mRsrcCtx.adjustTotalRepoSize(-this.mPushParams.getVirtualResourceSize());
            }
        }
    }

    private void notifyDownstreamsOfDispose() {
        RouteTree.Iter theIter = this.mRouteTree.iterator();
        while (theIter.hasNext()) {
            try {
                this.mRsrcCtx.sendPushRelease(this.getPushID(), theIter.next().getRootAddress());
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(ROXMessageManager.messageAsString("rsrc.SENDPUSHRELEASE_EXCEPTION"), this);
            }
        }
    }

    public int getAddrStatus(RoxAddress inAddress) {
        int theStatus = -1;
        RouteTree theRouteTree = this.mRouteTree.getRouteTree(inAddress);
        if (theRouteTree != null) {
            theStatus = theRouteTree.getRootStatus();
        }
        return theStatus;
    }

    public boolean addrInPush(RoxAddress inAddress) {
        return this.mRouteTree.getRouteTree(inAddress) != null;
    }

    public Exception getAddrException(RoxAddress inAddress) {
        ResourceException theException = null;
        RouteTree theRouteTree = this.mRouteTree.getRouteTree(inAddress);
        if (theRouteTree != null) {
            theException = theRouteTree.getRootException();
        }
        return theException;
    }

    private boolean updateStatus(RouteTree inRouteTree, int inNodePushStatus, ResourceException inException) {
        if (inNodePushStatus == 3) {
            inRouteTree.markAnyUnterminated(this.mRsrcCtx);
            return this.sendStatusToParent(inRouteTree, inNodePushStatus, inException);
        }
        if (NodePushStatus.isError(inNodePushStatus)) {
            inRouteTree.markCascadingErrors(this.mRsrcCtx, inNodePushStatus, inException);
            return this.sendStatusToParent(inRouteTree, inNodePushStatus, inException);
        }
        inRouteTree.setRootStatus(inNodePushStatus, inException);
        return this.sendStatusToParent(inRouteTree, inNodePushStatus, inException);
    }

    private boolean sendStatusToParent(RouteTree inRouteTree, int inNodePushStatus, ResourceException inException) {
        return this.mRsrcCtx.sendStatusToParent(this.mParentPushAddr, this.mPushParams.mPushID, inRouteTree.getRootAddress(), inNodePushStatus, inException);
    }

    void queueStatusUpdate(RoxAddress inAddress, int inNodePushStatus, ResourceException inException) {
        this.mStatusReceived.add(inAddress, inNodePushStatus, inException);
    }

    public void forTestOnly_SetNeverComplete() {
        if (this.mPushedAtLeastOnce) {
            throw new IllegalStateException();
        }
        this.mForTestOnly_NeverComplete = true;
    }

    public void forTestOnly_GuaranteeOneFailure(int inErrorToUse) {
        if (this.mPushedAtLeastOnce) {
            throw new IllegalStateException();
        }
        this.mForTestOnly_GuaranteeOneFailure = true;
        this.mForTestOnly_ErrorCode = inErrorToUse;
    }

    static class ProcessMap
    implements RPCSerializable {
        private static ResourceID sNullID = new ResourceID("ProcessMap null resource");
        private Hashtable mResourceIDToProcessHash = new Hashtable();

        ProcessMap() {
        }

        void addProcess(ResourceID inResourceID, ResourceProcess inProcess) {
            Vector<ResourceProcess> theVector;
            if (inProcess == null) {
                throw new NullPointerException(ROXMessageManager.messageAsString("rsrc.NULL_IN_ADDPROCESS "));
            }
            if (inResourceID == null) {
                inResourceID = sNullID;
            }
            if ((theVector = (Vector<ResourceProcess>)this.mResourceIDToProcessHash.get(inResourceID)) == null) {
                theVector = new Vector<ResourceProcess>();
                this.mResourceIDToProcessHash.put(inResourceID, theVector);
            }
            theVector.add(inProcess);
        }

        Vector getAllProcessesToCall(ResourceID inResourceID) {
            Vector theResourceSpecificProcesses;
            if (inResourceID == null) {
                throw new NullPointerException(ROXMessageManager.messageAsString("rsrc.NULL_IN_GETALLPROCESSESTOCALL "));
            }
            Vector theProcesses = new Vector();
            Vector theGroupProcesses = (Vector)this.mResourceIDToProcessHash.get(sNullID);
            if (theGroupProcesses != null) {
                theProcesses.addAll(theGroupProcesses);
            }
            if ((theResourceSpecificProcesses = (Vector)this.mResourceIDToProcessHash.get(inResourceID)) != null) {
                theProcesses.addAll(theResourceSpecificProcesses);
            }
            return theProcesses;
        }
    }

    static class StatusReceived {
        private Vector mStatuses = new Vector();

        StatusReceived() {
        }

        synchronized void add(RoxAddress inAddress, int inNodePushStatus, ResourceException inException) {
            if (inNodePushStatus != 1) {
                this.mStatuses.add(new AddressStatusPair(inAddress, inNodePushStatus, inException));
            }
        }

        synchronized AddressStatusPair readFirst() {
            return (AddressStatusPair)this.mStatuses.firstElement();
        }

        synchronized AddressStatusPair popFirst() {
            AddressStatusPair theAddressStatusPair = (AddressStatusPair)this.mStatuses.firstElement();
            this.mStatuses.remove(0);
            return theAddressStatusPair;
        }

        synchronized int size() {
            return this.mStatuses.size();
        }
    }

    static class AddressStatusPair {
        RoxAddress mAddress = null;
        int mNodePushStatus = 0;
        ResourceException mException = null;

        AddressStatusPair(RoxAddress inAddress, int inNodePushStatus, ResourceException inException) {
            this.mAddress = inAddress;
            this.mNodePushStatus = inNodePushStatus;
            this.mException = inException;
        }
    }

    private class PushExec
    extends SafeThread {
        private boolean mCompleted = false;

        private PushExec() {
        }

        synchronized boolean isCompleted() {
            return this.mCompleted;
        }

        synchronized void waitForCompletion() throws InterruptedException {
            while (!this.mCompleted) {
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            boolean isUpstreamExhausted;
            ResourceException theTopLevelException;
            block33: {
                theTopLevelException = null;
                isUpstreamExhausted = false;
                RsrcPushImpl.this.mNextAddrIdx = 0;
                RsrcPushImpl.this.mResetCount = false;
                while ((RsrcPushImpl.this.mRouteTree.expectingMoreStatus() || RsrcPushImpl.this.mStatusReceived.size() > 0) && !RsrcPushImpl.this.mDisposing) {
                    if (RsrcPushImpl.this.mForTestOnly_NeverComplete) {
                        Thread.sleep(1000L);
                    } else {
                        while (RsrcPushImpl.this.mNextAddrIdx < RsrcPushImpl.this.mRouteTree.size() && !RsrcPushImpl.this.mDisposing) {
                            RouteTree theSubRouteTree = RsrcPushImpl.this.mRouteTree.getSubRouteTreeByIdx(RsrcPushImpl.this.mNextAddrIdx);
                            if (RsrcPushImpl.this.mForTestOnly_GuaranteeOneFailure && RsrcPushImpl.this.mNextAddrIdx == 0) {
                                RsrcPushImpl.this.mStatusReceived.add(theSubRouteTree.getRootAddress(), RsrcPushImpl.this.mForTestOnly_ErrorCode, null);
                            } else {
                                int thePushStatus = theSubRouteTree.getRootStatus();
                                if (thePushStatus != 1 && thePushStatus != 2) {
                                    int theResultNodePushStatus = -1;
                                    ResourceException theSendPushException = null;
                                    try {
                                        theResultNodePushStatus = RsrcPushImpl.this.mRsrcCtx.sendPush(RsrcPushImpl.this.mPushParams, theSubRouteTree, RsrcPushImpl.this.mTimedSequence);
                                    }
                                    catch (Exception e) {
                                        if (Logger.isErrorEnabled(this)) {
                                            Logger.error(ROXMessageManager.messageAsString("rsrc.SENDPUSH_EXCEPTION"), e, this);
                                        }
                                        theResultNodePushStatus = -1;
                                        theSendPushException = MiscUtils.resourceWrap(e);
                                    }
                                    RsrcPushImpl.this.mStatusReceived.add(theSubRouteTree.getRootAddress(), theResultNodePushStatus, theSendPushException);
                                }
                            }
                            ++RsrcPushImpl.this.mNextAddrIdx;
                        }
                    }
                    long theUpdateStart = System.currentTimeMillis();
                    while (RsrcPushImpl.this.mStatusReceived.size() > 0) {
                        AddressStatusPair theAddressStatusPair = RsrcPushImpl.this.mStatusReceived.readFirst();
                        RouteTree theSubRouteTree = RsrcPushImpl.this.mRouteTree.getRouteTree(theAddressStatusPair.mAddress);
                        if (RsrcPushImpl.this.updateStatus(theSubRouteTree, theAddressStatusPair.mNodePushStatus, theAddressStatusPair.mException)) {
                            RsrcPushImpl.this.mStatusReceived.popFirst();
                            continue;
                        }
                        if (RsrcPushImpl.this.mNextAddrIdx < RsrcPushImpl.this.mRouteTree.size()) break;
                        if (System.currentTimeMillis() - theUpdateStart > RsrcPushImpl.this.mUpstreamMaxUpdateAttemptSecs * 1000L) {
                            isUpstreamExhausted = true;
                            if (!Logger.isErrorEnabled(this)) break;
                            Logger.error(ROXMessageManager.messageAsString("rsrc.PARENT_NODE_TIMEOUT"), this);
                            break;
                        }
                        Thread.sleep(RsrcPushImpl.this.mUpstreamStatusRetrySecs * 1000L);
                    }
                    if (RsrcPushImpl.this.mResetCount) {
                        RsrcPushImpl.this.mNextAddrIdx = 0;
                        RsrcPushImpl.this.mResetCount = false;
                        continue;
                    }
                    PushExec.sleep(1000L);
                }
                Object var9_11 = null;
                try {
                    boolean didUpdate;
                    long theUpdateStart = System.currentTimeMillis();
                    while (!(didUpdate = RsrcPushImpl.this.updateStatus(RsrcPushImpl.this.mRouteTree, RsrcPushImpl.this.mDisposing || theTopLevelException != null ? -1 : 3, theTopLevelException)) && !isUpstreamExhausted && System.currentTimeMillis() - theUpdateStart <= RsrcPushImpl.this.mUpstreamMaxUpdateAttemptSecs * 1000L) {
                        Thread.sleep(RsrcPushImpl.this.mUpstreamStatusRetrySecs * 1000L);
                    }
                }
                catch (Exception ex) {
                    if (!Logger.isErrorEnabled(this)) break block33;
                    Logger.error(ROXMessageManager.messageAsString("rsrc.UPDATE_STATUS_ERROR "), this);
                }
            }
            PushExec pushExec = this;
            synchronized (pushExec) {
                this.mCompleted = true;
                this.notifyAll();
            }
            {
                catch (Exception e) {
                    block34: {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(ROXMessageManager.messageAsString("rsrc.PUSH_EXCEPTION"), e, this);
                            e.printStackTrace();
                        }
                        theTopLevelException = MiscUtils.resourceWrap(e);
                        Object var9_12 = null;
                        try {
                            boolean didUpdate;
                            long theUpdateStart = System.currentTimeMillis();
                            while (!(didUpdate = RsrcPushImpl.this.updateStatus(RsrcPushImpl.this.mRouteTree, RsrcPushImpl.this.mDisposing || theTopLevelException != null ? -1 : 3, theTopLevelException)) && !isUpstreamExhausted && System.currentTimeMillis() - theUpdateStart <= RsrcPushImpl.this.mUpstreamMaxUpdateAttemptSecs * 1000L) {
                                Thread.sleep(RsrcPushImpl.this.mUpstreamStatusRetrySecs * 1000L);
                            }
                        }
                        catch (Exception ex) {
                            if (!Logger.isErrorEnabled(this)) break block34;
                            Logger.error(ROXMessageManager.messageAsString("rsrc.UPDATE_STATUS_ERROR "), this);
                        }
                    }
                    PushExec pushExec2 = this;
                    synchronized (pushExec2) {
                        this.mCompleted = true;
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                block35: {
                    Object var9_13 = null;
                    try {
                        boolean didUpdate;
                        long theUpdateStart = System.currentTimeMillis();
                        while (!(didUpdate = RsrcPushImpl.this.updateStatus(RsrcPushImpl.this.mRouteTree, RsrcPushImpl.this.mDisposing || theTopLevelException != null ? -1 : 3, theTopLevelException)) && !isUpstreamExhausted && System.currentTimeMillis() - theUpdateStart <= RsrcPushImpl.this.mUpstreamMaxUpdateAttemptSecs * 1000L) {
                            Thread.sleep(RsrcPushImpl.this.mUpstreamStatusRetrySecs * 1000L);
                        }
                    }
                    catch (Exception ex) {
                        if (!Logger.isErrorEnabled(this)) break block35;
                        Logger.error(ROXMessageManager.messageAsString("rsrc.UPDATE_STATUS_ERROR "), this);
                    }
                }
                PushExec pushExec3 = this;
                synchronized (pushExec3) {
                    this.mCompleted = true;
                    this.notifyAll();
                }
                throw throwable;
            }
        }
    }
}

