/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.AddrGroup;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceProcess;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcGroup;
import com.raplix.rolloutexpress.resource.RsrcPushImpl;
import com.raplix.rolloutexpress.resource.diffdeploy.ResPath;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.exception.ResourcePushFinishedWithErrorsException;
import com.raplix.rolloutexpress.resource.exception.ResourceRouteException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class RsrcPush {
    private RsrcPushImpl mImpl = null;

    public RsrcPush(RsrcGroup inRsrcGroup, HostID inHostID, ResourceSubsystem inRsrcCtx, boolean inIsSimulated) throws ResourceException {
        if (inRsrcCtx.getPreparingForShutdown()) {
            throw new ResourceException("rsrc.msg0194");
        }
        AddrGroup theAddrs = new AddrGroup();
        if (inHostID != null) {
            try {
                RoxAddress theHostAddress = inHostID.getByIDQuery().select().getRARoxAddress();
                theAddrs.add(theHostAddress);
            }
            catch (RPCException e) {
                throw new ResourceException(e);
            }
            catch (HostDBException e) {
                throw new ResourceException(e);
            }
            catch (PersistenceManagerException e) {
                throw new ResourceException(e);
            }
        }
        this.mImpl = new RsrcPushImpl(inRsrcGroup, theAddrs, inRsrcCtx, inIsSimulated, inHostID);
    }

    public RsrcPush(RsrcGroup inRsrcGroup, AddrGroup inAddrGroup, ResourceSubsystem inRsrcCtx, boolean inIsSimulated) throws ResourceException {
        if (inRsrcCtx.getPreparingForShutdown()) {
            throw new ResourceException("rsrc.msg0194");
        }
        int theNumResources = inRsrcGroup.size();
        for (int i = 0; i < theNumResources; ++i) {
            ResPath theResPath = inRsrcGroup.getResPath(i);
            if (theResPath.getDeployPath() == null) continue;
            throw new ResourceException("rsrc.msg0454");
        }
        this.mImpl = new RsrcPushImpl(inRsrcGroup, inAddrGroup, inRsrcCtx, inIsSimulated, null);
    }

    RsrcPush(RsrcPushImpl inRsrcPushImpl) {
        this.mImpl = inRsrcPushImpl;
    }

    public boolean getIsSimulated() {
        return this.mImpl.getIsSimulated();
    }

    public int getMaxRouteLength() {
        return this.mImpl.getMaxRouteLength();
    }

    public void dispose() throws ResourcePersistenceException, ResourceRouteException, ResourceException {
        this.mImpl.dispose();
    }

    public long forTestOnly_GetBytesStreamed() {
        return this.mImpl.forTestOnly_GetBytesStreamed();
    }

    public void forTestOnly_SetRoute(RoxAddress[] inRoute) throws ResourceException {
        this.mImpl.forTestOnly_SetRoute(inRoute);
    }

    public void forTestOnly_SetDisposeSynchronous() {
        this.mImpl.forTestOnly_SetDisposeSynchronous();
    }

    public void addProcess(ResourceProcess inProcess, ResourceID inResourceID) throws ResourceException {
        this.mImpl.addProcess(inProcess, inResourceID);
    }

    public boolean isActiveNow() throws ResourcePushFinishedWithErrorsException {
        return this.mImpl.isActive();
    }

    public AddrGroup getAddrGroup() {
        return this.mImpl.getAddrGroup();
    }

    public PushID getPushID() {
        return this.mImpl.getPushID();
    }

    public void activateNow(boolean inSynchronous) throws ResourcePushFinishedWithErrorsException, ResourceException {
        this.mImpl.activate(inSynchronous);
    }

    public int getAddrStatus(RoxAddress inAddress) throws ResourceRouteException {
        return this.mImpl.getAddrStatus(inAddress);
    }

    public String getDiffSuppressedPath(ResourceID inResourceID) {
        return this.mImpl.getDiffSuppressedPath(inResourceID);
    }

    public RsrcManifest getVirtualManifest(ResourceID inResourceID) throws ResourceException {
        return this.mImpl.getVirtualManifest(inResourceID);
    }
}

