/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.util.TransPackageKeys;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Date;

public class RsrcInfo
implements RPCSerializable,
StandardObject,
HasObjectID,
PluginMember {
    private Resource mResource = new Resource();

    public static String getFileTypeName() {
        return "file";
    }

    public static String getDirTypeName() {
        return "directory";
    }

    private RsrcInfo() {
    }

    Resource getImpl() {
        return this.mResource;
    }

    public RsrcInfo(Resource inResource) {
        this.mResource = inResource;
    }

    public ObjectID getObjectID() {
        return this.getResourceID();
    }

    public ResourceID getResourceID() {
        return this.mResource.getResourceID();
    }

    public ResourceSpec getResourceSpec() {
        return this.mResource.getResourceSpec();
    }

    public boolean getHierarchical() {
        return this.mResource.getIsHierarchical();
    }

    public boolean getConfigurable() {
        return this.mResource.getIsConfigurable();
    }

    public String getTypeName() {
        return this.mResource.getType();
    }

    public String getName() {
        return this.getResourceSpec().getName();
    }

    public Visibility getVisibility() {
        return this.mResource.getVisibility();
    }

    public String getDescription() {
        return this.mResource.getDescription();
    }

    public Date getCheckInTime() {
        return this.mResource.getCheckInTime();
    }

    public UserID getCheckInUserID() {
        return this.mResource.getCheckInUserID();
    }

    public String getSourcePath() {
        return this.mResource.getSourcePath();
    }

    public HostID getSourceHostID() {
        return this.mResource.getSourceHostID();
    }

    public HostSetID getPlatform() {
        return this.mResource.getPlatform();
    }

    public VersionNumber getVersionNumber() {
        return this.mResource.getVersionNumber();
    }

    public PluginID getPluginID() {
        return this.mResource.getPluginID();
    }

    public boolean equals(Object inObj) {
        if (inObj == null || !(inObj instanceof RsrcInfo)) {
            return false;
        }
        Resource theOtherImpl = ((RsrcInfo)inObj).getImpl();
        return this.mResource.equals(theOtherImpl);
    }

    public int hashCode() {
        return this.mResource.hashCode();
    }

    public CategoryIDSet getCategories() throws PersistenceManagerException, RPCException {
        return (CategoryIDSet)this.mResource.getCategories().clone();
    }

    public void setCategories(CategoryIDSet categories) {
        this.mResource.setCategories((CategoryIDSet)categories.clone());
    }

    protected void save() throws PersistenceManagerException {
        this.getImpl().save();
    }

    public ObjectID getRootObjectID() {
        return this.getImpl().getRootObjectID();
    }

    public Resource getResource(Object inKey) {
        TransPackageKeys.verifyResourceKey(inKey);
        return this.getImpl();
    }
}

